/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.animations.AnimationRegistry;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.ToolRequirementType;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.recipetypes.ImmersiveCraftingRecipe;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.ImmersiveRecipeSelectionMenu;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.SmithingItemPropertyManager;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ImmersiveRecipeListener
implements Listener {
    private final Collection<Material> immersiveBlocks = ItemUtils.getMaterialSet(ValhallaMMO.getPluginConfig().getStringList("immersive_on_regular_click"));
    private static final Map<UUID, ImmersiveCraftingRecipe> selectedImmersiveRecipe = new HashMap<UUID, ImmersiveCraftingRecipe>();
    private final Map<Material, Collection<ImmersiveCraftingRecipe>> immersiveRecipeCache = new HashMap<Material, Collection<ImmersiveCraftingRecipe>>();
    private final Map<UUID, RecipeFrequencyDO> recipeFrequency = new HashMap<UUID, RecipeFrequencyDO>();

    public static Map<UUID, ImmersiveCraftingRecipe> getSelectedImmersiveRecipe() {
        return selectedImmersiveRecipe;
    }

    @EventHandler
    public void onBlockInteract(PlayerInteractEvent e) {
        Player p;
        Block clicked = e.getClickedBlock();
        if (clicked == null) {
            return;
        }
        boolean disableVanillaMenu = ItemUtils.getMaterialSet(ValhallaMMO.getPluginConfig().getStringList("disable_vanilla_menu")).contains(clicked.getType());
        if (clicked.getType().isInteractable() && (disableVanillaMenu || !Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "cancel_block_interactions"))) {
            e.setCancelled(true);
        }
        if (!Timer.isCooldownPassed((p = e.getPlayer()).getUniqueId(), "delay_crafting_attempts")) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            selectedImmersiveRecipe.remove(p.getUniqueId());
        }
        if (e.useInteractedBlock() == Event.Result.DENY || e.getHand() != EquipmentSlot.HAND || e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!CustomRecipeRegistry.getImmersiveRecipesByBlock().containsKey(ItemUtils.getBaseMaterial(clicked.getType()))) {
            return;
        }
        if (Timer.getTimerResult(p.getUniqueId(), "time_held_immersive_interact") == 0L) {
            Timer.startTimer(p.getUniqueId(), "time_held_immersive_interact");
        }
        if (Timer.getTimerResult(p.getUniqueId(), "time_since_immersive_interact") == 0L) {
            Timer.startTimer(p.getUniqueId(), "time_since_immersive_interact");
        }
        boolean openImmersiveMenu = !p.isSneaking() == this.immersiveBlocks.contains(clicked.getType());
        ItemStack heldItem = p.getInventory().getItemInMainHand();
        ImmersiveCraftingRecipe recipe = selectedImmersiveRecipe.get(p.getUniqueId());
        if (!ItemUtils.isEmpty(heldItem) && recipe == null && !openImmersiveMenu && Timer.isCooldownPassed(p.getUniqueId(), "delay_tinkering_attempts")) {
            Collection<ImmersiveCraftingRecipe> tinkerRecipes = this.getTinkerRecipes(p, clicked.getType());
            if (tinkerRecipes.size() == 1) {
                recipe = tinkerRecipes.stream().findFirst().orElse(null);
            } else {
                Timer.setCooldown(p.getUniqueId(), 1000, "delay_tinkering_attempts");
            }
            if (recipe != null) {
                if (!recipe.getTinkerInput().getOption().matches(recipe.getTinkerInput().getItem(), heldItem)) {
                    recipe = selectedImmersiveRecipe.get(p.getUniqueId());
                } else if (!recipe.getIngredients().isEmpty() && p.getGameMode() != GameMode.CREATIVE && ItemUtils.timesContained(Arrays.asList(p.getInventory().getStorageContents()), recipe.getIngredients(), recipe.getMetaRequirement().getChoice()) <= 0) {
                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.chat(TranslationManager.getTranslation("error_crafting_no_ingredients"))));
                    Timer.setCooldown(p.getUniqueId(), 500, "delay_crafting_attempts");
                    return;
                }
            }
        }
        if (recipe == null && openImmersiveMenu) {
            new ImmersiveRecipeSelectionMenu(PlayerMenuUtilManager.getPlayerMenuUtility(p), clicked, ItemUtils.isEmpty(heldItem)).open();
            e.setCancelled(true);
            return;
        }
        if (recipe != null) {
            boolean properItemHeld;
            ItemBuilder held;
            e.setCancelled(true);
            if (Timer.getTimerResult(p.getUniqueId(), "time_since_immersive_interact") > 500L) {
                Timer.startTimer(p.getUniqueId(), "time_held_immersive_interact");
            }
            ItemBuilder itemBuilder = held = ItemUtils.isEmpty(heldItem) ? null : new ItemBuilder(heldItem);
            boolean bl = recipe.tinker() ? held != null && recipe.getTinkerInput().getOption().matches(recipe.getTinkerInput().getItem(), heldItem) && (!recipe.requiresValhallaTools() || SmithingItemPropertyManager.hasSmithingQuality(held.getMeta())) : (properItemHeld = recipe.getToolRequirement().canCraft(held == null ? -1 : ToolRequirementType.getToolID(held.getMeta())));
            if (!(ItemUtils.isSimilarMaterial(recipe.getBlock(), clicked.getType()) && this.canPlayerCraft(e, recipe) && properItemHeld)) {
                selectedImmersiveRecipe.remove(p.getUniqueId());
                this.resetFrequency(e.getPlayer());
                return;
            }
            long interactedFor = Timer.getTimerResult(p.getUniqueId(), "time_held_immersive_interact");
            if (interactedFor < 100L || interactedFor >= (long)recipe.getTimeToCraft() * 50L) {
                PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
                if (profile == null || !p.hasPermission("valhalla.allrecipes") && !recipe.isUnlockedForEveryone() && !profile.getUnlockedRecipes().contains(recipe.getName()) && !p.hasPermission("valhalla.recipe." + recipe.getName()) || ValhallaMMO.isWorldBlacklisted(p.getWorld().getName()) || WorldGuardHook.inDisabledRegion(clicked.getLocation(), "vmmo-crafting-immersive") || recipe.getValidations().stream().anyMatch(v -> {
                    Validation validation = ValidationRegistry.getValidation(v);
                    if (validation != null) {
                        boolean invalid;
                        boolean bl = invalid = !validation.validate(clicked);
                        if (invalid) {
                            Utils.sendActionBar(p, validation.validationError());
                        }
                        return invalid;
                    }
                    return false;
                })) {
                    this.resetFrequency(p);
                    selectedImmersiveRecipe.remove(p.getUniqueId());
                    Timer.startTimer(p.getUniqueId(), "time_held_immersive_interact");
                    Timer.setCooldown(p.getUniqueId(), 500, "delay_crafting_attempts");
                    return;
                }
                if (interactedFor >= (long)recipe.getTimeToCraft() * 50L) {
                    if (p.getGameMode() == GameMode.CREATIVE || ItemUtils.timesContained(Arrays.asList(p.getInventory().getStorageContents()), recipe.getIngredients(), recipe.getMetaRequirement().getChoice()) > 0) {
                        ArrayList<ItemStack> removedItems;
                        List<ItemStack> list = removedItems = p.getGameMode() == GameMode.CREATIVE ? new ArrayList<ItemStack>() : ItemUtils.removeItems((Inventory)p.getInventory(), recipe.getIngredients(), 1, recipe.getMetaRequirement().getChoice());
                        if (removedItems != null) {
                            ItemBuilder result;
                            ItemBuilder itemBuilder2 = result = recipe.tinker() ? held : new ItemBuilder(recipe.getResult());
                            if (result == null || ItemUtils.isEmpty(result.getItem()) || CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                                Utils.sendMessage((CommandSender)p, ItemUtils.getPDCString(DynamicItemModifier.ERROR_MESSAGE, heldItem, ""));
                                selectedImmersiveRecipe.remove(p.getUniqueId());
                            } else {
                                if (recipe.tinker()) {
                                    result.amount(1);
                                }
                                DynamicItemModifier.modify(ModifierContext.builder(result).items(removedItems).crafter(p).executeUsageMechanics().validate().get(), recipe.getModifiers());
                                if (CustomFlag.hasFlag(result.getMeta(), CustomFlag.UNCRAFTABLE)) {
                                    Utils.sendMessage((CommandSender)p, ItemUtils.getPDCString(DynamicItemModifier.ERROR_MESSAGE, heldItem, ""));
                                    selectedImmersiveRecipe.remove(p.getUniqueId());
                                    return;
                                }
                                Animation animation = AnimationRegistry.getAnimation(AnimationRegistry.BLOCK_SPARKS_CRAFTSOUND.id());
                                if (animation != null) {
                                    animation.animate((LivingEntity)p, clicked.getLocation(), p.getEyeLocation().getDirection(), 0);
                                }
                                this.incrementPlayerCraftFrequency(e.getPlayer(), recipe);
                                if (recipe.tinker()) {
                                    if (heldItem.getAmount() <= 1) {
                                        p.getInventory().setItemInMainHand(result.get());
                                    } else {
                                        heldItem.setAmount(heldItem.getAmount() - 1);
                                        ItemUtils.addItem(p, result.get(), true);
                                    }
                                } else if (ValhallaMMO.getPluginConfig().getBoolean("craft_item_drop", true)) {
                                    Item itemDrop = e.getPlayer().getWorld().dropItem(clicked.getLocation().add(0.5, 1.2, 0.5), result.get());
                                    itemDrop.setPickupDelay(0);
                                    itemDrop.setOwner(e.getPlayer().getUniqueId());
                                    itemDrop.setThrower(e.getPlayer().getUniqueId());
                                } else {
                                    e.getPlayer().getInventory().addItem(new ItemStack[]{result.get()});
                                }
                                if (recipe.destroysStation()) {
                                    ValhallaMMO.getNms().blockParticleAnimation(clicked);
                                    clicked.setType(Material.AIR);
                                }
                                recipe.getValidations().forEach(v -> {
                                    Validation validation = ValidationRegistry.getValidation(v);
                                    if (validation != null) {
                                        validation.execute(clicked);
                                    }
                                });
                            }
                        }
                    } else {
                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.chat(TranslationManager.getTranslation("error_crafting_no_ingredients"))));
                    }
                    Timer.startTimer(p.getUniqueId(), "time_held_immersive_interact");
                }
            } else if (Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "sound_craft")) {
                Animation animation = AnimationRegistry.getAnimation(AnimationRegistry.BLOCK_PARTICLE_PUFF.id());
                if (animation != null) {
                    animation.animate((LivingEntity)p, clicked.getLocation(), p.getEyeLocation().getDirection(), 0);
                }
                Timer.setCooldown(e.getPlayer().getUniqueId(), 200, "sound_craft");
            }
        }
        Timer.startTimer(p.getUniqueId(), "time_since_immersive_interact");
    }

    private Collection<ImmersiveCraftingRecipe> getTinkerRecipes(Player crafter, Material block) {
        ItemStack mainHand = crafter.getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(mainHand)) {
            return new ArrayList<ImmersiveCraftingRecipe>();
        }
        Collection heldTypeRecipes = this.immersiveRecipeCache.getOrDefault(mainHand.getType(), new HashSet());
        Material base = ItemUtils.getBaseMaterial(block);
        for (ImmersiveCraftingRecipe r2 : CustomRecipeRegistry.getImmersiveRecipesByBlock().get(base)) {
            if (!r2.tinker() || heldTypeRecipes.contains(r2)) continue;
            heldTypeRecipes.add(r2);
        }
        this.immersiveRecipeCache.put(mainHand.getType(), heldTypeRecipes);
        return heldTypeRecipes.stream().filter(r -> r.getTinkerInput().getOption().matches(r.getTinkerInput().getItem(), mainHand)).collect(Collectors.toSet());
    }

    private void resetFrequency(Player p) {
        this.recipeFrequency.remove(p.getUniqueId());
    }

    private void incrementPlayerCraftFrequency(Player p, ImmersiveCraftingRecipe recipe) {
        if (recipe == null) {
            return;
        }
        if (recipe.getConsecutiveCrafts() == -1) {
            return;
        }
        RecipeFrequencyDO frequencyDO = this.recipeFrequency.getOrDefault(p.getUniqueId(), new RecipeFrequencyDO(0, recipe));
        if (!frequencyDO.recipe.getName().equals(recipe.getName())) {
            frequencyDO = new RecipeFrequencyDO(0, recipe);
        }
        frequencyDO.setFrequency(frequencyDO.getFrequency() + 1);
        this.recipeFrequency.put(p.getUniqueId(), frequencyDO);
    }

    private boolean canPlayerCraft(PlayerInteractEvent e, ImmersiveCraftingRecipe recipe) {
        if (recipe == null || e.getPlayer().getGameMode() == GameMode.CREATIVE || recipe.getConsecutiveCrafts() <= 0) {
            return true;
        }
        Player p = e.getPlayer();
        RecipeFrequencyDO frequencyDO = this.recipeFrequency.getOrDefault(p.getUniqueId(), new RecipeFrequencyDO(0, recipe));
        if (!frequencyDO.getRecipe().getName().equals(recipe.getName())) {
            this.recipeFrequency.put(p.getUniqueId(), new RecipeFrequencyDO(0, recipe));
            frequencyDO = this.recipeFrequency.get(p.getUniqueId());
        }
        return frequencyDO.getFrequency() < recipe.getConsecutiveCrafts();
    }

    private static class RecipeFrequencyDO {
        private int frequency;
        private ImmersiveCraftingRecipe recipe;

        public RecipeFrequencyDO(int frequency, ImmersiveCraftingRecipe recipe) {
            this.frequency = frequency;
            this.recipe = recipe;
        }

        public ImmersiveCraftingRecipe getRecipe() {
            return this.recipe;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public void setRecipe(ImmersiveCraftingRecipe recipe) {
            this.recipe = recipe;
        }

        public void setFrequency(int frequency) {
            this.frequency = frequency;
        }
    }
}

