/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.FoodClass;
import me.athlaeos.valhallammo.item.FoodPropertyManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class ItemConsumptionListener
implements Listener {
    private final Collection<UUID> cancelNextFoodEffects = new HashSet<UUID>();
    private final Collection<UUID> cancelNextFoodEvent = new HashSet<UUID>();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent e) {
        ItemStack item = e.getItem();
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || ItemUtils.isEmpty(item)) {
            return;
        }
        Player p = e.getPlayer();
        for (PotionEffectWrapper wrapper : PotionEffectRegistry.getStoredEffects(ItemUtils.getItemMeta(item), false).values()) {
            if (!wrapper.isVanilla()) {
                PotionEffectRegistry.addEffect((LivingEntity)p, null, new CustomPotionEffect(wrapper, (int)wrapper.getDuration(), wrapper.getAmplifier()), false, 1.0, EntityPotionEffectEvent.Cause.POTION_DRINK);
                continue;
            }
            p.addPotionEffect(new PotionEffect(wrapper.getVanillaEffect(), (int)wrapper.getDuration(), (int)wrapper.getAmplifier()));
        }
        ItemMeta meta = ItemUtils.getItemMeta(item);
        if (meta == null) {
            return;
        }
        FoodClass type = FoodPropertyManager.getFoodClass(item, meta);
        double multiplier = 1.0 + (type == null ? 0.0 : AccumulativeStatManager.getCachedStats("FOOD_BONUS_" + String.valueOf((Object)type), (Entity)e.getPlayer(), 10000L, true));
        int hungerBefore = e.getPlayer().getFoodLevel();
        float saturationBefore = e.getPlayer().getSaturation();
        if (FoodPropertyManager.isCustomFood(meta)) {
            if (FoodPropertyManager.shouldCancelDefaultPotionEffects(meta)) {
                this.cancelNextFoodEffects.add(e.getPlayer().getUniqueId());
            }
            this.cancelNextFoodEvent.add(e.getPlayer().getUniqueId());
            int foodToReplenish = FoodPropertyManager.getFoodValue(item, meta);
            float saturationToReplenish = FoodPropertyManager.getSaturationValue(item, meta);
            foodToReplenish = (int)Math.round(multiplier * (double)foodToReplenish);
            int finalFoodToReplenish = foodToReplenish;
            float finalSaturationToReplenish = saturationBefore + (saturationToReplenish *= (float)multiplier);
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                this.cancelNextFoodEffects.remove(e.getPlayer().getUniqueId());
                this.cancelNextFoodEvent.remove(e.getPlayer().getUniqueId());
                FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)e.getPlayer(), Math.max(0, Math.min(20, hungerBefore + finalFoodToReplenish)), item);
                ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    e.getPlayer().setFoodLevel(Math.max(0, Math.min(20, event.getFoodLevel())));
                    e.getPlayer().setSaturation(Math.max(0.0f, Math.min(20.0f, finalSaturationToReplenish)));
                }
            }, 1L);
        } else {
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                int hungerDifference = e.getPlayer().getFoodLevel() - hungerBefore;
                float saturationDifference = e.getPlayer().getSaturation() - saturationBefore;
                int newFoodLevel = hungerBefore + (int)Math.round((double)hungerDifference * multiplier);
                float newSaturationLevel = saturationBefore + saturationDifference * (float)multiplier;
                FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)e.getPlayer(), Math.max(0, Math.min(20, newFoodLevel)), item);
                ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    e.getPlayer().setFoodLevel(Math.max(0, Math.min(20, event.getFoodLevel())));
                    e.getPlayer().setSaturation(Math.max(0.0f, Math.min(20.0f, newSaturationLevel)));
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void cancelHunger(FoodLevelChangeEvent e) {
        if (this.cancelNextFoodEvent.contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHungerEvent(EntityExhaustionEvent e) {
        HumanEntity humanEntity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((humanEntity = e.getEntity()) instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        if (e.getExhaustion() > 0.0f) {
            double chance = AccumulativeStatManager.getCachedStats("HUNGER_SAVE_CHANCE", (Entity)e.getEntity(), 10000L, true);
            float exhaustion = (float)((double)e.getExhaustion() * (1.0 / (1.0 + Math.max((double)-0.999f, chance))));
            e.setExhaustion(exhaustion);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFoodPotionEffect(EntityPotionEffectEvent e) {
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getEntity()) instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (e.getCause() == EntityPotionEffectEvent.Cause.FOOD) {
            PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
            if (this.cancelNextFoodEffects.contains(e.getEntity().getUniqueId())) {
                e.setCancelled(true);
            } else if (e.getNewEffect() != null && profile.isBadFoodImmune() && EffectClass.getClass(e.getNewEffect().getType()) == EffectClass.DEBUFF) {
                e.setCancelled(true);
            }
        }
    }
}

