/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import me.athlaeos.valhallammo.item.CustomDurabilityManager;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.ItemSkillRequirements;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemDamageListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDurabilityChange(PlayerItemDamageEvent e) {
        ItemBuilder builder;
        if (e.getDamage() == 0) {
            return;
        }
        double durabilityBonus = AccumulativeStatManager.getCachedStats("DURABILITY_BONUS", (Entity)e.getPlayer(), 10000L, true);
        ItemStack itemStack = e.getItem();
        ItemBuilder itemBuilder = builder = ItemUtils.isEmpty(itemStack) ? null : new ItemBuilder(itemStack);
        if (builder == null) {
            return;
        }
        double multiplier = (durabilityBonus += ItemSkillRequirements.getPenalty(e.getPlayer(), builder, "durability")) < 0.0 ? -durabilityBonus - 1.0 : 1.0 / (durabilityBonus + 1.0);
        e.setDamage(Utils.randomAverage((double)e.getDamage() * Math.max(0.0, multiplier)));
        if (CustomDurabilityManager.hasCustomDurability(builder.getMeta())) {
            CustomDurabilityManager.damage(builder, e.getDamage());
            if (CustomDurabilityManager.getDurability(builder, false) > 0) {
                e.setCancelled(true);
                ItemMeta meta = ItemUtils.getItemMeta(builder.get());
                if (meta != null) {
                    ItemUtils.setMetaNoClone(itemStack, meta);
                }
            } else {
                ItemMeta meta = builder.getMeta();
                if (meta instanceof Damageable) {
                    Damageable d = (Damageable)meta;
                    if (itemStack.getType().getMaxDurability() > 0) {
                        d.setDamage((int)itemStack.getType().getMaxDurability());
                        meta = ItemUtils.getItemMeta(builder.get());
                        if (meta != null) {
                            ItemUtils.setMetaNoClone(itemStack, meta);
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onItemMend(PlayerItemMendEvent e) {
        if (ItemUtils.isEmpty(e.getItem())) {
            return;
        }
        ItemBuilder item = new ItemBuilder(e.getItem());
        if (CustomFlag.hasFlag(item.getMeta(), CustomFlag.UNMENDABLE)) {
            e.setCancelled(true);
            return;
        }
        if (CustomDurabilityManager.hasCustomDurability(item.getMeta())) {
            CustomDurabilityManager.damage(item, -e.getRepairAmount());
            e.setCancelled(true);
            ItemMeta meta = ItemUtils.getItemMeta(item.get());
            if (meta == null) {
                return;
            }
            ItemUtils.setMetaNoClone(e.getItem(), meta);
        }
    }
}

