/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.arrow_attributes.ArrowBehaviorRegistry;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ProjectileListener
implements Listener {
    private final Map<Location, ItemStack> dispensedItems = new HashMap<Location, ItemStack>();
    private final double infinityAmmoConsumption = ValhallaMMO.getPluginConfig().getDouble("infinity_ammo_consumption_reduction");
    private final String arrowDamageOverhaulFormula = ConfigManager.getConfig("skills/archery.yml").get().getString("damage_formula_normal");
    private final String arrowCriticalDamageFormula = ConfigManager.getConfig("skills/archery.yml").get().getString("damage_formula_critical");
    private final double arrowDamagePiercingReduction = ConfigManager.getConfig("skills/archery.yml").get().getDouble("damage_piercing_reduction");
    private static final Map<UUID, ItemBuilder> projectileShotByMap = new HashMap<UUID, ItemBuilder>();
    private final Map<UUID, Integer> crossbowReloads = new HashMap<UUID, Integer>();
    private final Collection<UUID> cancelNextArrowEffects = new HashSet<UUID>();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLaunch(ProjectileLaunchEvent e) {
        ProjectileSource direction;
        AbstractArrow a;
        ItemBuilder projectile;
        ThrowableProjectile t;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Projectile projectile2 = e.getEntity();
        if (projectile2 instanceof ThrowableProjectile && !ItemUtils.isEmpty((t = (ThrowableProjectile)projectile2).getItem())) {
            projectile = new ItemBuilder(t.getItem().clone());
            ItemUtils.storeItem((Entity)e.getEntity(), projectile.getItem());
        } else {
            projectile2 = e.getEntity().getShooter();
            if (projectile2 instanceof BlockProjectileSource) {
                BlockProjectileSource b = (BlockProjectileSource)projectile2;
                projectile = new ItemBuilder(this.dispensedItems.get(b.getBlock().getLocation()));
                ItemUtils.storeItem((Entity)e.getEntity(), projectile.getItem());
            } else {
                projectile = ItemUtils.getStoredItem((Entity)e.getEntity());
            }
        }
        if (projectile == null) {
            return;
        }
        ItemMeta meta = projectile.getMeta();
        projectile2 = e.getEntity();
        if (projectile2 instanceof AbstractArrow && !((a = (AbstractArrow)projectile2) instanceof Trident)) {
            if (a.getShooter() instanceof Player) {
                BlockProjectileSource b;
                double inaccuracy = 0.0;
                ProjectileSource projectileSource = a.getShooter();
                if (projectileSource instanceof BlockProjectileSource && (projectileSource = (b = (BlockProjectileSource)projectileSource).getBlock().getBlockData()) instanceof Directional) {
                    Directional d = (Directional)projectileSource;
                    inaccuracy = ValhallaMMO.getPluginConfig().getDouble("dispenser_inaccuracy", 7.0);
                    direction = d.getFacing().getDirection();
                } else {
                    projectileSource = a.getShooter();
                    if (projectileSource instanceof LivingEntity) {
                        double bonusPiercing;
                        LivingEntity l = (LivingEntity)projectileSource;
                        inaccuracy = AccumulativeStatManager.getCachedStats("RANGED_INACCURACY", (Entity)l, 10000L, true);
                        direction = l.getEyeLocation().getDirection();
                        double bonusDamage = AccumulativeStatManager.getCachedStats("RANGED_DAMAGE_BONUS", (Entity)l, 10000L, true);
                        if (bonusDamage != 0.0) {
                            a.setDamage(Math.max(0.0, a.getDamage() + bonusDamage));
                        }
                        if ((bonusPiercing = AccumulativeStatManager.getCachedStats("RANGED_PIERCING_BONUS", (Entity)l, 10000L, true)) != 0.0) {
                            a.setPierceLevel(Math.max(0, a.getPierceLevel() + Utils.randomAverage(bonusPiercing)));
                        }
                    } else {
                        direction = a.getVelocity();
                    }
                }
                if (!ProjectileListener.isShotFromMultishot(a)) {
                    AttributeWrapper accuracy = ItemAttributesRegistry.getAttribute(meta, "ARROW_ACCURACY", false);
                    if (accuracy != null) {
                        inaccuracy = Math.max(0.0, inaccuracy - accuracy.getValue());
                    }
                    EntityUtils.applyInaccuracy((Entity)a, (Vector)direction, inaccuracy);
                }
            }
            this.setProjectileProperties(e.getEntity(), meta);
        }
        ArrowBehaviorRegistry.execute(e, ArrowBehaviorRegistry.getBehaviors(meta).values());
        direction = e.getEntity().getShooter();
        if (direction instanceof LivingEntity) {
            Projectile inaccuracy;
            LivingEntity l = (LivingEntity)direction;
            if (!(e.getEntity() instanceof AbstractArrow)) {
                double speedMultiplier = 1.0 + AccumulativeStatManager.getCachedStats("THROW_VELOCITY_BONUS", (Entity)l, 10000L, true);
                e.getEntity().setVelocity(e.getEntity().getVelocity().multiply(speedMultiplier));
            }
            if ((inaccuracy = e.getEntity()) instanceof ThrownPotion) {
                Player p;
                ThrownPotion t2 = (ThrownPotion)inaccuracy;
                if (l instanceof Player && (p = (Player)l).getGameMode() != GameMode.CREATIVE && Utils.proc((LivingEntity)p, AccumulativeStatManager.getCachedStats("POTION_SAVE_CHANCE", (Entity)p, 10000L, true), false)) {
                    p.getInventory().addItem(new ItemStack[]{t2.getItem()});
                }
            }
        }
    }

    public static boolean isShotFromMultishot(AbstractArrow a) {
        return !a.getMetadata("duplicate_multishot").isEmpty();
    }

    public static void setMultishotArrow(AbstractArrow a) {
        a.setMetadata("duplicate_multishot", (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)true));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemDispense(BlockDispenseEvent e) {
        Block b = e.getBlock();
        if (ValhallaMMO.isWorldBlacklisted(b.getWorld().getName()) || ItemUtils.isEmpty(e.getItem())) {
            return;
        }
        ItemStack storedItem = e.getItem().clone();
        storedItem.setAmount(1);
        this.dispensedItems.put(e.getBlock().getLocation(), storedItem);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFinalShoot(EntityShootBowEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || ItemUtils.isEmpty(e.getConsumable())) {
            return;
        }
        ArrowBehaviorRegistry.execute(e, ArrowBehaviorRegistry.getBehaviors(ItemUtils.getItemMeta(e.getConsumable())).values());
    }

    public static ItemBuilder getBow(Projectile projectile) {
        return projectileShotByMap.get(projectile.getUniqueId());
    }

    public static void setBow(Projectile projectile, ItemBuilder bow) {
        projectileShotByMap.put(projectile.getUniqueId(), bow);
    }

    public static void removeBow(Projectile projectile) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> projectileShotByMap.remove(projectile.getUniqueId()), 2L);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onShoot(EntityShootBowEvent e) {
        AbstractArrow a;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getProjectile()) instanceof Projectile)) {
            return;
        }
        Projectile pr = (Projectile)entity;
        ItemStack bow = e.getBow();
        Entity entity2 = e.getProjectile();
        if (entity2 instanceof AbstractArrow && (a = (AbstractArrow)entity2).isShotFromCrossbow() && a.getPickupStatus() != AbstractArrow.PickupStatus.ALLOWED && !ItemUtils.isEmpty(bow) && bow.containsEnchantment(Enchantment.MULTISHOT)) {
            ProjectileListener.setMultishotArrow(a);
        }
        Entity projectile = e.getProjectile();
        LivingEntity shooter = e.getEntity();
        double speedMultiplier = Math.max(0.0, AccumulativeStatManager.getCachedStats("RANGED_VELOCITY_BONUS", (Entity)shooter, 10000L, true));
        ItemStack tempConsumable = e.getConsumable();
        if (!ItemUtils.isEmpty(tempConsumable) && !ItemUtils.isEmpty(bow)) {
            boolean shouldSave;
            tempConsumable = tempConsumable.clone();
            tempConsumable.setAmount(1);
            ItemStack consumable = tempConsumable;
            ItemBuilder builderBow = new ItemBuilder(bow);
            ProjectileListener.setBow(pr, builderBow);
            ItemMeta consumableMeta = ItemUtils.getItemMeta(consumable);
            e.getProjectile().setVelocity(e.getProjectile().getVelocity().multiply(speedMultiplier));
            boolean infinityExploitable = CustomFlag.hasFlag(consumableMeta, CustomFlag.INFINITY_EXPLOITABLE);
            boolean hasInfinity = bow.containsEnchantment(EnchantmentMappings.INFINITY.getEnchantment());
            boolean bl = shouldSave = hasInfinity && (ItemUtils.isSimilar(consumable, new ItemStack(Material.ARROW)) || infinityExploitable);
            if (shooter instanceof Player) {
                Player p = (Player)shooter;
                if (e.getProjectile() instanceof AbstractArrow || e.getProjectile() instanceof Firework) {
                    AbstractArrow a2;
                    Entity allowedReloads2;
                    double ammoSaveChance = AccumulativeStatManager.getCachedStats("AMMO_SAVE_CHANCE", (Entity)shooter, 10000L, true);
                    if (hasInfinity) {
                        ammoSaveChance += this.infinityAmmoConsumption;
                    }
                    if (Utils.proc(shooter, ammoSaveChance, false)) {
                        if (bow.getType() == Material.CROSSBOW) {
                            int allowedReloads2 = 1 + (int)Math.round(AccumulativeStatManager.getCachedStats("CROSSBOW_MAGAZINE", (Entity)p, 10000L, true));
                            int currentReloads = this.crossbowReloads.getOrDefault(p.getUniqueId(), 0);
                            if (currentReloads + 1 <= allowedReloads2) {
                                this.crossbowReloads.put(p.getUniqueId(), currentReloads + 1);
                                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                                    ItemMeta patt0$temp;
                                    ItemStack crossbow;
                                    boolean mainHand = !ItemUtils.isEmpty(p.getInventory().getItemInMainHand()) && p.getInventory().getItemInMainHand().getType() == Material.CROSSBOW;
                                    ItemStack itemStack = crossbow = mainHand ? p.getInventory().getItemInMainHand() : p.getInventory().getItemInOffHand();
                                    if (ItemUtils.isEmpty(crossbow) || !((patt0$temp = crossbow.getItemMeta()) instanceof CrossbowMeta)) {
                                        return;
                                    }
                                    CrossbowMeta crossbowMeta = (CrossbowMeta)patt0$temp;
                                    crossbowMeta.addChargedProjectile(consumable);
                                    crossbow.setItemMeta((ItemMeta)crossbowMeta);
                                }, 1L);
                                Entity entity3 = e.getProjectile();
                                if (entity3 instanceof AbstractArrow) {
                                    AbstractArrow a3 = (AbstractArrow)entity3;
                                    a3.setPickupStatus(AbstractArrow.PickupStatus.CREATIVE_ONLY);
                                }
                            } else {
                                this.crossbowReloads.remove(p.getUniqueId());
                                p.playSound((Entity)p, Sound.ITEM_CROSSBOW_LOADING_END, 1.0f, 1.0f);
                            }
                            return;
                        }
                        allowedReloads2 = e.getProjectile();
                        if (allowedReloads2 instanceof AbstractArrow && !((a2 = (AbstractArrow)allowedReloads2) instanceof Trident)) {
                            shouldSave = true;
                        }
                    }
                    if ((allowedReloads2 = e.getProjectile()) instanceof AbstractArrow && !((a2 = (AbstractArrow)allowedReloads2) instanceof Trident)) {
                        e.setConsumeItem(!shouldSave);
                        if (e.shouldConsumeItem() && !ProjectileListener.isShotFromMultishot(a2)) {
                            a2.setPickupStatus(AbstractArrow.PickupStatus.ALLOWED);
                        } else {
                            a2.setPickupStatus(AbstractArrow.PickupStatus.CREATIVE_ONLY);
                        }
                        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21)) {
                            boolean wouldBeConsumed;
                            boolean bl2 = wouldBeConsumed = !hasInfinity || consumable.getType() != Material.ARROW;
                            if (e.shouldConsumeItem() && !wouldBeConsumed) {
                                for (ItemStack item : p.getInventory().getContents()) {
                                    if (ItemUtils.isEmpty(item) || !ItemUtils.isSimilar(item, consumable)) continue;
                                    if (item.getAmount() <= 1) {
                                        p.getInventory().remove(item);
                                        break;
                                    }
                                    item.setAmount(item.getAmount() - 1);
                                    break;
                                }
                                e.setConsumeItem(false);
                            } else if (!e.shouldConsumeItem() && wouldBeConsumed) {
                                ItemUtils.addItem(p, consumable, false);
                            }
                        }
                    }
                }
            }
            ItemStack storedItem = consumable.clone();
            storedItem.setAmount(1);
            ItemUtils.storeItem(projectile, storedItem);
        }
    }

    private void setProjectileProperties(Projectile p, ItemMeta i) {
        AbstractArrow a;
        ItemBuilder bow;
        boolean wasCrit;
        block10: {
            block9: {
                AttributeWrapper speedWrapper;
                AbstractArrow a2;
                wasCrit = false;
                if (p instanceof AbstractArrow && !((a2 = (AbstractArrow)p) instanceof Trident)) {
                    AttributeWrapper piercing;
                    wasCrit = a2.isCritical();
                    a2.setCritical(false);
                    AttributeWrapper damage = ItemAttributesRegistry.getAttribute(i, "ARROW_DAMAGE", false);
                    if (damage != null) {
                        a2.setDamage(Math.max(0.0, a2.getDamage() + damage.getValue() - 2.0));
                    }
                    if ((piercing = ItemAttributesRegistry.getAttribute(i, "ARROW_PIERCING", false)) != null) {
                        a2.setPierceLevel(Math.max(0, a2.getPierceLevel() + (int)piercing.getValue()));
                    }
                }
                if ((speedWrapper = ItemAttributesRegistry.getAttribute(i, "ARROW_VELOCITY", false)) != null) {
                    p.setVelocity(p.getVelocity().multiply(1.0 + speedWrapper.getValue()));
                }
                bow = ProjectileListener.getBow(p);
                if (!(p instanceof AbstractArrow)) break block9;
                a = (AbstractArrow)p;
                if (!(p instanceof Trident) && p.getShooter() instanceof Player && !StringUtils.isEmpty(this.arrowDamageOverhaulFormula) && bow != null) break block10;
            }
            return;
        }
        double baseDamage = a.getDamage();
        int power = bow.getMeta().getEnchantLevel(EnchantmentMappings.POWER.getEnchantment());
        double velocitySquared = a.getVelocity().lengthSquared();
        String formula = this.arrowDamageOverhaulFormula.replace("%basedamage%", String.format("%.3f", baseDamage)).replace("%power%", String.valueOf(power)).replace("%velocitysquared%", String.format("%.3f", velocitySquared));
        if (formula.contains("%velocity%")) {
            formula = formula.replace("%velocity%", String.format("%.3f", Math.sqrt(velocitySquared)));
        }
        double result = Utils.eval(formula);
        if (wasCrit && !StringUtils.isEmpty(this.arrowCriticalDamageFormula)) {
            result = Utils.eval(this.arrowCriticalDamageFormula.replace("%normaldamage%", String.format("%.6f", result)));
        }
        a.setMetadata("damage_overhaul", (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)result));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void arrowDamageOverhaul(EntityDamageByEntityEvent e) {
        Player p;
        AbstractArrow a;
        Entity entity;
        if (StringUtils.isEmpty(this.arrowDamageOverhaulFormula) || e.isCancelled() || ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !((entity = e.getDamager()) instanceof AbstractArrow) || (a = (AbstractArrow)entity) instanceof Trident || !((entity = a.getShooter()) instanceof Player) || WorldGuardHook.inDisabledRegion((p = (Player)entity).getLocation(), p, "vmmo-skill-archery")) {
            return;
        }
        Optional damageOptional = a.getMetadata("damage_overhaul").stream().findAny();
        if (damageOptional.isEmpty()) {
            return;
        }
        MetadataValue metaData = (MetadataValue)damageOptional.get();
        double value = metaData.asDouble();
        e.setDamage(value);
        if (this.arrowDamagePiercingReduction != 0.0) {
            double multiplier = 1.0 - this.arrowDamagePiercingReduction;
            a.removeMetadata("damage_overhaul", (Plugin)ValhallaMMO.getInstance());
            a.setMetadata("damage_overhaul", (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)(value * multiplier)));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHit(ProjectileHitEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = e.getHitEntity();
        if (entity instanceof LivingEntity) {
            AbstractArrow a;
            LivingEntity l = (LivingEntity)entity;
            entity = e.getEntity();
            if (entity instanceof AbstractArrow && ProjectileListener.isShotFromMultishot(a = (AbstractArrow)entity) && ValhallaMMO.getPluginConfig().getBoolean("multishot_all_hit")) {
                int originalDamageTicks = l.getNoDamageTicks();
                a.setDamage(a.getDamage() * ValhallaMMO.getPluginConfig().getDouble("multishot_damage_reduction", 0.5));
                l.setNoDamageTicks(0);
                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> l.setNoDamageTicks(originalDamageTicks), 1L);
            }
        }
        ProjectileListener.removeBow(e.getEntity());
        ItemBuilder stored = ItemUtils.getStoredItem((Entity)e.getEntity());
        if (stored == null) {
            return;
        }
        ArrowBehaviorRegistry.execute(e, ArrowBehaviorRegistry.getBehaviors(stored.getMeta()).values());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPickup(PlayerPickupArrowEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (!(e.getArrow() instanceof Trident)) {
            ProjectileListener.removeBow((Projectile)e.getArrow());
            Item i = e.getItem();
            ItemBuilder stored = ItemUtils.getStoredItem((Entity)e.getArrow());
            if (stored == null) {
                return;
            }
            ArrowBehaviorRegistry.execute(e, ArrowBehaviorRegistry.getBehaviors(stored.getMeta()).values());
            i.setItemStack(stored.getItem());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Projectile) {
            Projectile p = (Projectile)entity;
            entity = e.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)entity;
                if (!EntityClassification.matchesClassification(e.getEntity().getType(), EntityClassification.UNALIVE)) {
                    LivingEntity d;
                    LivingEntity trueDamager;
                    ItemBuilder stored = ItemUtils.getStoredItem((Entity)p);
                    if (stored == null) {
                        return;
                    }
                    ItemMeta storedMeta = stored.getMeta();
                    ProjectileSource projectileSource = p.getShooter();
                    LivingEntity livingEntity = trueDamager = projectileSource instanceof LivingEntity ? (d = (LivingEntity)projectileSource) : null;
                    if (!(p instanceof Trident)) {
                        this.cancelNextArrowEffects.add(e.getEntity().getUniqueId());
                        for (PotionEffectWrapper wrapper : PotionEffectRegistry.getStoredEffects(storedMeta, false).values()) {
                            int duration = (int)Math.floor((double)wrapper.getDuration() / 8.0);
                            if (wrapper.isVanilla()) {
                                l.addPotionEffect(new PotionEffect(wrapper.getVanillaEffect(), duration, (int)wrapper.getAmplifier(), false));
                                continue;
                            }
                            PotionEffectRegistry.addEffect(l, trueDamager, new CustomPotionEffect(wrapper, duration, wrapper.getAmplifier()), false, 1.0, EntityPotionEffectEvent.Cause.ARROW);
                        }
                        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> this.cancelNextArrowEffects.remove(e.getEntity().getUniqueId()), 1L);
                    }
                    ArrowBehaviorRegistry.execute(e, ArrowBehaviorRegistry.getBehaviors(storedMeta).values());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArrowPotionEffect(EntityPotionEffectEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName())) {
            return;
        }
        if (e.getCause() == EntityPotionEffectEvent.Cause.ARROW && this.cancelNextArrowEffects.contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
        }
    }
}

