/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.dom.Weighted;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.inventory.ItemStack;

public class LootEntry
implements Weighted {
    private final UUID uuid;
    private final String parentPool;
    private ItemStack drop;
    private int baseQuantityMin = 1;
    private int baseQuantityMax = 1;
    private float quantityMinFortuneBase = 0.0f;
    private float quantityMaxFortuneBase = 0.0f;
    private final Collection<LootPredicate> predicates = new HashSet<LootPredicate>();
    private double chance = 0.1;
    private double chanceQuality = 0.5;
    private double weight = 10.0;
    private double weightQuality = 10.0;
    private boolean guaranteedPresent = false;
    private List<DynamicItemModifier> modifiers = new ArrayList<DynamicItemModifier>();
    private LootTable.PredicateSelection predicateSelection = LootTable.PredicateSelection.ANY;

    public LootEntry(UUID uuid, ItemStack drop, String parentPool) {
        this.uuid = uuid;
        this.drop = drop;
        this.parentPool = parentPool;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ItemStack getDrop() {
        return this.drop;
    }

    public String getParentPool() {
        return this.parentPool;
    }

    public void setDrop(ItemStack drop) {
        this.drop = drop;
    }

    public int getBaseQuantityMin() {
        return this.baseQuantityMin;
    }

    public void setBaseQuantityMin(int baseQuantityMin) {
        this.baseQuantityMin = baseQuantityMin;
    }

    public int getBaseQuantityMax() {
        return this.baseQuantityMax;
    }

    public void setBaseQuantityMax(int baseQuantityMax) {
        this.baseQuantityMax = baseQuantityMax;
    }

    public float getQuantityMinFortuneBase() {
        return this.quantityMinFortuneBase;
    }

    public void setQuantityMinFortuneBase(float quantityMinFortuneBase) {
        this.quantityMinFortuneBase = quantityMinFortuneBase;
    }

    public float getQuantityMaxFortuneBase() {
        return this.quantityMaxFortuneBase;
    }

    public void setQuantityMaxFortuneBase(float quantityMaxFortuneBase) {
        this.quantityMaxFortuneBase = quantityMaxFortuneBase;
    }

    public Collection<LootPredicate> getPredicates() {
        return this.predicates;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    public double getChance(double luck) {
        return Math.max(0.0, this.chance + this.chanceQuality * luck);
    }

    public void setChanceQuality(double chanceQuality) {
        this.chanceQuality = chanceQuality;
    }

    public double getChanceQuality() {
        return this.chanceQuality;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getWeight(double luck, double fortune) {
        return Math.max(0.0, this.weight + this.weightQuality * luck);
    }

    public void setWeightQuality(double weightQuality) {
        this.weightQuality = weightQuality;
    }

    public double getWeightQuality() {
        return this.weightQuality;
    }

    public List<DynamicItemModifier> getModifiers() {
        return this.modifiers;
    }

    public LootTable.PredicateSelection getPredicateSelection() {
        return this.predicateSelection;
    }

    public void setPredicateSelection(LootTable.PredicateSelection predicateSelection) {
        this.predicateSelection = predicateSelection;
    }

    public void setModifiers(List<DynamicItemModifier> modifiers) {
        this.modifiers = modifiers;
        DynamicItemModifier.sortModifiers(this.modifiers);
    }

    public boolean isGuaranteedPresent() {
        return this.guaranteedPresent;
    }

    public void setGuaranteedPresent(boolean guaranteedPresent) {
        this.guaranteedPresent = guaranteedPresent;
    }
}

