/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.nms;

import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.block.DigPacketInfo;
import me.athlaeos.valhallammo.dom.EquippableWrapper;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Structures;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.nms.NMS;
import me.athlaeos.valhallammo.nms.NMS_v1_19_R1;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R2.generator.strucutre.CraftStructure;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public final class NMS_v1_19_R2
implements NMS {
    @Override
    public void forceAttack(Player player, LivingEntity victim) {
        ((CraftPlayer)player).getHandle().d(((CraftEntity)victim).getHandle());
    }

    @Override
    public Channel channel(Player p) {
        return ((CraftPlayer)p).getHandle().b.b.m;
    }

    @Override
    public Pair<Location, Structures> getNearestStructure(World world, Location location, Map<Structures, Integer> structuresToFind) {
        HashSet<Pair<Integer, Integer>> chunksToScan = new HashSet<Pair<Integer, Integer>>();
        int cX = location.getChunk().getX();
        int cZ = location.getChunk().getZ();
        int maxRadius = Collections.max(structuresToFind.values());
        for (int x = cX - maxRadius; x <= cX + maxRadius; ++x) {
            for (int z = cZ - maxRadius; z <= cZ + maxRadius; ++z) {
                chunksToScan.add(new Pair<Integer, Integer>(x, z));
            }
        }
        Pair<Location, Structures> found = null;
        int closest = Integer.MAX_VALUE;
        CraftServer server = (CraftServer)Bukkit.getServer();
        IRegistryCustom.Dimension access = server.getServer().aW();
        for (Pair pair : chunksToScan) {
            Map structures = ((CraftWorld)world).getHandle().a(((Integer)pair.getOne()).intValue(), ((Integer)pair.getTwo()).intValue(), ChunkStatus.e).g();
            for (Structure s : structures.keySet()) {
                int maxDistance;
                Structures structure = Structures.fromStructure(CraftStructure.minecraftToBukkit((Structure)s, (IRegistryCustom)access));
                if (structure == null) continue;
                StructureStart start = (StructureStart)structures.get(s);
                int distance = Utils.getManhattanDistance(location.getChunk().getX(), location.getChunk().getZ(), (Integer)pair.getOne(), (Integer)pair.getTwo());
                if (!structuresToFind.containsKey((Object)structure) || distance > (maxDistance = structuresToFind.get((Object)structure).intValue()) || distance > closest) continue;
                closest = distance;
                BlockPosition pos = start.a().f();
                Location loc = new Location(location.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w());
                found = new Pair<Location, Structures>(loc, structure);
            }
        }
        return found;
    }

    @Override
    public PotionType getPotionType(PotionMeta meta) {
        return meta.getBasePotionData().getType();
    }

    @Override
    public PotionEffectType getPotionEffectType(PotionEffectMappings mappedTo) {
        return NMS_v1_19_R1.oldMappings(mappedTo);
    }

    @Override
    public Attribute getAttribute(AttributeMappings mappedTo) {
        return NMS_v1_19_R1.getMappedAttribute(mappedTo);
    }

    @Override
    public boolean isUpgraded(PotionMeta meta) {
        return meta.getBasePotionData().isUpgraded();
    }

    @Override
    public boolean isExtended(PotionMeta meta) {
        return meta.getBasePotionData().isExtended();
    }

    @Override
    public void setPotionType(PotionMeta meta, PotionType type) {
        meta.setBasePotionData(new PotionData(type, false, false));
    }

    @Override
    public DigPacketInfo readDiggingPacket(Player p, Object packet) {
        if (!(packet instanceof PacketPlayInBlockDig)) {
            return null;
        }
        PacketPlayInBlockDig digPacket = (PacketPlayInBlockDig)packet;
        BlockPosition pos = digPacket.b();
        return new DigPacketInfo(p, pos.u(), pos.v(), pos.w(), DigPacketInfo.fromName(digPacket.d().name()));
    }

    @Override
    public void blockBreakAnimation(Player p, org.bukkit.block.Block b, int id, int stage) {
        EntityPlayer entityPlayer = ((CraftPlayer)p).getHandle();
        PlayerConnection playerConnection = entityPlayer.b;
        BlockPosition blockPosition = new BlockPosition(b.getX(), b.getY(), b.getZ());
        playerConnection.a((Packet)new PacketPlayOutBlockBreakAnimation(id, blockPosition, stage));
    }

    @Override
    public void blockParticleAnimation(org.bukkit.block.Block b) {
        b.getWorld().spawnParticle(Particle.BLOCK_CRACK, b.getLocation().add(0.5, 0.0, 0.5), 10, (Object)b.getBlockData());
    }

    @Override
    public float toolPower(ItemStack tool, org.bukkit.block.Block b) {
        if (!ItemUtils.isEmpty(tool)) {
            net.minecraft.world.item.ItemStack craftItemStack = CraftItemStack.asNMSCopy((ItemStack)tool);
            WorldServer nmsWorld = ((CraftWorld)b.getWorld()).getHandle();
            Block nmsBlock = nmsWorld.a_(new BlockPosition(b.getX(), b.getY(), b.getZ())).b();
            return craftItemStack.a(nmsBlock.n());
        }
        return 1.0f;
    }

    @Override
    public float toolPower(ItemStack tool, Material b) {
        if (!ItemUtils.isEmpty(tool)) {
            net.minecraft.world.item.ItemStack craftItemStack = CraftItemStack.asNMSCopy((ItemStack)tool);
            CraftBlockData data = (CraftBlockData)b.createBlockData();
            return craftItemStack.a(data.getState());
        }
        return 1.0f;
    }

    @Override
    public void breakBlock(Player p, org.bukkit.block.Block b) {
        b.getWorld().spawnParticle(Particle.BLOCK_CRACK, b.getLocation().add(0.5, 0.5, 0.5), 100, 0.1, 0.1, 0.1, 4.0, (Object)b.getBlockData());
        b.getWorld().playSound(b.getLocation(), b.getBlockData().getSoundGroup().getBreakSound(), 1.0f, 1.0f);
        ((CraftPlayer)p).getHandle().d.a(new BlockPosition(b.getX(), b.getY(), b.getZ()));
    }

    @Override
    public Sound blockSound(org.bukkit.block.Block b) {
        try {
            WorldServer nmsWorld = ((CraftWorld)b.getWorld()).getHandle();
            Block nmsBlock = nmsWorld.a_(new BlockPosition(b.getX(), b.getY(), b.getZ())).b();
            SoundEffectType soundEffectType = nmsBlock.m(nmsBlock.n());
            Field soundEffectField = soundEffectType.getClass().getDeclaredField("fallSound");
            soundEffectField.setAccessible(true);
            SoundEffect soundEffect = (SoundEffect)soundEffectField.get(soundEffectType);
            Field keyField = SoundEffect.class.getDeclaredField("CODEC");
            keyField.setAccessible(true);
            MinecraftKey minecraftKey = (MinecraftKey)keyField.get(soundEffect);
            return Sound.valueOf((String)minecraftKey.a().toUpperCase(Locale.US).replace(".", "_").replace("_FALL", "_HIT"));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return Sound.BLOCK_STONE_HIT;
        }
    }

    @Override
    public void resetAttackCooldown(Player p) {
        EntityPlayer entityPlayer = ((CraftPlayer)p).getHandle();
        entityPlayer.fY();
    }

    @Override
    public void setEdible(ItemBuilder meta, boolean edible, boolean canAlwaysEat, float eatTimeSeconds) {
    }

    @Override
    public void setGlint(ItemMeta meta, boolean glint) {
    }

    @Override
    public void setMaxStackSize(ItemMeta meta, int stackSize) {
    }

    @Override
    public int getMaxStackSize(ItemMeta meta, Material baseMaterial) {
        return baseMaterial.getMaxStackSize();
    }

    @Override
    public void setFireResistant(ItemMeta meta, boolean fireResistant) {
    }

    @Override
    public void setHideTooltip(ItemMeta meta, boolean hideToolTip) {
    }

    @Override
    public void setBookContents(ItemStack book, List<BaseComponent[]> pages) {
    }

    @Override
    public Enchantment getEnchantment(EnchantmentMappings mappedTo) {
        return NMS_v1_19_R1.oldMappings(mappedTo);
    }

    @Override
    public void addUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type, double amount, AttributeModifier.Operation operation) {
        NMS_v1_19_R1.addAttribute(e, uuid, identifier, type, amount, operation);
    }

    @Override
    public boolean hasUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return NMS_v1_19_R1.hasAttribute(e, uuid, identifier, type);
    }

    @Override
    public double getUniqueAttributeValue(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return NMS_v1_19_R1.getAttributeValue(e, uuid, identifier, type);
    }

    @Override
    public void removeUniqueAttribute(LivingEntity e, String identifier, Attribute type) {
        NMS_v1_19_R1.removeAttribute(e, identifier, type);
    }

    @Override
    public void setItemModel(ItemMeta meta, String model) {
    }

    @Override
    public void setEquippable(ItemMeta meta, String modelKey, EquipmentSlot slot, String cameraOverlayKey, Sound equipSound, List<EntityType> allowedTypes) {
    }

    @Override
    public void setToolTipStyle(ItemMeta meta, String namespacedKey) {
    }

    @Override
    public String getItemModel(ItemMeta meta) {
        return null;
    }

    @Override
    public EquippableWrapper getEquippable(ItemMeta meta) {
        return null;
    }

    @Override
    public String getToolTipStyle(ItemMeta meta) {
        return null;
    }
}

