/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.UUID;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProfileStatDefenderArmorWeightSetSource
implements AccumulativeStatSource,
EvEAccumulativeStatSource {
    private final Class<? extends Profile> type;
    private final String stat;
    private final String qtyStat;
    private final Class<? extends Number> numberType;
    private final Class<? extends Number> quantityType;
    private final Profile baseProfile;
    private final double def;
    private final WeightClass weightClass;
    private boolean negative = false;

    public ProfileStatDefenderArmorWeightSetSource(Class<? extends Profile> type, String stat, String qtyStat, WeightClass weightClass) {
        this.type = type;
        this.stat = stat;
        this.qtyStat = qtyStat;
        this.weightClass = weightClass;
        this.baseProfile = ProfileRegistry.getBlankProfile((UUID)null, type);
        if (this.baseProfile.intStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultInt(stat);
            this.numberType = Integer.class;
        } else if (this.baseProfile.floatStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultFloat(stat);
            this.numberType = Float.class;
        } else if (this.baseProfile.doubleStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultDouble(stat);
            this.numberType = Double.class;
        } else {
            this.def = 0.0;
            this.numberType = null;
        }
        this.quantityType = this.baseProfile.intStatNames().contains(qtyStat) ? Integer.class : (this.baseProfile.floatStatNames().contains(qtyStat) ? Float.class : (this.baseProfile.doubleStatNames().contains(qtyStat) ? Double.class : null));
        if (this.numberType == null) {
            throw new IllegalArgumentException("ProfileStatAttackerWeightSource:" + type.getSimpleName() + " with stat " + stat + " was initialized, but this profile type does not have such a stat");
        }
        if (this.quantityType == null) {
            throw new IllegalArgumentException("ProfileStatAttackerWeightSource:" + type.getSimpleName() + " with stat " + qtyStat + " was initialized, but this profile type does not have such a stat");
        }
    }

    public ProfileStatDefenderArmorWeightSetSource n() {
        this.negative = true;
        return this;
    }

    @Override
    public double fetch(Entity p, boolean use) {
        return this.fetch(p, null, use);
    }

    public StatFormat getFormat() {
        return this.baseProfile.getNumberStatProperties().get(this.stat).getFormat();
    }

    @Override
    public double fetch(Entity victim, Entity attackedBy, boolean use) {
        if (victim instanceof Player) {
            String requiredPermission;
            Player pl = (Player)victim;
            EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)pl);
            int quantity = switch (this.weightClass) {
                default -> throw new IncompatibleClassChangeError();
                case WeightClass.LIGHT -> properties.getLightArmorCount();
                case WeightClass.HEAVY -> properties.getHeavyArmorCount();
                case WeightClass.WEIGHTLESS -> properties.getWeightlessArmorCount();
                case WeightClass.NONE -> properties.getNoArmorCount();
            };
            Profile profile = ProfileCache.getOrCache(pl, this.type);
            String string = requiredPermission = SkillRegistry.isRegistered(profile.getSkillType()) ? SkillRegistry.getSkill(profile.getSkillType()).getRequiredPermission() : null;
            if (requiredPermission != null && !pl.hasPermission(requiredPermission)) {
                return this.def;
            }
            int required = -1;
            if (this.quantityType.equals(Integer.class)) {
                required = profile.getInt(this.qtyStat);
            }
            if (this.quantityType.equals(Float.class)) {
                required = (int)profile.getFloat(this.qtyStat);
            }
            if (this.quantityType.equals(Double.class)) {
                required = (int)profile.getDouble(this.qtyStat);
            }
            if (required < 0 || quantity < required) {
                return 0.0;
            }
            if (this.numberType.equals(Integer.class)) {
                return (this.negative ? -1 : 1) * profile.getInt(this.stat);
            }
            if (this.numberType.equals(Float.class)) {
                return (float)(this.negative ? -1 : 1) * profile.getFloat(this.stat);
            }
            return (double)(this.negative ? -1 : 1) * profile.getDouble(this.stat);
        }
        return this.def;
    }
}

