/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations;

import java.util.ArrayList;
import java.util.List;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTrigger;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;

public class WhileMovementModifier
implements EffectTrigger.ConstantTrigger,
Listener {
    private static Listener singleListenerInstance = null;
    private final Boolean movementMode;

    public WhileMovementModifier(Boolean movementMode) {
        this.movementMode = movementMode;
    }

    @Override
    public boolean shouldTrigger(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player p = (Player)entity;
        return this.movementMode == null ? !p.isSneaking() && !p.isSprinting() : (this.movementMode != false ? p.isSprinting() : p.isSneaking());
    }

    @Override
    public int tickDelay() {
        return 10;
    }

    @Override
    public String id() {
        return "while_" + (this.movementMode == null ? "walking" : (this.movementMode != false ? "sprinting" : "sneaking"));
    }

    @Override
    public void onRegister() {
        if (singleListenerInstance != null) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
        singleListenerInstance = this;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSprintToggle(PlayerToggleSprintEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)e.getPlayer());
        if (e.isSprinting()) {
            if (!properties.getPermanentPotionEffects().isEmpty()) {
                if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_sprinting", new ArrayList())).isEmpty()) {
                    this.trigger((LivingEntity)e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_sprinting", new ArrayList()));
                }
                if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList())).isEmpty()) {
                    this.unTrigger(e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList()));
                }
            }
        } else {
            if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_sprinting", new ArrayList())).isEmpty()) {
                this.unTrigger(e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_sprinting", new ArrayList()));
            }
            if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList())).isEmpty()) {
                this.trigger((LivingEntity)e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSneakToggle(PlayerToggleSneakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName())) {
            return;
        }
        EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)e.getPlayer());
        if (e.isSneaking()) {
            if (!properties.getPermanentPotionEffects().isEmpty()) {
                if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_sneaking", new ArrayList())).isEmpty()) {
                    this.trigger((LivingEntity)e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_sneaking", new ArrayList()));
                }
                if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList())).isEmpty()) {
                    this.unTrigger(e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList()));
                }
            }
        } else {
            if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_sneaking", new ArrayList())).isEmpty()) {
                this.unTrigger(e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_sneaking", new ArrayList()));
            }
            if (!((List)properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList())).isEmpty()) {
                this.trigger((LivingEntity)e.getPlayer(), properties.getPermanentPotionEffects().getOrDefault("while_walking", new ArrayList()));
            }
        }
    }

    private void unTrigger(Player p, List<PotionEffectWrapper> effects) {
        for (PotionEffectWrapper effectWrapper : effects) {
            if (effectWrapper.isVanilla()) {
                p.removePotionEffect(effectWrapper.getVanillaEffect());
                continue;
            }
            CustomPotionEffect effect = new CustomPotionEffect(effectWrapper, 0, effectWrapper.getAmplifier());
            PotionEffectRegistry.addEffect((LivingEntity)p, null, effect, true, 1.0, EntityPotionEffectEvent.Cause.EXPIRATION);
        }
    }
}

