/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards.implementations;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardArgumentType;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class FlightReward
extends PerkReward
implements Listener {
    private static final NamespacedKey KEY_GRANTED_FLIGHT = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "granted_flight");
    private final boolean flightPvPPrevention = ValhallaMMO.getPluginConfig().getBoolean("flight_pvp_prevention", true);
    private final boolean flightPvEPrevention = ValhallaMMO.getPluginConfig().getBoolean("flight_pve_prevention", true);
    private final int flightPvPPreventionDuration = ValhallaMMO.getPluginConfig().getInt("flight_pvp_prevention_duration", 30);
    private final int flightPvEPreventionDuration = ValhallaMMO.getPluginConfig().getInt("flight_pve_prevention_duration", 5);
    private final boolean flightPreventionSlowFalling = ValhallaMMO.getPluginConfig().getBoolean("flight_prevention_slow_falling", false);

    public FlightReward() {
        super("enable_flight");
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @Override
    public void apply(Player player) {
        PowerProfile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, PowerProfile.class) : ProfileRegistry.getSkillProfile(player, PowerProfile.class);
        profile.setBoolean("flight", true);
        if (this.isPersistent()) {
            profile.setShouldForcePersist(true);
            ProfileRegistry.setPersistentProfile(player, profile, PowerProfile.class);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, PowerProfile.class);
        }
        ProfileCache.resetCache(player);
        FlightReward.setFlight(player, true);
    }

    @Override
    public void remove(Player player) {
        PowerProfile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, PowerProfile.class) : ProfileRegistry.getSkillProfile(player, PowerProfile.class);
        profile.setBoolean("flight", false);
        if (this.isPersistent()) {
            ProfileRegistry.setPersistentProfile(player, profile, PowerProfile.class);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, PowerProfile.class);
        }
        ProfileCache.resetCache(player);
        FlightReward.setFlight(player, false);
    }

    public static void setFlight(Player p, boolean flight) {
        if (flight) {
            PowerProfile profile = ProfileCache.getOrCache(p, PowerProfile.class);
            if (!p.getAllowFlight() && profile.getBoolean("flight")) {
                p.setAllowFlight(true);
                p.getPersistentDataContainer().set(KEY_GRANTED_FLIGHT, PersistentDataType.BYTE, (Object)0);
            }
        } else if (p.getAllowFlight() && p.getPersistentDataContainer().has(KEY_GRANTED_FLIGHT, PersistentDataType.BYTE)) {
            p.setAllowFlight(false);
            p.getPersistentDataContainer().remove(KEY_GRANTED_FLIGHT);
        }
    }

    @Override
    public void parseArgument(Object o) {
    }

    @Override
    public String rewardPlaceholder() {
        return TranslationManager.getTranslation("translation_toggles");
    }

    @Override
    public PerkRewardArgumentType getRequiredType() {
        return PerkRewardArgumentType.NONE;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onToggleFlight(PlayerToggleFlightEvent e) {
        if (!e.isFlying() || !e.getPlayer().getPersistentDataContainer().has(KEY_GRANTED_FLIGHT, PersistentDataType.BYTE)) {
            return;
        }
        if (Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "flight_interrupt")) {
            return;
        }
        e.setCancelled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPvP(EntityDamageByEntityEvent e) {
        Entity entity;
        if (this.flightPvPPrevention && (entity = e.getEntity()) instanceof Player) {
            Player v = (Player)entity;
            entity = EntityUtils.getTrueDamager(e);
            if (entity instanceof Player) {
                Player a = (Player)entity;
                Timer.setCooldown(v.getUniqueId(), 1000 * this.flightPvPPreventionDuration, "flight_interrupt");
                Timer.setCooldown(a.getUniqueId(), 1000 * this.flightPvPPreventionDuration, "flight_interrupt");
                if (v.isFlying() && v.getPersistentDataContainer().has(KEY_GRANTED_FLIGHT, PersistentDataType.BYTE)) {
                    v.setFlying(false);
                    if (this.flightPreventionSlowFalling) {
                        v.addPotionEffect(new PotionEffect(PotionEffectMappings.SLOW_FALLING.getPotionEffectType(), 200, 0, true, false, false));
                    }
                }
                if (!a.isFlying()) return;
                if (!a.getPersistentDataContainer().has(KEY_GRANTED_FLIGHT, PersistentDataType.BYTE)) return;
                a.setFlying(false);
                if (!this.flightPreventionSlowFalling) return;
                a.addPotionEffect(new PotionEffect(PotionEffectMappings.SLOW_FALLING.getPotionEffectType(), 200, 0, true, false, false));
                return;
            }
        }
        if (this.flightPvEPrevention && (entity = e.getEntity()) instanceof Player) {
            Player p = (Player)entity;
            Timer.setCooldown(p.getUniqueId(), 1000 * this.flightPvEPreventionDuration, "flight_interrupt");
            if (!p.isFlying()) return;
            if (!p.getPersistentDataContainer().has(KEY_GRANTED_FLIGHT, PersistentDataType.BYTE)) return;
            p.setFlying(false);
            if (!this.flightPreventionSlowFalling) return;
            p.addPotionEffect(new PotionEffect(PotionEffectMappings.SLOW_FALLING.getPotionEffectType(), 200, 0, true, false, false));
            return;
        }
        if (!this.flightPvEPrevention) return;
        entity = EntityUtils.getTrueDamager(e);
        if (!(entity instanceof Player)) return;
        Player p = (Player)entity;
        Timer.setCooldown(p.getUniqueId(), 1000 * this.flightPvEPreventionDuration, "flight_interrupt");
        if (!p.isFlying()) return;
        if (!p.getPersistentDataContainer().has(KEY_GRANTED_FLIGHT, PersistentDataType.BYTE)) return;
        p.setFlying(false);
        if (!this.flightPreventionSlowFalling) return;
        p.addPotionEffect(new PotionEffect(PotionEffectMappings.SLOW_FALLING.getPotionEffectType(), 200, 0, true, false, false));
    }
}

