/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perkresourcecost.implementations;

import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import org.bukkit.entity.Player;

public class PrestigePointsExpense
implements ResourceExpense {
    private int cost;
    private final boolean refundable = ConfigManager.getConfig("config.yml").reload().get().getBoolean("forgettable_perks_refund_prestigepoints", true);

    @Override
    public void initExpense(Object value) {
        if (value instanceof Number) {
            this.cost = (Integer)value;
        }
    }

    @Override
    public boolean canPurchase(Player p) {
        PowerProfile profile = ProfileRegistry.getMergedProfile(p, PowerProfile.class);
        return profile.getSpendablePrestigePoints() - profile.getSpentPrestigePoints() >= this.cost;
    }

    @Override
    public void purchase(Player p, boolean initialPurchase) {
        PowerProfile profile = ProfileRegistry.getSkillProfile(p, PowerProfile.class);
        profile.setSpentPrestigePoints(profile.getSpentPrestigePoints() + this.cost);
        ProfileRegistry.setSkillProfile(p, profile, PowerProfile.class);
    }

    @Override
    public void refund(Player p) {
        PowerProfile profile = ProfileRegistry.getSkillProfile(p, PowerProfile.class);
        profile.setSpentPrestigePoints(profile.getSpentPrestigePoints() - this.cost);
        ProfileRegistry.setSkillProfile(p, profile, PowerProfile.class);
    }

    @Override
    public boolean isRefundable() {
        return this.refundable;
    }

    @Override
    public ResourceExpense createInstance() {
        return new PrestigePointsExpense();
    }

    @Override
    public String getInsufficientFundsMessage() {
        return TranslationManager.getTranslation("warning_insufficient_prestigepoints");
    }

    @Override
    public String getCostPlaceholder() {
        return "%cost_prestige%";
    }

    @Override
    public String getInsufficientCostPlaceholder() {
        return "%warning_cost_prestige%";
    }

    @Override
    public String getCostMessage() {
        return TranslationManager.getTranslation("status_prestigepoints_cost").replace("%cost%", "" + this.cost);
    }
}

