/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.animations.Animation;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.entities.EntityClassification;
import me.athlaeos.valhallammo.event.PlayerBlocksDropItemsEvent;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.listeners.CustomBreakSpeedListener;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FarmingProfile;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Beehive;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FarmingSkill
extends Skill
implements Listener {
    private final Map<Material, Double> blockDropExpValues = new HashMap<Material, Double>();
    private final Map<Material, Double> blockInteractExpValues = new HashMap<Material, Double>();
    private final Map<Material, Double> entityDropExpValues = new HashMap<Material, Double>();
    private final Map<EntityType, Double> entityBreedExpValues = new HashMap<EntityType, Double>();
    private final Map<EntityType, Double> entityShearExpValues = new HashMap<EntityType, Double>();
    private int fieldHarvestLimit = 256;
    private boolean fieldHarvestInstant = false;
    private boolean forgivingDropMultipliers;
    private Animation fieldHarvestAnimation = null;
    private final Collection<UUID> fieldHarvestingPlayers = new HashSet<UUID>();
    private final Collection<Material> harvestableCrops = ItemUtils.getMaterialSet(Arrays.asList("WHEAT", "POTATOES", "CARROTS", "BEETROOTS", "COCOA", "NETHER_WART"));
    private final int[][] fieldHarvestScanArea = new int[][]{{-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {0, 0, -1}, {0, 0, 1}, {1, 0, -1}, {1, 0, 0}, {1, 0, 1}};

    public void setFieldHarvestAnimation(Animation fieldHarvestAnimation) {
        this.fieldHarvestAnimation = fieldHarvestAnimation;
    }

    public FarmingSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ConfigurationSection entityDropSection;
        ConfigurationSection entityShearSection;
        ConfigurationSection entityBreedSection;
        ConfigurationSection blockInteractSection;
        ValhallaMMO.getInstance().save("skills/farming_progression.yml");
        ValhallaMMO.getInstance().save("skills/farming.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/farming.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/farming_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.fieldHarvestLimit = skillConfig.getInt("field_harvest_limit");
        this.fieldHarvestInstant = skillConfig.getBoolean("field_harvest_instant");
        this.forgivingDropMultipliers = skillConfig.getBoolean("forgiving_multipliers");
        HashSet<Object> invalidMaterials = new HashSet<Object>();
        HashSet<String> invalidEntities = new HashSet<String>();
        ConfigurationSection blockBreakSection = progressionConfig.getConfigurationSection("experience.block_drops");
        if (blockBreakSection != null) {
            for (Object key : blockBreakSection.getKeys(false)) {
                try {
                    Material drop = Material.valueOf((String)key);
                    double reward = progressionConfig.getDouble("experience.block_drops." + (String)key);
                    this.blockDropExpValues.put(drop, reward);
                }
                catch (IllegalArgumentException ignored) {
                    invalidMaterials.add(key);
                }
            }
        }
        if ((blockInteractSection = progressionConfig.getConfigurationSection("experience.block_interact")) != null) {
            for (Object key : blockInteractSection.getKeys(false)) {
                try {
                    Material block = Material.valueOf((String)key);
                    double reward = progressionConfig.getDouble("experience.block_interact." + (String)key);
                    this.blockInteractExpValues.put(block, reward);
                }
                catch (IllegalArgumentException ignored) {
                    invalidMaterials.add(key);
                }
            }
        }
        if ((entityBreedSection = progressionConfig.getConfigurationSection("experience.entity_breed")) != null) {
            for (String key : entityBreedSection.getKeys(false)) {
                try {
                    EntityType entity = EntityType.valueOf((String)key);
                    double reward = progressionConfig.getDouble("experience.entity_breed." + key);
                    this.entityBreedExpValues.put(entity, reward);
                }
                catch (IllegalArgumentException ignored) {
                    invalidEntities.add(key);
                }
            }
        }
        if ((entityShearSection = progressionConfig.getConfigurationSection("experience.entity_shear")) != null) {
            for (String key : entityShearSection.getKeys(false)) {
                try {
                    EntityType entity = EntityType.valueOf((String)key);
                    double reward = progressionConfig.getDouble("experience.entity_shear." + key);
                    this.entityShearExpValues.put(entity, reward);
                }
                catch (IllegalArgumentException ignored) {
                    invalidEntities.add(key);
                }
            }
        }
        if ((entityDropSection = progressionConfig.getConfigurationSection("experience.entity_drops")) != null) {
            for (String key : entityDropSection.getKeys(false)) {
                try {
                    Material drop = Material.valueOf((String)key);
                    double reward = progressionConfig.getDouble("experience.entity_drops." + key);
                    this.entityDropExpValues.put(drop, reward);
                }
                catch (IllegalArgumentException ignored) {
                    invalidMaterials.add(key);
                }
            }
        }
        if (!invalidMaterials.isEmpty()) {
            ValhallaMMO.logWarning("The following materials in skills/farming_progression.yml do not exist, no exp values set (ignore warning if your version does not have these materials)");
            ValhallaMMO.logWarning(String.join((CharSequence)", ", invalidMaterials));
        }
        if (!invalidEntities.isEmpty()) {
            ValhallaMMO.logWarning("The following entities in skills/farming_progression.yml do not exist, no exp values set (ignore warning if your version does not have these entities)");
            ValhallaMMO.logWarning(String.join((CharSequence)", ", invalidEntities));
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !BlockUtils.canReward(e.getBlock()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-farming") || !this.blockDropExpValues.containsKey(e.getBlock().getType()) || e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (!this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        FarmingProfile profile = ProfileCache.getOrCache(e.getPlayer(), FarmingProfile.class);
        int experience = e.getExpToDrop() + Utils.randomAverage(profile.getFarmingExperienceRate());
        e.setExpToDrop(experience);
        LootListener.addPreparedLuck(e.getBlock(), AccumulativeStatManager.getCachedStats("FARMING_LUCK", (Entity)e.getPlayer(), 10000L, true));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void lootTableDrops(BlockBreakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !BlockUtils.canReward(e.getBlock()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-farming") || !this.blockDropExpValues.containsKey(e.getBlock().getType()) || e.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("FARMING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        ItemUtils.multiplyItems(LootListener.getPreparedExtraDrops(e.getBlock()), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.blockDropExpValues.containsKey(i.getType()));
        double expQuantity = 0.0;
        for (ItemStack i2 : LootListener.getPreparedExtraDrops(e.getBlock())) {
            if (ItemUtils.isEmpty(i2)) continue;
            expQuantity += this.blockDropExpValues.getOrDefault(i2.getType(), 0.0) * (double)i2.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteract(PlayerInteractEvent e) {
        Beehive b2;
        Ageable a;
        if (e.getClickedBlock() == null || ValhallaMMO.isWorldBlacklisted(e.getClickedBlock().getWorld().getName()) || e.useInteractedBlock() == Event.Result.DENY || e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getHand() == EquipmentSlot.OFF_HAND || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-farming")) {
            return;
        }
        if (!this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        Block clickedBlock = e.getClickedBlock();
        FarmingProfile profile = ProfileCache.getOrCache(e.getPlayer(), FarmingProfile.class);
        BlockData blockData = clickedBlock.getBlockData();
        if (blockData instanceof Ageable && (a = (Ageable)blockData).getAge() >= a.getMaximumAge() && this.harvestableCrops.contains(clickedBlock.getType())) {
            if (profile.isFieldHarvestUnlocked() && e.getPlayer().isSneaking() && Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "farming_field_harvest") && !this.fieldHarvestingPlayers.contains(e.getPlayer().getUniqueId()) && !WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-abilities-veinfarmer")) {
                Collection<Block> vein = BlockUtils.getBlockVein(clickedBlock, this.fieldHarvestLimit, b -> {
                    Ageable ag;
                    BlockData patt0$temp;
                    return this.harvestableCrops.contains(b.getType()) && (patt0$temp = b.getBlockData()) instanceof Ageable && (ag = (Ageable)patt0$temp).getAge() >= ag.getMaximumAge();
                }, this.fieldHarvestScanArea);
                this.fieldHarvestingPlayers.add(e.getPlayer().getUniqueId());
                e.setCancelled(true);
                if (this.fieldHarvestAnimation != null) {
                    this.fieldHarvestAnimation.animate((LivingEntity)e.getPlayer(), clickedBlock.getLocation(), e.getPlayer().getEyeLocation().getDirection(), 0);
                }
                if (this.fieldHarvestInstant) {
                    BlockUtils.processBlocks(e.getPlayer(), vein, p -> true, b -> {
                        if (profile.isFieldHarvestInstantPickup()) {
                            LootListener.setInstantPickup(b, e.getPlayer());
                        }
                        this.instantHarvest(e.getPlayer(), (Block)b, profile);
                    }, b -> this.fieldHarvestingPlayers.remove(b.getUniqueId()));
                } else {
                    BlockUtils.processBlocksPulse(e.getPlayer(), clickedBlock, vein, p -> true, b -> {
                        if (profile.isFieldHarvestInstantPickup()) {
                            LootListener.setInstantPickup(b, e.getPlayer());
                        }
                        this.instantHarvest(e.getPlayer(), (Block)b, profile);
                    }, b -> this.fieldHarvestingPlayers.remove(b.getUniqueId()));
                }
                Timer.setCooldownIgnoreIfPermission((Entity)e.getPlayer(), profile.getFieldHarvestCooldown() * 50, "farming_field_harvest");
            } else if (profile.isInstantHarvesting()) {
                if (!Timer.isCooldownPassed(e.getPlayer().getUniqueId(), "farming_field_harvest")) {
                    Timer.sendCooldownStatus(e.getPlayer(), "farming_field_harvest", TranslationManager.getTranslation("ability_field_harvest"));
                }
                this.instantHarvest(e.getPlayer(), clickedBlock, profile);
                e.getPlayer().swingMainHand();
            }
        }
        if ((blockData = clickedBlock.getBlockData()) instanceof Beehive && (b2 = (Beehive)blockData).getHoneyLevel() >= b2.getMaximumHoneyLevel()) {
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
                Beehive bee;
                Beehive newHive;
                BlockData patt0$temp = clickedBlock.getBlockData();
                Beehive beehive = newHive = patt0$temp instanceof Beehive ? (bee = (Beehive)patt0$temp) : null;
                if (newHive == null) {
                    return;
                }
                if (newHive.getHoneyLevel() < newHive.getMaximumHoneyLevel()) {
                    if (this.blockInteractExpValues.containsKey(clickedBlock.getType())) {
                        double amount = this.blockInteractExpValues.get(clickedBlock.getType());
                        this.addEXP(e.getPlayer(), amount, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
                        int vanillaExpReward = Utils.randomAverage(profile.getFarmingExperienceRate());
                        if (vanillaExpReward > 0) {
                            ExperienceOrb orb = (ExperienceOrb)clickedBlock.getWorld().spawnEntity(clickedBlock.getLocation().add(0.5, 0.5, 0.5), EntityType.EXPERIENCE_ORB);
                            orb.setExperience(vanillaExpReward);
                        }
                    }
                    if (Utils.proc((LivingEntity)e.getPlayer(), (double)profile.getHiveHoneySaveChance(), false)) {
                        newHive.setHoneyLevel(newHive.getMaximumHoneyLevel());
                        clickedBlock.setBlockData((BlockData)newHive);
                    }
                }
            }, 5L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !this.harvestableCrops.contains(e.getBlock().getType()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-farming")) {
            return;
        }
        Block b = e.getBlock();
        this.growBlock(b, ProfileCache.getOrCache(e.getPlayer(), FarmingProfile.class));
    }

    private void growBlock(Block b, FarmingProfile p) {
        BlockData blockData = b.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable a = (Ageable)blockData;
            int stages = Utils.randomAverage(p.getInstantGrowthRate());
            if (stages <= 0) {
                return;
            }
            a.setAge(Math.min(a.getAge() + stages, a.getMaximumAge() - 1));
            b.setBlockData((BlockData)a);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockHarvest(PlayerHarvestBlockEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getHarvestedBlock().getWorld().getName()) || !this.blockInteractExpValues.containsKey(e.getHarvestedBlock().getType()) || WorldGuardHook.inDisabledRegion(e.getHarvestedBlock().getLocation(), e.getPlayer(), "vmmo-skill-farming")) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("FARMING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        ItemUtils.multiplyItems(e.getItemsHarvested(), dropMultiplier, this.forgivingDropMultipliers, i -> this.blockInteractExpValues.containsKey(i.getType()));
        ItemUtils.multiplyItems(LootListener.getPreparedExtraDrops(e.getHarvestedBlock()), dropMultiplier, this.forgivingDropMultipliers, i -> this.blockInteractExpValues.containsKey(i.getType()));
        double amount = 0.0;
        for (ItemStack i2 : e.getItemsHarvested()) {
            if (ItemUtils.isEmpty(i2)) continue;
            amount += this.blockInteractExpValues.getOrDefault(i2.getType(), 0.0) * (double)i2.getAmount();
        }
        for (ItemStack i2 : LootListener.getPreparedExtraDrops(e.getHarvestedBlock())) {
            if (ItemUtils.isEmpty(i2)) continue;
            amount += this.blockInteractExpValues.getOrDefault(i2.getType(), 0.0) * (double)i2.getAmount();
        }
        this.addEXP(e.getPlayer(), amount, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
        if (!this.hasPermissionAccess(e.getPlayer())) {
            return;
        }
        FarmingProfile profile = ProfileCache.getOrCache(e.getPlayer(), FarmingProfile.class);
        int exp = Utils.randomAverage(profile.getFarmingExperienceRate());
        if (exp > 0) {
            ExperienceOrb orb = (ExperienceOrb)e.getHarvestedBlock().getWorld().spawnEntity(e.getHarvestedBlock().getLocation().add(0.5, 0.5, 0.5), EntityType.EXPERIENCE_ORB);
            orb.setExperience(exp);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemsDropped(BlockDropItemEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlockState().getWorld().getName()) || !BlockUtils.canReward(e.getBlockState()) || WorldGuardHook.inDisabledRegion(e.getBlock().getLocation(), e.getPlayer(), "vmmo-skill-farming") || e.getBlockState() instanceof Container) {
            return;
        }
        double dropMultiplier = AccumulativeStatManager.getCachedStats("FARMING_DROP_MULTIPLIER", (Entity)e.getPlayer(), 10000L, true);
        List<ItemStack> extraDrops = ItemUtils.multiplyDrops(e.getItems(), 1.0 + dropMultiplier, this.forgivingDropMultipliers, i -> this.blockDropExpValues.containsKey(i.getItemStack().getType()));
        LootListener.prepareBlockDrops(e.getBlock(), extraDrops);
        double expQuantity = 0.0;
        for (Item item : e.getItems()) {
            if (ItemUtils.isEmpty(item.getItemStack())) continue;
            expQuantity += this.blockDropExpValues.getOrDefault(item.getItemStack().getType(), 0.0) * (double)item.getItemStack().getAmount();
        }
        for (ItemStack itemStack : extraDrops) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            expQuantity += this.blockDropExpValues.getOrDefault(itemStack.getType(), 0.0) * (double)itemStack.getAmount();
        }
        this.addEXP(e.getPlayer(), expQuantity, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onOtherBlockDrops(PlayerBlocksDropItemsEvent e) {
        double exp = 0.0;
        for (Block b : e.getBlocksAndItems().keySet()) {
            for (ItemStack i : (List)e.getBlocksAndItems().getOrDefault(b, new ArrayList())) {
                if (ItemUtils.isEmpty(i)) continue;
                exp += this.blockDropExpValues.getOrDefault(i.getType(), 0.0) * (double)i.getAmount();
            }
        }
        this.addEXP(e.getPlayer(), exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBeeAggro(EntityTargetLivingEntityEvent e) {
        Player p;
        block6: {
            block5: {
                LivingEntity livingEntity;
                if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !(e.getEntity() instanceof Bee) || !((livingEntity = e.getTarget()) instanceof Player)) break block5;
                p = (Player)livingEntity;
                if (e.getReason() == EntityTargetEvent.TargetReason.CLOSEST_PLAYER && !WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-farming")) break block6;
            }
            return;
        }
        if (!this.hasPermissionAccess(p)) {
            return;
        }
        FarmingProfile profile = ProfileCache.getOrCache(p, FarmingProfile.class);
        if (!profile.hasBeeAggroImmunity()) {
            return;
        }
        e.setCancelled(true);
    }

    private void instantHarvest(Player p, Block b, FarmingProfile profile) {
        Ageable a;
        BlockData blockData = b.getBlockData();
        if (!(blockData instanceof Ageable) || (a = (Ageable)blockData).getAge() < a.getMaximumAge() || !this.blockDropExpValues.containsKey(b.getType())) {
            return;
        }
        a = (Ageable)a.clone();
        a.setAge(0);
        Material previousType = b.getType();
        CustomBreakSpeedListener.markInstantBreak(b);
        b.getWorld().spawnParticle(Particle.valueOf((String)Utils.oldOrNew("BLOCK_CRACK", "BLOCK")), b.getLocation().add(0.5, 0.5, 0.5), 100, 0.1, 0.1, 0.1, 4.0, (Object)b.getBlockData());
        b.getWorld().playSound(b.getLocation().add(0.4, 0.4, 0.4), Sound.BLOCK_CROP_BREAK, 0.3f, 1.0f);
        p.breakBlock(b);
        b.setType(previousType);
        b.setBlockData((BlockData)a);
        this.growBlock(b, profile);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAnimalKill(EntityDeathEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !EntityClassification.matchesClassification(e.getEntityType(), EntityClassification.ANIMAL)) {
            return;
        }
        Player killer = e.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(killer.getLocation(), killer, "vmmo-skill-farming")) {
            return;
        }
        double multiplier = AccumulativeStatManager.getCachedStats("BUTCHERY_DROP_MULTIPLIER", (Entity)killer, 10000L, true);
        ItemUtils.multiplyItems(e.getDrops(), 1.0 + multiplier, this.forgivingDropMultipliers, i -> this.entityDropExpValues.containsKey(i.getType()));
        if (!this.hasPermissionAccess(killer)) {
            return;
        }
        double exp = 0.0;
        for (ItemStack i2 : e.getDrops()) {
            if (ItemUtils.isEmpty(i2)) continue;
            exp += this.entityDropExpValues.getOrDefault(i2.getType(), 0.0) * (double)i2.getAmount();
        }
        this.addEXP(killer, exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAnimalBreed(EntityBreedEvent e) {
        Player p;
        LivingEntity livingEntity;
        block8: {
            block7: {
                if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !EntityClassification.matchesClassification(e.getEntityType(), EntityClassification.ANIMAL)) {
                    return;
                }
                livingEntity = e.getBreeder();
                if (!(livingEntity instanceof Player)) break block7;
                p = (Player)livingEntity;
                livingEntity = e.getEntity();
                if (livingEntity instanceof org.bukkit.entity.Ageable) break block8;
            }
            return;
        }
        org.bukkit.entity.Ageable a = (org.bukkit.entity.Ageable)livingEntity;
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-farming")) {
            return;
        }
        if (!this.hasPermissionAccess(p)) {
            return;
        }
        FarmingProfile profile = ProfileCache.getOrCache(p, FarmingProfile.class);
        int newAge = (int)Math.ceil((double)a.getAge() * (1.0 / (Math.max(-0.999, (double)profile.getGrowUpTimeMultiplier()) + 1.0)));
        a.setAge(newAge);
        e.setExperience(Utils.randomAverage((float)e.getExperience() * profile.getBreedingExpMultiplier()));
        double exp = this.entityBreedExpValues.getOrDefault(e.getEntityType(), 0.0);
        if (exp > 0.0) {
            this.addEXP(p, exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAnimalShear(PlayerShearEntityEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || !EntityClassification.matchesClassification(e.getEntity().getType(), EntityClassification.ANIMAL) || !this.entityShearExpValues.containsKey(e.getEntity().getType())) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-farming")) {
            return;
        }
        double exp = this.entityShearExpValues.getOrDefault(e.getEntity().getType(), 0.0);
        if (exp > 0.0) {
            this.addEXP(e.getPlayer(), exp, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
        }
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return FarmingProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 35;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-farming")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("FARMING_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    public Map<Material, Double> getBlockDropExpValues() {
        return this.blockDropExpValues;
    }
}

