/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Structures;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.DiggingProfile;
import me.athlaeos.valhallammo.skills.skills.implementations.DiggingSkill;
import me.athlaeos.valhallammo.utility.BlockStore;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ArchaeologyListener;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Brushable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.LootTables;
import org.bukkit.plugin.Plugin;

public class DiggingArchaeologyExtension
implements Listener {
    private final DiggingSkill skill;
    private final Map<Structures, Integer> structureRadiusMap = new HashMap<Structures, Integer>();
    private final Map<Structures, LootTables> structureLootTableMap = new HashMap<Structures, LootTables>();
    private final Map<Material, Double> gravelConversionBlocks = new HashMap<Material, Double>();
    private final Map<Material, Double> sandConversionBlocks = new HashMap<Material, Double>();
    private final Map<Material, Double> archaeologyExpValues = new HashMap<Material, Double>();
    private final List<LootTables> rareLootTables = new ArrayList<LootTables>();
    private final List<LootTables> commonLootTables = new ArrayList<LootTables>();
    private final int[][] conversionOffsets = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {0, -1, 0}};
    private final int[][] airScanOffsets = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {0, -1, 0}, {0, 1, 0}};

    public DiggingArchaeologyExtension(DiggingSkill skill) {
        LootTables lootTable;
        Material material;
        double multiplier;
        String[] args;
        HashSet<String> invalidMaterials;
        this.skill = skill;
        ValhallaMMO.getInstance().save("skills/digging_progression.yml");
        ValhallaMMO.getInstance().save("skills/digging.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/digging.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/digging_progression.yml").get();
        ConfigurationSection expSection = progressionConfig.getConfigurationSection("experience.archaeology_brush");
        if (expSection != null) {
            invalidMaterials = new HashSet<String>();
            for (String m : expSection.getKeys(false)) {
                Material material2 = Catch.catchOrElse(() -> Material.valueOf((String)m), null);
                if (material2 == null) {
                    invalidMaterials.add(m);
                    continue;
                }
                this.archaeologyExpValues.put(material2, progressionConfig.getDouble("experience.archaeology_brush." + m));
            }
            if (!invalidMaterials.isEmpty()) {
                ValhallaMMO.logWarning("The following materials in skills/digging_progression.yml do not exist, no exp values set (ignore warning if your version does not have these materials)");
                ValhallaMMO.logWarning(String.join((CharSequence)", ", invalidMaterials));
            }
        }
        invalidMaterials = new HashSet();
        for (String m : skillConfig.getStringList("archaeology_convertable_gravel")) {
            args = m.split(":");
            multiplier = args.length > 1 ? Catch.catchOrElse(() -> StringUtils.parseDouble(args[1]), 1.0) : 1.0;
            material = Catch.catchOrElse(() -> Material.valueOf((String)args[0]), null);
            if (material == null) {
                invalidMaterials.add(args[0]);
                continue;
            }
            this.gravelConversionBlocks.put(material, multiplier);
        }
        for (String m : skillConfig.getStringList("archaeology_convertable_sand")) {
            args = m.split(":");
            multiplier = args.length > 1 ? Catch.catchOrElse(() -> StringUtils.parseDouble(args[1]), 1.0) : 1.0;
            material = Catch.catchOrElse(() -> Material.valueOf((String)args[0]), null);
            if (material == null) {
                invalidMaterials.add(args[0]);
                continue;
            }
            this.sandConversionBlocks.put(material, multiplier);
        }
        if (!invalidMaterials.isEmpty()) {
            ValhallaMMO.logWarning("The following materials in skills/digging.yml do not exist, blocks cannot be converted to suspicious blocks (ignore warning if your version does not have these materials)");
            ValhallaMMO.logWarning(String.join((CharSequence)", ", invalidMaterials));
        }
        for (String table : skillConfig.getStringList("archaeology_rare_loot_tables")) {
            lootTable = Catch.catchOrElse(() -> LootTables.valueOf((String)table), null);
            this.rareLootTables.add(lootTable);
        }
        for (String table : skillConfig.getStringList("archaeology_common_loot_tables")) {
            lootTable = Catch.catchOrElse(() -> LootTables.valueOf((String)table), null);
            this.commonLootTables.add(lootTable);
        }
        HashSet<String> invalidStructures = new HashSet<String>();
        for (String m : skillConfig.getStringList("archaeology_valid_vacinity_structures")) {
            String[] args2 = m.split(":");
            int radius = args2.length > 1 ? Catch.catchOrElse(() -> Integer.parseInt(args2[1]), 2) : 2;
            LootTables lootTable2 = args2.length > 2 ? (LootTables)Catch.catchOrElse(() -> LootTables.valueOf((String)args2[2]), null) : LootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE;
            Structures structure = Catch.catchOrElse(() -> Structures.valueOf(args2[0]), null);
            if (structure == null) {
                invalidStructures.add(args2[0]);
                continue;
            }
            this.structureRadiusMap.put(structure, radius);
            this.structureLootTableMap.put(structure, lootTable2);
        }
        if (!invalidStructures.isEmpty()) {
            ValhallaMMO.logWarning("The following structures in skills/digging.yml do not exist, you might have made a typo or the structure hasn't been added yet");
            ValhallaMMO.logWarning(String.join((CharSequence)", ", invalidMaterials));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !this.sandConversionBlocks.containsKey(e.getBlock().getType()) && !this.gravelConversionBlocks.containsKey(e.getBlock().getType())) {
            return;
        }
        DiggingProfile profile = ProfileCache.getOrCache(e.getPlayer(), DiggingProfile.class);
        Structures nearbyStructure = null;
        if (ValhallaMMO.getNms() != null) {
            Pair<Location, Structures> nearestStructure = ValhallaMMO.getNms().getNearestStructure(e.getBlock().getWorld(), e.getBlock().getLocation(), this.structureRadiusMap);
            nearbyStructure = nearestStructure == null ? null : nearestStructure.getTwo();
        } else {
            for (Structures structure : this.structureRadiusMap.keySet()) {
                if (e.getBlock().getWorld().locateNearestStructure(e.getBlock().getLocation(), structure.getStructure(), this.structureRadiusMap.get((Object)structure).intValue(), false) == null) continue;
                nearbyStructure = structure;
                break;
            }
        }
        block1: for (Object offset : (Object)this.conversionOffsets) {
            double chance;
            Material toBlock;
            Block b = e.getBlock().getLocation().add((double)offset[0], (double)offset[1], (double)offset[2]).getBlock();
            if (BlockStore.isPlaced(b)) continue;
            Object object = this.gravelConversionBlocks.containsKey(b.getType()) ? Material.SUSPICIOUS_GRAVEL : (toBlock = this.sandConversionBlocks.containsKey(b.getType()) ? Material.SUSPICIOUS_SAND : null);
            if (toBlock == null) continue;
            boolean sand = this.sandConversionBlocks.containsKey(e.getBlock().getType());
            double d = chance = nearbyStructure != null ? (double)(sand ? profile.getArchaeologySandNearStructureGenerationChance() : profile.getArchaeologyGravelNearStructureGenerationChance()) : (double)(sand ? profile.getArchaeologySandGenerationChance() : profile.getArchaeologyGravelGenerationChance());
            if (chance <= 0.0 || !Utils.proc((LivingEntity)e.getPlayer(), chance *= (sand ? this.sandConversionBlocks.getOrDefault(e.getBlock().getType(), 1.0) : this.gravelConversionBlocks.getOrDefault(e.getBlock().getType(), 1.0)).doubleValue(), false)) continue;
            for (int[] airOff : this.airScanOffsets) {
                if (b.getLocation().add((double)airOff[0], (double)airOff[1], (double)airOff[2]).getBlock().getType().isAir()) continue block1;
            }
            LootTable table = null;
            if (nearbyStructure != null && this.structureLootTableMap.containsKey((Object)nearbyStructure)) {
                table = this.structureLootTableMap.get((Object)nearbyStructure).getLootTable();
            } else if (Utils.proc((LivingEntity)e.getPlayer(), (double)profile.getArchaeologyDefaultRareLootChance(), false)) {
                if (!this.rareLootTables.isEmpty()) {
                    table = this.rareLootTables.get(Utils.getRandom().nextInt(this.rareLootTables.size())).getLootTable();
                }
            } else if (!this.commonLootTables.isEmpty()) {
                table = this.commonLootTables.get(Utils.getRandom().nextInt(this.commonLootTables.size())).getLootTable();
            }
            if (table == null) continue;
            b.setType(toBlock);
            BrushableBlock brushableBlock = (BrushableBlock)b.getState();
            brushableBlock.setLootTable(table);
            brushableBlock.update();
            ArchaeologyListener.setCustomArchaeologyDrops(b, e.getPlayer(), brushableBlock);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrush(BlockDropItemEvent e) {
        BlockState blockState;
        if (ValhallaMMO.isWorldBlacklisted(e.getBlock().getWorld().getName()) || !((blockState = e.getBlockState()) instanceof BrushableBlock)) {
            return;
        }
        BrushableBlock b = (BrushableBlock)blockState;
        DiggingProfile profile = ProfileCache.getOrCache(e.getPlayer(), DiggingProfile.class);
        double expQuantity = 0.0;
        for (Item item : e.getItems()) {
            if (ItemUtils.isEmpty(item.getItemStack())) continue;
            expQuantity += this.archaeologyExpValues.getOrDefault(item.getItemStack().getType(), 0.0) * (double)item.getItemStack().getAmount();
        }
        for (ItemStack itemStack : LootListener.getPreparedExtraDrops(e.getBlock())) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            expQuantity += this.archaeologyExpValues.getOrDefault(itemStack.getType(), 0.0) * (double)itemStack.getAmount();
        }
        this.skill.addEXP(e.getPlayer(), expQuantity, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
        if (!Utils.proc((LivingEntity)e.getPlayer(), (double)profile.getArchaeologyRepeatChance(), false)) {
            return;
        }
        Material previousMaterial = e.getBlock().getType();
        LootTable lootTable = ArchaeologyListener.getSuspiciousLootTables().get(e.getBlock());
        if (lootTable == null) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            e.getBlock().setType(previousMaterial);
            b.setLootTable(previousTable);
            b.update();
            ArchaeologyListener.setCustomArchaeologyDrops(e.getBlock(), e.getPlayer(), b);
            BlockData patt0$temp = e.getBlock().getBlockData();
            if (patt0$temp instanceof Brushable) {
                Brushable brushable = (Brushable)patt0$temp;
                brushable.setDusted(0);
                e.getBlock().setBlockData((BlockData)brushable);
            }
        }, 2L);
    }
}

