/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ArmorSetManagerCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.AttributeCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.BlockHardnessCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.CustomItemDropCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.CustomItemGiveCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.CustomItemManagerCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.Debugger;
import me.athlaeos.valhallammo.commands.valhallasubcommands.EXPCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ExportCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.GlobalEffectCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.HelpCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ImportCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.LevelledMobSpawnCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ManageLootTablesCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ManageRecipesCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.MigrateCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ModifyCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.PerkRewardCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.PotionAttributeCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.PotionEffectCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ProfileStatsCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ResetProfilesCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ResourcePackCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.SaveAllCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.SpecializedToolCommand;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ViewSkillTreeCommand;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;

public class CommandManager
implements TabExecutor {
    private static final Map<String, Command> commands = new HashMap<String, Command>();

    public CommandManager() {
        commands.put("help", new HelpCommand());
        commands.put("exp", new EXPCommand());
        commands.put("recipes", new ManageRecipesCommand());
        commands.put("profile", new ProfileStatsCommand());
        commands.put("reset", new ResetProfilesCommand());
        commands.put("skills", new ViewSkillTreeCommand());
        commands.put("modify", new ModifyCommand());
        commands.put("reward", new PerkRewardCommand());
        commands.put("attribute", new AttributeCommand());
        commands.put("potionattribute", new PotionAttributeCommand());
        commands.put("effect", new PotionEffectCommand());
        commands.put("loot", new ManageLootTablesCommand());
        commands.put("tool", new SpecializedToolCommand());
        commands.put("armorsets", new ArmorSetManagerCommand());
        commands.put("items", new CustomItemManagerCommand());
        commands.put("give", new CustomItemGiveCommand());
        commands.put("drop", new CustomItemDropCommand());
        commands.put("spawn", new LevelledMobSpawnCommand());
        commands.put("globalbuff", new GlobalEffectCommand());
        commands.put("resourcepack", new ResourcePackCommand());
        commands.put("saveall", new SaveAllCommand());
        commands.put("hardness", new BlockHardnessCommand());
        commands.put("import", new ImportCommand());
        commands.put("export", new ExportCommand());
        commands.put("debug", new Debugger());
        commands.put("migrate", new MigrateCommand());
    }

    public static Map<String, Command> getCommands() {
        return commands;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String name, String[] args) {
        if (args.length == 0) {
            for (String s : TranslationManager.getListTranslation("valhallammo_command_plain")) {
                Utils.sendMessage(sender, s.replace("%version%", ValhallaMMO.getInstance().getDescription().getVersion()));
            }
            return true;
        }
        Command command = commands.get(args[0].toLowerCase(Locale.US));
        if (command == null) {
            Utils.sendMessage(sender, Utils.chat(TranslationManager.getTranslation("error_command_invalid_command")));
            return true;
        }
        if (!command.hasPermission(sender)) {
            Utils.sendMessage(sender, Utils.chat(TranslationManager.getTranslation("error_command_no_permission")));
            return true;
        }
        if (!command.execute(sender, args)) {
            Utils.sendMessage(sender, Utils.chat(command.getFailureMessage(args)));
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String name, String[] args) {
        if (args.length == 1) {
            ArrayList<String> allowedCommands = new ArrayList<String>();
            for (String arg : commands.keySet()) {
                Command command = commands.get(arg);
                if (!command.hasPermission(sender)) continue;
                allowedCommands.add(arg);
            }
            return allowedCommands;
        }
        if (args.length > 1) {
            Command command = commands.get(args[0]);
            if (command == null || !command.hasPermission(sender)) {
                return Command.noSubcommandArgs();
            }
            return command.getSubcommandArgs(sender, args);
        }
        return null;
    }
}

