/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.commands;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ProfileCommand
implements CommandExecutor {
    private final Class<? extends Profile> profile;

    public ProfileCommand(Class<? extends Profile> profile) {
        this.profile = profile;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        Player target;
        if (args.length >= 1) {
            if (!sender.hasPermission("valhalla.profile.other")) {
                Utils.sendMessage(sender, Utils.chat(TranslationManager.getTranslation("error_command_no_permission")));
                return true;
            }
            target = ValhallaMMO.getInstance().getServer().getPlayer(args[0]);
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            Utils.sendMessage(sender, "&cOnly players can do this");
            return true;
        }
        ProfileCommand.displayProfile(sender, target, this.profile);
        return true;
    }

    public static void displayProfile(CommandSender displayTo, Player of, Class<? extends Profile> type) {
        StatFormat format;
        Profile profile = ProfileCache.getOrCache(of, type);
        for (String i : profile.intStatNames()) {
            format = profile.getNumberStatProperties().get(i).getFormat();
            displayTo.sendMessage(Utils.chat(String.format("&f> %s: %s", format == null ? Integer.valueOf(profile.getInt(i)) : format.format(profile.getInt(i)), i)));
        }
        for (String i : profile.floatStatNames()) {
            format = profile.getNumberStatProperties().get(i).getFormat();
            displayTo.sendMessage(Utils.chat(String.format("&f> %s: %s", format == null ? Float.valueOf(profile.getFloat(i)) : format.format(Float.valueOf(profile.getFloat(i))), i)));
        }
        for (String i : profile.doubleStatNames()) {
            format = profile.getNumberStatProperties().get(i).getFormat();
            displayTo.sendMessage(Utils.chat(String.format("&f> %s: %s", format == null ? Double.valueOf(profile.getDouble(i)) : format.format(profile.getDouble(i)), i)));
        }
        for (String i : profile.stringSetStatNames()) {
            displayTo.sendMessage(Utils.chat(String.format("&f> %s: %s", i, String.join((CharSequence)", ", profile.getStringSet(i)))));
        }
        for (String i : profile.booleanStatNames()) {
            displayTo.sendMessage(Utils.chat(String.format("&f> %s: %s", i, profile.getBoolean(i))));
        }
    }
}

