/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.configuration;

import java.io.File;
import java.io.IOException;
import me.athlaeos.valhallammo.ValhallaMMO;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private final String name;
    private File file;
    private YamlConfiguration config;
    private final ValhallaMMO plugin = ValhallaMMO.getInstance();

    public Config(String name) {
        this.name = name;
        this.save();
    }

    public Config save() {
        if (this.config == null || this.file == null || !this.file.exists()) {
            return this;
        }
        try {
            ConfigurationSection section = this.config.getConfigurationSection("");
            if (section != null && !section.getKeys(true).isEmpty()) {
                this.config.save(this.file);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public YamlConfiguration get() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public Config saveDefaultConfig() {
        this.file = new File(this.plugin.getDataFolder(), this.name);
        this.plugin.saveResource(this.name, false);
        return this;
    }

    public Config reload() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), this.name);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        return this;
    }

    public Config copyDefaults(boolean force) {
        this.get().options().copyDefaults(force);
        return this;
    }

    public Config set(String key, Object value) {
        this.get().set(key, value);
        return this;
    }

    public Object get(String key) {
        return this.get().get(key);
    }
}

