/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Comparator;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public enum ToolRequirementType {
    NOT_REQUIRED((i1, i2) -> true),
    EQUAL_OR_LESSER((i1, i2) -> i2 < 0 || i1 <= i2),
    EQUAL((i1, i2) -> i2 < 0 || i1.equals(i2)),
    EQUAL_OR_GREATER((i1, i2) -> i2 < 0 || i1 >= i2),
    NONE_MANDATORY((i1, i2) -> i1 < 0);

    private final Comparator<Integer, Integer> comparator;
    private static final NamespacedKey key_tool_id;

    private ToolRequirementType(Comparator<Integer, Integer> comparator) {
        this.comparator = comparator;
    }

    public boolean check(int heldToolID, int requiredToolID) {
        return this.comparator.compare(heldToolID, requiredToolID);
    }

    public static int getToolID(ItemMeta meta) {
        if (meta == null) {
            return -1;
        }
        return (Integer)meta.getPersistentDataContainer().getOrDefault(key_tool_id, PersistentDataType.INTEGER, (Object)-1);
    }

    public static void setItemsToolID(ItemMeta meta, int id) {
        meta.getPersistentDataContainer().set(key_tool_id, PersistentDataType.INTEGER, (Object)id);
    }

    static {
        key_tool_id = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_tool_id");
    }
}

