/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.food;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.FoodPropertyManager;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SaturationValueSet
extends DynamicItemModifier {
    private float saturation = 4.0f;

    public SaturationValueSet(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        FoodPropertyManager.setSaturationValue(context.getItem().getMeta(), Float.valueOf(this.saturation));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            this.saturation = Math.min(20.0f, Math.max(0.0f, this.saturation + (float)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 5 : 1))));
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.PAPER).name("&eHow much saturation should it replenish?").lore("&fSaturation set to " + this.saturation, "&6Click to add/subtract 1", "&6Shift-Click to add/subtract 5").get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.GOLDEN_CARROT).get();
    }

    @Override
    public String getDisplayName() {
        return "&eSaturation Value (SET)";
    }

    @Override
    public String getDescription() {
        return "&fSets the item's saturation value.";
    }

    @Override
    public String getActiveDescription() {
        return "&fSets the item's saturation value to &e" + this.saturation;
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.FOOD.id());
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    @Override
    public DynamicItemModifier copy() {
        SaturationValueSet m = new SaturationValueSet(this.getName());
        m.setSaturation(this.saturation);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "One argument is expected: a double";
        }
        try {
            this.saturation = StringUtils.parseFloat(args[0]).floatValue();
        }
        catch (NumberFormatException ignored) {
            return "One argument is expected: an integer. It was not a number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<saturation>");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

