/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.EquippableWrapper;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Equippable
extends DynamicItemModifier {
    private String model = null;
    private EquipmentSlot slot = EquipmentSlot.HEAD;
    private String cameraOverlay = null;

    public Equippable(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        if (this.model == null) {
            return;
        }
        EquippableWrapper wrapper = ValhallaMMO.getNms().getEquippable(context.getItem().getMeta());
        wrapper = wrapper == null ? new EquippableWrapper(this.model, this.slot, this.cameraOverlay, null, null) : new EquippableWrapper(this.model, this.slot, this.cameraOverlay == null ? wrapper.cameraOverlayKey() : this.cameraOverlay, wrapper.equipSound(), wrapper.allowedTypes());
        ValhallaMMO.getNms().setEquippable(context.getItem().getMeta(), wrapper.modelKey(), wrapper.slot(), wrapper.cameraOverlayKey(), wrapper.equipSound(), (List<EntityType>)(wrapper.allowedTypes() == null ? null : new ArrayList<EntityType>(wrapper.allowedTypes())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            ItemStack cursor = e.getCursor();
            if (ItemUtils.isEmpty(cursor)) {
                this.model = null;
            } else {
                ItemMeta cursorMeta = cursor.getItemMeta();
                EquippableWrapper wrapper = ValhallaMMO.getNms().getEquippable(cursorMeta);
                if (wrapper == null) {
                    e.getWhoClicked().sendMessage(Utils.chat("&cItem has no custom model"));
                } else {
                    this.model = wrapper.modelKey();
                }
            }
        } else if (button == 18) {
            ItemStack cursor = e.getCursor();
            if (ItemUtils.isEmpty(cursor)) {
                this.cameraOverlay = null;
            } else {
                ItemMeta cursorMeta = cursor.getItemMeta();
                EquippableWrapper wrapper = ValhallaMMO.getNms().getEquippable(cursorMeta);
                if (wrapper == null) {
                    e.getWhoClicked().sendMessage(Utils.chat("&cItem has no custom camera overlay"));
                } else {
                    this.cameraOverlay = wrapper.cameraOverlayKey();
                }
            }
        } else if (button == 16) {
            this.slot = switch (this.slot) {
                case EquipmentSlot.HEAD -> EquipmentSlot.CHEST;
                case EquipmentSlot.CHEST -> EquipmentSlot.LEGS;
                case EquipmentSlot.LEGS -> EquipmentSlot.FEET;
                default -> EquipmentSlot.HEAD;
            };
        }
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, DynamicModifierMenu menu, int button) {
        if (button == 12) {
            if (e.isShiftClick()) {
                this.model = null;
            } else {
                this.ask((Player)e.getWhoClicked(), menu, "What armor model should be used?", answer -> {
                    this.model = answer;
                });
            }
        } else if (button == 18) {
            if (e.isShiftClick()) {
                this.cameraOverlay = null;
            } else {
                this.ask((Player)e.getWhoClicked(), menu, "What camera overlay should be used?", answer -> {
                    this.cameraOverlay = answer;
                });
            }
        } else if (button == 16) {
            this.slot = switch (this.slot) {
                case EquipmentSlot.HEAD -> EquipmentSlot.CHEST;
                case EquipmentSlot.CHEST -> EquipmentSlot.LEGS;
                case EquipmentSlot.LEGS -> EquipmentSlot.FEET;
                default -> EquipmentSlot.HEAD;
            };
        }
    }

    private void ask(Player player, final Menu menu, String question, final Consumer<String> onAnswer) {
        player.closeInventory();
        Questionnaire questionnaire = new Questionnaire(this, player, null, null, new Question[]{new Question("&f" + question + " (type in chat, or 'cancel' to cancel)", s -> true, "")}){
            final /* synthetic */ Equippable this$0;
            {
                this.this$0 = this$0;
                super(who, onStart, onFinish, questions);
            }

            @Override
            public Action<Player> getOnFinish() {
                if (this.getQuestions().isEmpty()) {
                    return super.getOnFinish();
                }
                Question question = this.getQuestions().get(0);
                if (question.getAnswer() == null) {
                    return super.getOnFinish();
                }
                return p -> {
                    String answer = question.getAnswer();
                    if (!answer.contains("cancel")) {
                        onAnswer.accept(answer);
                    }
                    menu.open();
                };
            }
        };
        Questionnaire.startQuestionnaire(player, questionnaire);
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.DIAMOND_CHESTPLATE).name("&fWhich model should the item have?").lore("&fCurrently set to &e" + (this.model == null ? "&cnothing" : this.model), "&fDetermines the visual appearance", "&fof the item when worn", "&6Click with another item to", "&6copy the armor model of the item over").get()).map(Set.of(new Pair<Integer, ItemStack>(18, new ItemBuilder(Material.CARVED_PUMPKIN).name("&fWhich overlay should the item have?").lore("&fCurrently set to &e" + (this.cameraOverlay == null ? "&cnothing" : this.cameraOverlay), "&fDetermines the camera overlay", "&fof the item when worn", "&6Click with another item to", "&6copy the camera overlay of the item over").get()), new Pair<Integer, ItemStack>(16, new ItemBuilder(Material.ARMOR_STAND).name("&fWhich slot should the item be wearable in?").lore("&fCurrently set to &e" + String.valueOf(this.slot), "&fDetermines the slot in which", "&fthe item can be worn", "&6Click to cycle options").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.DIAMOND_CHESTPLATE).get();
    }

    @Override
    public String getDisplayName() {
        return "&aSet Equippable";
    }

    @Override
    public String getDescription() {
        return "&fAllows the item to be wearable, or its worn model to change";
    }

    @Override
    public String getActiveDescription() {
        return this.model == null ? "&cRemoves equippable properties" : "&fSets the item to be equippable, changing its model to " + this.model + " and wearable in the " + String.valueOf(this.slot) + " slot. " + (String)(this.cameraOverlay == null ? "" : "&eApplies the " + this.cameraOverlay + " camera overlay when worn");
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setCameraOverlay(String cameraOverlay) {
        this.cameraOverlay = cameraOverlay;
    }

    public void setSlot(EquipmentSlot slot) {
        this.slot = slot;
    }

    @Override
    public DynamicItemModifier copy() {
        Equippable m = new Equippable(this.getName());
        m.setModel(this.model);
        m.setSlot(this.slot);
        m.setCameraOverlay(this.cameraOverlay);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 3) {
            return "You must enter armor model key, the slot, and the camera overlay key. Use 'reset' for options you don't want";
        }
        try {
            this.model = args[0].equalsIgnoreCase("reset") ? null : args[0];
            this.slot = EquipmentSlot.valueOf((String)args[1]);
            this.cameraOverlay = args[2].equalsIgnoreCase("reset") ? null : args[2];
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid slot. It may be HEAD, CHEST, LEGS, or FEET";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<model>", "minecraft:", "reset");
        }
        if (currentArg == 1) {
            return List.of("HEAD", "CHEST", "LEGS", "FEET");
        }
        if (currentArg == 2) {
            return List.of("<cameraOverlay>", "minecraft:", "reset");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 3;
    }
}

