/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.EquippableWrapper;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Colorable;

public class FancyPantsOrEquippable
extends DynamicItemModifier {
    private Material newMaterial = Material.IRON_CHESTPLATE;
    private String model = null;
    private EquipmentSlot slot = EquipmentSlot.HEAD;
    private String cameraOverlay = null;
    private Material oldMaterial = Material.LEATHER_CHESTPLATE;
    private int red = 0;
    private int green = 0;
    private int blue = 0;

    public FancyPantsOrEquippable(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_21_3)) {
            if (this.model == null) {
                return;
            }
            context.getItem().type(this.newMaterial);
            EquippableWrapper wrapper = ValhallaMMO.getNms().getEquippable(context.getItem().getMeta());
            wrapper = wrapper == null ? new EquippableWrapper(this.model, this.slot, this.cameraOverlay, null, null) : new EquippableWrapper(this.model, this.slot, this.cameraOverlay == null ? wrapper.cameraOverlayKey() : this.cameraOverlay, wrapper.equipSound(), wrapper.allowedTypes());
            ValhallaMMO.getNms().setEquippable(context.getItem().getMeta(), wrapper.modelKey(), wrapper.slot(), wrapper.cameraOverlayKey(), wrapper.equipSound(), (List<EntityType>)(wrapper.allowedTypes() == null ? null : new ArrayList<EntityType>(wrapper.allowedTypes())));
        } else {
            context.getItem().type(this.oldMaterial);
            context.getItem().color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue));
        }
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, DynamicModifierMenu menu, int button) {
        if (button == 5) {
            if (!ItemUtils.isEmpty(e.getCursor())) {
                this.oldMaterial = e.getCursor().getType();
            }
        } else if (button == 7 || button == 8 || button == 9) {
            ItemStack cursor = e.getCursor();
            if (!ItemUtils.isEmpty(cursor)) {
                Colorable c;
                ItemMeta meta = cursor.getItemMeta();
                if (meta instanceof Colorable && (c = (Colorable)meta).getColor() != null) {
                    Color color = c.getColor().getColor();
                    this.red = color.getRed();
                    this.green = color.getGreen();
                    this.blue = color.getBlue();
                }
            } else if (button == 7) {
                this.red = Math.min(255, Math.max(0, this.red + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 25 : 1)));
            } else if (button == 8) {
                this.green = Math.min(255, Math.max(0, this.green + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 25 : 1)));
            } else {
                this.blue = Math.min(255, Math.max(0, this.blue + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 25 : 1)));
            }
        } else if (button == 15) {
            if (!ItemUtils.isEmpty(e.getCursor())) {
                this.newMaterial = e.getCursor().getType();
            }
        } else if (button == 17) {
            if (e.isShiftClick()) {
                this.model = null;
            } else {
                this.ask((Player)e.getWhoClicked(), menu, "What armor model should be used?", answer -> {
                    this.model = answer;
                });
            }
        } else if (button == 18) {
            if (e.isShiftClick()) {
                this.cameraOverlay = null;
            } else {
                this.ask((Player)e.getWhoClicked(), menu, "What camera overlay should be used?", answer -> {
                    this.cameraOverlay = answer;
                });
            }
        } else if (button == 19) {
            this.slot = switch (this.slot) {
                case EquipmentSlot.HEAD -> EquipmentSlot.CHEST;
                case EquipmentSlot.CHEST -> EquipmentSlot.LEGS;
                case EquipmentSlot.LEGS -> EquipmentSlot.FEET;
                default -> EquipmentSlot.HEAD;
            };
        }
    }

    private void ask(Player player, final Menu menu, String question, final Consumer<String> onAnswer) {
        player.closeInventory();
        Questionnaire questionnaire = new Questionnaire(this, player, null, null, new Question[]{new Question("&f" + question + " (type in chat, or 'cancel' to cancel)", s -> true, "")}){
            final /* synthetic */ FancyPantsOrEquippable this$0;
            {
                this.this$0 = this$0;
                super(who, onStart, onFinish, questions);
            }

            @Override
            public Action<Player> getOnFinish() {
                if (this.getQuestions().isEmpty()) {
                    return super.getOnFinish();
                }
                Question question = this.getQuestions().get(0);
                if (question.getAnswer() == null) {
                    return super.getOnFinish();
                }
                return p -> {
                    String answer = question.getAnswer();
                    if (!answer.contains("cancel")) {
                        onAnswer.accept(answer);
                    }
                    menu.open();
                };
            }
        };
        Questionnaire.startQuestionnaire(player, questionnaire);
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        String hex = Utils.rgbToHex(this.red, this.green, this.blue);
        return new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.DIAMOND_CHESTPLATE).name("&fWhich model should the item have?").lore("&fCurrently set to &e" + (this.model == null ? "&cnothing" : this.model), "&fDetermines the visual appearance", "&fof the item when worn", "&6Click with another item to", "&6copy the armor model of the item over").get()).map(Set.of(new Pair<Integer, ItemStack>(18, new ItemBuilder(Material.CARVED_PUMPKIN).name("&fWhich overlay should the item have?").lore("&fCurrently set to &e" + (this.cameraOverlay == null ? "&cnothing" : this.cameraOverlay), "&fDetermines the camera overlay", "&fof the item when worn", "&6Click with another item to", "&6copy the camera overlay of the item over").get()), new Pair<Integer, ItemStack>(19, new ItemBuilder(Material.ARMOR_STAND).name("&fWhich slot should the item be wearable in?").lore("&fCurrently set to &e" + String.valueOf(this.slot), "&fDetermines the slot in which", "&fthe item can be worn", "&6Click to cycle options").get()), new Pair<Integer, ItemStack>(15, new ItemBuilder(Material.ARMOR_STAND).name("&fWhat should the item be in 1.21.3+?").lore("&fCurrently set to &e" + String.valueOf(this.newMaterial), "&fIf the server is running a minecraft", "&fversion compatible with the equippable", "&fcomponent, allowing for proper custom", "&farmors, then the item type is set to", "&f" + String.valueOf(this.newMaterial), "&6Click with item to copy type").get()), new Pair<Integer, ItemStack>(5, new ItemBuilder(Material.ARMOR_STAND).name("&fWhat should the item be in below 1.21.3?").lore("&fCurrently set to &e" + String.valueOf(this.oldMaterial), "&fIf the server is running a minecraft", "&fversion &cincompatible&f with the equippable", "&fcomponent, and instead uses the FancyPants", "&fshader for custom armors, then the material", "&fis set to " + String.valueOf(this.oldMaterial), "&cThis should generally be leather armor", "&cbecause FancyPants relies on it being", "&ccolorable", "&6Click with item to copy type").get()), new Pair<Integer, ItemStack>(7, new ItemBuilder(Material.POTION).name("&cHow red should it be?").lore("&6Click with another item to copy", "&6its custom model data over.", "&fSet to &" + hex + hex, "&c" + this.red + "&7| &a" + this.green + "&7| &b" + this.blue, "&6Click to add/subtract 1000000", "&6Shift-Click to add/subtract 100000").color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue)).flag(ConventionUtils.getHidePotionEffectsFlag()).get()), new Pair<Integer, ItemStack>(8, new ItemBuilder(Material.POTION).name("&aHow green should it be?").lore("&6Click with another item to copy", "&6its custom model data over.", "&fSet to &" + hex + hex, "&c" + this.red + "&7| &a" + this.green + "&7| &b" + this.blue, "&6Click to add/subtract 10000", "&6Shift-Click to add/subtract 1000").color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue)).flag(ConventionUtils.getHidePotionEffectsFlag()).get()), new Pair<Integer, ItemStack>(9, new ItemBuilder(Material.POTION).name("&bHow blue should it be?").lore("&6Click with another item to copy", "&6its custom model data over.", "&fSet to &" + hex + hex, "&c" + this.red + "&7| &a" + this.green + "&7| &b" + this.blue, "&6Click to add/subtract 25", "&6Shift-Click to add/subtract 1").color(Color.fromRGB((int)this.red, (int)this.green, (int)this.blue)).flag(ConventionUtils.getHidePotionEffectsFlag()).get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.LEATHER_CHESTPLATE).get();
    }

    @Override
    public String getDisplayName() {
        return "&aCustom Armor: &eFancyPants or EquippableComponent";
    }

    @Override
    public String getDescription() {
        return "&fChanges the item type depending on version. If FancyPants is required for custom armors, color the leather armor. If not, use EquippableComponent";
    }

    @Override
    public String getActiveDescription() {
        return "&fChanges the item type depending on version. If FancyPants is required for custom armors, color the leather armor. If not, use EquippableComponent";
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setNewMaterial(Material newMaterial) {
        this.newMaterial = newMaterial;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    public void setOldMaterial(Material oldMaterial) {
        this.oldMaterial = oldMaterial;
    }

    public void setRed(int red) {
        this.red = red;
    }

    public void setCameraOverlay(String cameraOverlay) {
        this.cameraOverlay = cameraOverlay;
    }

    public void setSlot(EquipmentSlot slot) {
        this.slot = slot;
    }

    @Override
    public DynamicItemModifier copy() {
        FancyPantsOrEquippable m = new FancyPantsOrEquippable(this.getName());
        m.setModel(this.model);
        m.setSlot(this.slot);
        m.setCameraOverlay(this.cameraOverlay);
        m.setPriority(this.getPriority());
        m.setBlue(this.blue);
        m.setGreen(this.green);
        m.setRed(this.red);
        m.setNewMaterial(this.newMaterial);
        m.setOldMaterial(this.oldMaterial);
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        return "This modifier is too complex to be used with a command";
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 0;
    }
}

