/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.ItemRarityWrapper;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ItemRarity
extends DynamicItemModifier {
    private ItemRarityWrapper rarity = ItemRarityWrapper.COMMON;

    public ItemRarity(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        ValhallaMMO.getNms().setItemRarity(context.getItem().getMeta(), this.rarity);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            List<ItemRarityWrapper> rarities = Arrays.asList(ItemRarityWrapper.values());
            int currentClass = rarities.indexOf((Object)this.rarity);
            currentClass = e.isLeftClick() ? (currentClass + 1 >= rarities.size() ? 0 : ++currentClass) : (currentClass - 1 < 0 ? rarities.size() - 1 : --currentClass);
            this.rarity = rarities.get(currentClass);
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.PAPER).name("&eWhich rarity should it be?").lore("&fRarity set to " + this.rarity.getColor() + String.valueOf((Object)this.rarity), "&fHas no effect on gameplay, unless", "&fother plugins implement such effects.", "&fMerely changes the default name color", "&fof the item").get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.ENCHANTED_GOLDEN_APPLE).get();
    }

    @Override
    public String getDisplayName() {
        return "&dRarity";
    }

    @Override
    public String getDescription() {
        return "&fChanges the rarity of an item.";
    }

    @Override
    public String getActiveDescription() {
        return "&fRarity set to " + this.rarity.getColor() + String.valueOf((Object)this.rarity);
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setRarity(ItemRarityWrapper rarity) {
        this.rarity = rarity;
    }

    @Override
    public DynamicItemModifier copy() {
        ItemRarity m = new ItemRarity(this.getName());
        m.setRarity(this.rarity);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate the rarity to set the item to";
        }
        try {
            this.rarity = ItemRarityWrapper.valueOf(args[0]);
        }
        catch (IllegalArgumentException ignored) {
            return "Invalid rarity, valid classes are: " + Arrays.stream(ItemRarityWrapper.values()).map(r -> r.getColor() + String.valueOf(r)).collect(Collectors.joining(", "));
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return Arrays.stream(ItemRarityWrapper.values()).map(Enum::toString).toList();
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

