/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ResultChangingModifier;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ItemReplaceKeepingAmount
extends DynamicItemModifier
implements ResultChangingModifier {
    private ItemStack replaceBy = new ItemStack(Material.DIAMOND);

    public ItemReplaceKeepingAmount(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        int amount = context.getItem().getItem().getAmount();
        context.getItem().setItem(this.replaceBy);
        context.getItem().setMeta(ItemUtils.getItemMeta(this.replaceBy));
        context.getItem().amount(amount);
    }

    @Override
    public ItemStack getNewResult(ModifierContext context) {
        return this.replaceBy;
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        ItemStack cursor;
        if (button == 12 && !ItemUtils.isEmpty(cursor = e.getCursor())) {
            this.replaceBy = cursor.clone();
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(this.replaceBy).name("&eWhat should the new item be?").lore("&6Click with another item to", "&6copy it over.", "&fSet to " + ItemUtils.getItemName(new ItemBuilder(this.replaceBy))).get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.LAPIS_LAZULI).get();
    }

    @Override
    public String getDisplayName() {
        return "&dReplace Item, keeping same quantity";
    }

    @Override
    public String getDescription() {
        return "&fReplaces the item with another one, but the original amount of the item stays the same.";
    }

    @Override
    public String getActiveDescription() {
        return "&fItem will be replaced by " + ItemUtils.getItemName(new ItemBuilder(this.replaceBy)) + ", but the original amount of the item stays the same.";
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setReplaceBy(ItemStack replaceBy) {
        this.replaceBy = replaceBy;
    }

    @Override
    public DynamicItemModifier copy() {
        ItemReplaceKeepingAmount m = new ItemReplaceKeepingAmount(this.getName());
        m.setReplaceBy(this.replaceBy);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate the item type for replacement, or 'hand' for your current held item";
        }
        if (args[0].equalsIgnoreCase("hand")) {
            if (!(executor instanceof Player)) {
                return "This argument requires you to be a player for usage";
            }
            Player p = (Player)executor;
            ItemStack held = p.getInventory().getItemInMainHand();
            if (ItemUtils.isEmpty(held)) {
                return "The replace-by item cannot be nothing";
            }
            this.replaceBy = held.clone();
        } else {
            try {
                ItemStack item = new ItemStack(Material.valueOf((String)args[0]));
                if (ItemUtils.isEmpty(item)) {
                    return "The replace-by item cannot be nothing";
                }
                this.replaceBy = new ItemStack(item);
            }
            catch (IllegalArgumentException ignored) {
                return "A material is required. Invalid material";
            }
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return Arrays.stream(Material.values()).map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

