/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ResultChangingModifier;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ItemType
extends DynamicItemModifier
implements ResultChangingModifier {
    private Material material = Material.DIAMOND;

    public ItemType(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        context.getItem().type(this.material);
        PotionEffectRegistry.updateItemName(context.getItem(), true, false);
    }

    @Override
    public ItemStack getNewResult(ModifierContext context) {
        return context.getItem().copy().type(this.material).get();
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        ItemStack cursor;
        if (button == 12 && !ItemUtils.isEmpty(cursor = e.getCursor())) {
            this.material = cursor.getType();
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(this.material).name("&eWhat should the new item type be?").lore("&6Click with another item to", "&6copy its type over.", "&fSet to " + StringUtils.toPascalCase(this.material.toString())).get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.SLIME_BALL).get();
    }

    @Override
    public String getDisplayName() {
        return "&aChange Item Type";
    }

    @Override
    public String getDescription() {
        return "&fReplaces the item type with another one";
    }

    @Override
    public String getActiveDescription() {
        return "&fItem type will change to " + StringUtils.toPascalCase((this.material == null ? Material.BARRIER : this.material).toString());
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    @Override
    public DynamicItemModifier copy() {
        ItemType m = new ItemType(this.getName());
        m.setMaterial(this.material);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "You must indicate the item type for replacement, or 'hand' for your current held item type";
        }
        if (args[0].equalsIgnoreCase("hand")) {
            if (!(executor instanceof Player)) {
                return "This argument requires you to be a player for usage";
            }
            Player p = (Player)executor;
            ItemStack held = p.getInventory().getItemInMainHand();
            if (ItemUtils.isEmpty(held)) {
                return "The replace-by type cannot be nothing";
            }
            this.material = held.getType();
        } else {
            try {
                Material m = Material.valueOf((String)args[0]);
                if (m.isAir()) {
                    return "The replace-by type cannot be nothing";
                }
                this.material = m;
            }
            catch (IllegalArgumentException ignored) {
                return "A material is required. Invalid material";
            }
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return Arrays.stream(Material.values()).map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

