/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class LoreSet
extends DynamicItemModifier {
    private List<String> lore = new ArrayList<String>();
    private int mode = 0;

    public LoreSet(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        if (this.lore.isEmpty()) {
            context.getItem().lore(this.lore);
        } else {
            switch (this.mode) {
                case 0: {
                    context.getItem().prependLore(this.lore);
                    break;
                }
                case 1: {
                    context.getItem().appendLore(this.lore);
                    break;
                }
                case 2: {
                    context.getItem().lore(this.lore);
                }
            }
        }
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, DynamicModifierMenu menu, int button) {
        if (button == 11) {
            this.mode = Math.max(0, Math.min(2, this.mode + (e.isLeftClick() ? 1 : -1)));
        } else if (button == 13) {
            if (e.isShiftClick()) {
                this.lore.clear();
            } else {
                this.ask((Player)e.getWhoClicked(), menu, "What lore should be used? Use /n for a new line, or /_ for a forceful space", answer -> {
                    this.lore = new ArrayList<String>(List.of(answer.replace("/_", " ").split("/n")));
                });
            }
        }
    }

    private void ask(Player player, final Menu menu, String question, final Consumer<String> onAnswer) {
        player.closeInventory();
        Questionnaire questionnaire = new Questionnaire(this, player, null, null, new Question[]{new Question("&f" + question + " (type in chat, or 'cancel' to cancel)", s -> true, "")}){
            final /* synthetic */ LoreSet this$0;
            {
                this.this$0 = this$0;
                super(who, onStart, onFinish, questions);
            }

            @Override
            public Action<Player> getOnFinish() {
                if (this.getQuestions().isEmpty()) {
                    return super.getOnFinish();
                }
                Question question = this.getQuestions().get(0);
                if (question.getAnswer() == null) {
                    return super.getOnFinish();
                }
                return p -> {
                    String answer = question.getAnswer();
                    if (!answer.contains("cancel")) {
                        onAnswer.accept(answer);
                    }
                    menu.open();
                };
            }
        };
        Questionnaire.startQuestionnaire(player, questionnaire);
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.INK_SAC).name("&eWhat should the lore be?").lore(this.mode == 0 ? "&fThe following is added to the start" : (this.mode == 1 ? "&fThe following is added to the end" : "&fThe lore will be set to"), "&8&m                                 ").appendLore(this.lore.isEmpty() ? List.of("&cLore is cleared") : this.lore).appendLore("&8&m                                 ", "&6Click to set the lore (in chat)", "&6Or shift-click to reset").get()).map(Set.of(new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.REDSTONE_TORCH).name("&eHow should the lore be added?").lore(this.mode == 0 ? "&fThe following is added to the start" : (this.mode == 1 ? "&fThe following is added to the end" : "&fThe lore will be set to"), "&8&m                                 ").appendLore(this.lore.isEmpty() ? List.of("&cLore is cleared") : this.lore).appendLore("&8&m                                 ", "&6Click to cycle").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.WRITABLE_BOOK).get();
    }

    @Override
    public String getDisplayName() {
        return "&dLore";
    }

    @Override
    public String getDescription() {
        return "&fChanges the lore of the item";
    }

    @Override
    public String getActiveDescription() {
        return "&fChanges the lore of the item to " + (String)(this.lore.isEmpty() ? "be cleared" : "/n" + String.join((CharSequence)"/n", this.lore));
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.ITEM_MISC.id());
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    @Override
    public DynamicItemModifier copy() {
        LoreSet m = new LoreSet(this.getName());
        m.setLore(new ArrayList<String>(this.lore));
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 2) {
            return "You must indicate the new lore of the item, or 'null' to clear it, along with the mode. 0 = prepend, 1 = append, 2 = replace";
        }
        if (args[0].equalsIgnoreCase("null")) {
            this.lore.clear();
        } else {
            this.lore.addAll(Arrays.stream(args[0].split("/n")).map(l -> l.replace("/_", " ")).toList());
        }
        Integer mode = Catch.catchOrElse(() -> Integer.parseInt(args[1]), null);
        if (mode == null || mode < 0 || mode > 2) {
            return "Invalid/absent mode, 0 = prepend before lore, 1 = append after lore, 2 = replace lore";
        }
        this.mode = mode;
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<lore>", "use-/n-for-new-lines", "use-/_-for-spaces");
        }
        if (currentArg == 1) {
            return List.of("<mode>", "0-for-prepend", "1-for-append", "2-for-replace");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 2;
    }
}

