/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_stats;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.MiningSpeed;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MiningSpeedSet
extends DynamicItemModifier {
    private double value = 0.0;

    public MiningSpeedSet(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        MiningSpeed.setMultiplier(context.getItem().getMeta(), this.value);
        ValhallaMMO.getNms().setTool(context.getItem(), (float)this.value, true);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            this.value = Math.max(0.0, this.value + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1.0 : 0.1));
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.PAPER).name("&dWhat mining speed should it have?").lore("&f" + this.value, "&6Click to add/subtract 0.1", "&6Shift-Click to add/subtract 1").get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.DIAMOND_PICKAXE).get();
    }

    @Override
    public String getDisplayName() {
        return "&eMining Speed";
    }

    @Override
    public String getDescription() {
        return "&fSets the mining speed of the item, acting as a speed multiplier";
    }

    @Override
    public String getActiveDescription() {
        return "&fSets the mining speed of the item to " + this.value;
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.CUSTOM_ATTRIBUTES.id());
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public DynamicItemModifier copy() {
        MiningSpeedSet m = new MiningSpeedSet(this.getName());
        m.setValue(this.value);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 1) {
            return "One argument expected: a number";
        }
        try {
            this.value = StringUtils.parseDouble(args[0]);
        }
        catch (IllegalArgumentException ignored) {
            return "One argument expected: a number. Invalid number given";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<value>");
        }
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

