/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.potion_misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.AlchemyItemPropertyManager;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AlchemyQualityScale
extends DynamicItemModifier {
    private double skillEfficiency = 1.0;
    private EffectClass effectClass = EffectClass.BUFF;

    public AlchemyQualityScale(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        double typeSkill = this.effectClass == null || this.effectClass == EffectClass.NEUTRAL ? 0.0 : AccumulativeStatManager.getCachedStats("ALCHEMY_QUALITY_" + String.valueOf((Object)this.effectClass), (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
        double generalSkill = AccumulativeStatManager.getCachedStats("ALCHEMY_QUALITY_GENERAL", (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
        double typeMultiplier = this.effectClass == null || this.effectClass == EffectClass.NEUTRAL ? 0.0 : AccumulativeStatManager.getCachedStats("ALCHEMY_FRACTION_QUALITY_" + String.valueOf((Object)this.effectClass), (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
        double generalMultiplier = 1.0 + AccumulativeStatManager.getCachedStats("ALCHEMY_FRACTION_QUALITY_GENERAL", (Entity)context.getCrafter(), 10000L, context.shouldExecuteUsageMechanics());
        AlchemyItemPropertyManager.setQuality(context.getItem(), (int)((generalMultiplier + typeMultiplier) * ((typeSkill + generalSkill) * this.skillEfficiency)));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 11) {
            this.skillEfficiency = Math.max(0.0, this.skillEfficiency + (double)(e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 0.1 : 0.01));
        } else if (button == 13) {
            int currentType = Arrays.asList(EffectClass.values()).indexOf((Object)this.effectClass);
            currentType = e.isLeftClick() ? (currentType + 1 >= EffectClass.values().length ? 0 : ++currentType) : (currentType - 1 < 0 ? EffectClass.values().length - 1 : --currentType);
            this.effectClass = EffectClass.values()[currentType];
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.PAPER).name("&eHow much quality to set?").lore("&fSets the quality to &e" + StatFormat.PERCENTILE_BASE_1_P1.format(this.skillEfficiency), "&fof the player's alchemy skill.", "", "&fFor example, 300 alchemy skill", "&fis converted to &e" + (int)Math.floor(this.skillEfficiency * 300.0) + " &fquality", "&6Click to add/subtract 1%", "&6Shift-Click to add/subtract 10%").get()).map(new HashSet());
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.NETHER_STAR).get();
    }

    @Override
    public String getDisplayName() {
        return "&dAlchemy Quality (DYNAMIC)";
    }

    @Override
    public String getDescription() {
        return "&fSets an item's quality based on player skill.";
    }

    @Override
    public String getActiveDescription() {
        return "&fSets the item's quality to &e" + StatFormat.PERCENTILE_BASE_1_P1.format(this.skillEfficiency) + "&f of the player's skill";
    }

    @Override
    public boolean requiresPlayer() {
        return true;
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.POTION_MISC.id());
    }

    public void setSkillEfficiency(double skillEfficiency) {
        this.skillEfficiency = skillEfficiency;
    }

    public void setEffectClass(EffectClass effectClass) {
        this.effectClass = effectClass;
    }

    @Override
    public DynamicItemModifier copy() {
        AlchemyQualityScale m = new AlchemyQualityScale(this.getName());
        m.setEffectClass(this.effectClass);
        m.setSkillEfficiency(this.skillEfficiency);
        m.setPriority(this.getPriority());
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        if (args.length != 2) {
            return "One number is expected: a double.";
        }
        try {
            this.skillEfficiency = StringUtils.parseDouble(args[0]);
        }
        catch (NumberFormatException ignored) {
            return "One number is expected: a double. It was not a number";
        }
        return null;
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        if (currentArg == 0) {
            return List.of("<skill_quality_fraction>");
        }
        return null;
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }
}

