/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.potion_misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.commands.Command;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PotionEffectConvert
extends DynamicItemModifier {
    private static final List<String> types = new ArrayList<String>();
    private final Map<String, Effect> conversions = new HashMap<String, Effect>();
    private String selectedFrom = "SPEED";
    private double value = 0.1;
    private long duration = 1800L;
    private String selectedTo = "SLOW";

    public PotionEffectConvert(String name) {
        super(name);
    }

    @Override
    public void processItem(ModifierContext context) {
        Map<String, PotionEffectWrapper> effects = PotionEffectRegistry.getStoredEffects(context.getItem().getMeta(), true);
        for (String from : this.conversions.keySet()) {
            if (effects.remove(from) == null) continue;
            PotionEffectRegistry.removeEffect(context.getItem(), from);
            PotionEffectWrapper to = PotionEffectRegistry.getEffect(this.conversions.get((Object)from).effect);
            to.setAmplifier(this.conversions.get((Object)from).amplifier);
            to.setDuration(this.conversions.get((Object)from).duration);
            effects.put(to.getEffect(), to);
            PotionEffectRegistry.addDefaultEffect(context.getItem(), to);
        }
        PotionEffectRegistry.updateItemName(context.getItem(), true, false);
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 12) {
            PotionEffectWrapper effectTo = PotionEffectRegistry.getEffect(this.selectedTo);
            this.value += (double)(e.isLeftClick() ? 1 : -1) * (effectTo.isVanilla() ? (double)(e.isShiftClick() ? 3 : 1) : (e.isShiftClick() ? 0.25 : 0.01));
            if (effectTo.isVanilla()) {
                this.value = Math.max(0.0, this.value);
            }
        } else if (button == 17) {
            this.duration = Math.max(0L, this.duration + (long)((e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 300 : 20)));
        } else if (button == 11) {
            if (types.isEmpty()) {
                PotionEffectConvert.populate();
            }
            int currentIndex = this.selectedFrom == null ? -1 : types.indexOf(this.selectedFrom);
            currentIndex = Math.max(0, Math.min(types.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
            this.selectedFrom = types.get(currentIndex);
        } else if (button == 7) {
            if (types.isEmpty()) {
                PotionEffectConvert.populate();
            }
            int currentIndex = this.selectedTo == null ? -1 : types.indexOf(this.selectedTo);
            currentIndex = Math.max(0, Math.min(types.size() - 1, currentIndex + (e.isLeftClick() ? 1 : -1)));
            this.selectedTo = types.get(currentIndex);
            PotionEffectWrapper effectTo = PotionEffectRegistry.getEffect(this.selectedTo);
            if (effectTo.isVanilla()) {
                this.value = Math.max(0.0, this.value);
            }
        } else if (button == 14) {
            if (e.isShiftClick()) {
                this.conversions.clear();
            } else {
                this.conversions.put(this.selectedFrom, new Effect(this.selectedTo, this.value, this.duration));
            }
        }
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        Object infoTo;
        Object infoFrom;
        if (types.isEmpty()) {
            PotionEffectConvert.populate();
        }
        if (types.isEmpty()) {
            infoFrom = "&cNo potion effects found(???)";
        } else {
            int currentIndex;
            if (this.selectedFrom == null) {
                this.selectedFrom = types.get(0);
            }
            String before = (currentIndex = types.indexOf(this.selectedFrom)) <= 0 ? "" : types.get(currentIndex - 1) + " > &e";
            String after = currentIndex + 1 >= types.size() ? "" : "&f > " + types.get(currentIndex + 1);
            infoFrom = "&f" + before + this.selectedFrom + after;
        }
        if (types.isEmpty()) {
            infoTo = "&cNo potion effects found(???)";
        } else {
            int currentIndex;
            if (this.selectedTo == null) {
                this.selectedTo = types.get(0);
            }
            String before = (currentIndex = types.indexOf(this.selectedTo)) <= 0 ? "" : types.get(currentIndex - 1) + " > &e";
            String after = currentIndex + 1 >= types.size() ? "" : "&f > " + types.get(currentIndex + 1);
            infoTo = "&f" + before + this.selectedTo + after;
        }
        PotionEffectWrapper effectFrom = PotionEffectRegistry.getEffect(this.selectedFrom);
        PotionEffectWrapper effectTo = PotionEffectRegistry.getEffect(this.selectedTo);
        String effectDescription = effectFrom.getTrimmedEffectName() + " &f>>> " + effectTo.getFormattedEffectName(true, this.value, this.duration);
        return new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.PAPER).name("&dHow strong should this effect be?").lore("&f" + effectDescription, "&6Click to add/subtract 0.01", "&6Shift-Click to add/subtract 0.25").get()).map(Set.of(new Pair<Integer, ItemStack>(17, new ItemBuilder(Material.PAPER).name("&dHow long should the duration be?").lore("&f" + effectDescription, "&6Click to add/subtract 1 second", "&6Shift-Click to add/subtract 15 seconds").get()), new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.FERMENTED_SPIDER_EYE).name("&dWhat effects should be converted?").lore("&e" + (String)infoFrom, "&6Click to cycle").get()), new Pair<Integer, ItemStack>(7, new ItemBuilder(Material.POTION).name("&dWhat should" + effectFrom.getEffectName() + " be converted to?").lore("&e" + (String)infoTo, "&6Click to cycle").flag(ConventionUtils.getHidePotionEffectsFlag()).get()), new Pair<Integer, ItemStack>(14, new ItemBuilder(Material.STRUCTURE_VOID).name("&dAdd conversion").lore("&fCurrently selected &f" + effectDescription).appendLore(this.conversions.keySet().stream().map(e -> {
            PotionEffectWrapper from = PotionEffectRegistry.getEffect(e);
            Effect details = this.conversions.get(e);
            PotionEffectWrapper to = PotionEffectRegistry.getEffect(details.effect);
            return "&f> " + from.getTrimmedEffectName() + " &f>>> " + to.getFormattedEffectName(true, details.amplifier, details.duration);
        }).toList()).appendLore("&6Click to add", "&cShift-Click to clear").get())));
    }

    @Override
    public ItemStack getModifierIcon() {
        return new ItemBuilder(Material.FERMENTED_SPIDER_EYE).get();
    }

    @Override
    public String getDisplayName() {
        return "&dConvert Effects";
    }

    @Override
    public String getDescription() {
        return "&fConverts potion effects from one type to another";
    }

    @Override
    public String getActiveDescription() {
        PotionEffectWrapper effect = PotionEffectRegistry.getEffect(this.selectedTo);
        return "&fConverts " + this.selectedFrom + " to " + effect.getEffect().replace("_", " ") + " " + effect.getFormat().format(this.value + (double)(effect.isVanilla() ? 1 : 0)) + " &f(" + StringUtils.toTimeStamp(this.duration, 20L) + ")";
    }

    @Override
    public Collection<String> getCategories() {
        return Set.of(ModifierCategoryRegistry.POTION_MISC.id());
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setSelectedFrom(String selectedFrom) {
        this.selectedFrom = selectedFrom;
    }

    public void setSelectedTo(String selectedTo) {
        this.selectedTo = selectedTo;
    }

    @Override
    public DynamicItemModifier copy() {
        PotionEffectConvert m = new PotionEffectConvert(this.getName());
        m.setSelectedFrom(this.selectedFrom);
        m.setSelectedTo(this.selectedTo);
        m.setDuration(this.duration);
        m.setValue(this.value);
        m.setPriority(this.getPriority());
        m.conversions.putAll(this.conversions);
        return m;
    }

    @Override
    public String parseCommand(CommandSender executor, String[] args) {
        return "This modifier is too complex for commands, sorry!";
    }

    @Override
    public List<String> commandSuggestions(CommandSender executor, int currentArg) {
        return Command.noSubcommandArgs();
    }

    @Override
    public int commandArgsRequired() {
        return 1;
    }

    private static void populate() {
        types.clear();
        types.addAll(new ArrayList<String>(PotionEffectRegistry.getRegisteredEffects().values().stream().map(PotionEffectWrapper::getEffect).toList()));
        types.sort(Comparator.comparing(s -> PotionEffectRegistry.getRegisteredEffects().get(s).isVanilla()).thenComparing(s -> s));
    }

    private static class Effect {
        private String effect;
        private double amplifier;
        private long duration;

        public Effect(String effect, double amplifier, long duration) {
            this.effect = effect;
            this.amplifier = amplifier;
            this.duration = duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setAmplifier(double amplifier) {
            this.amplifier = amplifier;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }
    }
}

