/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;

public class ConfigurableMaterialsChoice
extends RecipeOption {
    private Collection<Material> validChoices = new HashSet<Material>();

    @Override
    public String getName() {
        return "CONFIGURABLE_MATERIAL_RANGE";
    }

    @Override
    public String getActiveDescription() {
        return "The ingredient can be any of " + String.join((CharSequence)", ", this.validChoices.stream().map(m -> StringUtils.toPascalCase(m.toString().replace("_", " "))).collect(Collectors.toSet()));
    }

    @Override
    public ItemStack getIcon() {
        ItemBuilder builder = new ItemBuilder(Material.WRITABLE_BOOK).name("&7Material Selection");
        if (this.validChoices.isEmpty()) {
            builder.appendLore("&4Not Configured");
        } else {
            builder.appendLore("&f" + String.valueOf(StringUtils.separateStringIntoLines(String.join((CharSequence)", ", this.validChoices.stream().map(m -> StringUtils.toPascalCase(m.toString().replace("_", " "))).collect(Collectors.toSet())), 40)));
        }
        builder.appendLore("&eLeft-click with item to add to list", "", "&cRight-click to clear the list", "", "&eClick without item to apply to ingredient.", "&aThe ingredient may then be substituted", "&awith any of the given materials.");
        return builder.get();
    }

    @Override
    public boolean isCompatible(ItemStack i) {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public RecipeOption getNew() {
        ConfigurableMaterialsChoice choice = new ConfigurableMaterialsChoice();
        choice.validChoices.addAll(new HashSet<Material>(this.validChoices));
        return choice;
    }

    @Override
    public boolean isCompatibleWithInputItem(boolean isInput) {
        return true;
    }

    @Override
    public RecipeChoice getChoice(ItemStack i) {
        return new RecipeChoice.MaterialChoice(this.validChoices.toArray(new Material[0]));
    }

    @Override
    public boolean matches(ItemStack i1, ItemStack i2) {
        return this.validChoices.contains(i2.getType());
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        if (e.isRightClick()) {
            this.validChoices.clear();
            PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()).addOption(this);
        } else if (this.validChoices.isEmpty() && ItemUtils.isEmpty(e.getCursor())) {
            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cThis option must be configured first!");
        } else if (!ItemUtils.isEmpty(e.getCursor())) {
            this.validChoices.add(e.getCursor().getType());
            PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()).addOption(this);
        } else {
            super.onClick(e);
        }
    }

    @Override
    public String ingredientDescription(ItemStack base) {
        return String.join((CharSequence)"/", this.validChoices.stream().map(m -> StringUtils.toPascalCase(m.toString().replace("_", " "))).collect(Collectors.toSet()));
    }

    public ConfigurableMaterialsChoice setValidChoices(Collection<Material> validChoices) {
        this.validChoices = validChoices;
        return this;
    }

    public Collection<Material> getValidChoices() {
        return this.validChoices;
    }
}

