/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations;

import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.hooks.NexoHook;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class NexoChoice
extends RecipeOption {
    @Override
    public String getName() {
        return "CHOICE_NEXO_ITEM";
    }

    @Override
    public String getActiveDescription() {
        return "This ingredient will need to match a specific Nexo item";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemBuilder(Material.KNOWLEDGE_BOOK).name("&7Nexo Item Requirement").lore("&aRequire this ingredient to be a specific", "&aNexo item, identified by its Nexo ID.", "", "&7The name of the ingredient will be", "&7used to communicate item requirement", "&7to the player.").get();
    }

    @Override
    public boolean isCompatible(ItemStack i) {
        if (!NexoHook.isHookFunctional()) {
            return false;
        }
        return NexoHook.getNexoId(i) != null;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public RecipeChoice getChoice(final ItemStack i) {
        return new RecipeChoice.ExactChoice(this, i){
            final /* synthetic */ NexoChoice this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public boolean test(@NotNull ItemStack itemStack) {
                if (!NexoHook.isHookFunctional()) {
                    return false;
                }
                String referenceNexoId = NexoHook.getNexoId(i);
                if (referenceNexoId == null) {
                    return false;
                }
                String testedNexoId = NexoHook.getNexoId(itemStack);
                return referenceNexoId.equals(testedNexoId);
            }
        };
    }

    @Override
    public boolean matches(ItemStack i1, ItemStack i2) {
        if (!NexoHook.isHookFunctional()) {
            return false;
        }
        String nexoId1 = NexoHook.getNexoId(i1);
        String nexoId2 = NexoHook.getNexoId(i2);
        if (nexoId1 == null && nexoId2 == null) {
            return false;
        }
        if (nexoId1 == null || nexoId2 == null) {
            return false;
        }
        return nexoId1.equals(nexoId2);
    }

    @Override
    public String ingredientDescription(ItemStack base) {
        if (!NexoHook.isHookFunctional()) {
            return ItemUtils.getItemName(new ItemBuilder(base));
        }
        ItemMeta meta = base.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        String nexoId = NexoHook.getNexoId(base);
        if (nexoId != null) {
            return "Nexo Item: " + nexoId;
        }
        return ItemUtils.getItemName(new ItemBuilder(base));
    }

    @Override
    public RecipeOption getNew() {
        return new NexoChoice();
    }

    @Override
    public boolean isCompatibleWithInputItem(boolean isInput) {
        return true;
    }
}

