/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.persistence.RecipePersistence;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaRecipe;

public class GridRecipePersistence
extends RecipePersistence {
    public GridRecipePersistence(Gson gson) {
        super(gson);
    }

    @Override
    public Map<String, ValhallaRecipe> getRecipesFromFile(File f) {
        HashMap<String, ValhallaRecipe> recipes = new HashMap<String, ValhallaRecipe>();
        if (f.exists()) {
            try (BufferedReader recipesReader = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));){
                DynamicGridRecipe[] collectedRecipes;
                for (DynamicGridRecipe recipe : collectedRecipes = (DynamicGridRecipe[])this.gson.fromJson((Reader)recipesReader, DynamicGridRecipe[].class)) {
                    if (recipe == null) continue;
                    recipes.put(recipe.getName(), recipe);
                }
            }
            catch (JsonSyntaxException | IOException exception) {
                ValhallaMMO.logSevere("Could not load recipes file " + f.getPath() + ", " + exception.getMessage());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        } else {
            ValhallaMMO.logWarning("File " + f.getPath() + " does not exist!");
        }
        return recipes;
    }

    @Override
    public void saveRecipesToFile(String fileName, Collection<? extends ValhallaRecipe> recipes) {
        if (!fileName.endsWith(".json")) {
            ValhallaMMO.logWarning("The selected file to save recipes to (" + fileName + ") is not a valid .json file!");
            return;
        }
        recipes = new ArrayList<ValhallaRecipe>(recipes.stream().filter(r -> r instanceof DynamicGridRecipe).toList());
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/" + fileName);
        if (!f.exists()) {
            ValhallaMMO.getInstance().saveResource(fileName, false);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(f, StandardCharsets.UTF_8));){
            JsonElement element = this.gson.toJsonTree(new ArrayList<ValhallaRecipe>(recipes), new TypeToken<ArrayList<DynamicGridRecipe>>(){}.getType());
            this.gson.toJson(element, (Appendable)writer);
            writer.flush();
        }
        catch (JsonSyntaxException | IOException exception) {
            ValhallaMMO.logSevere("Could not save grid recipes file " + fileName + ", " + exception.getMessage());
        }
    }
}

