/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.crafting.recipetypes;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.ToolRequirement;
import me.athlaeos.valhallammo.crafting.ToolRequirementType;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierContext;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ResultChangingModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaKeyedRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ValhallaRecipe;
import me.athlaeos.valhallammo.item.EquipmentClass;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DynamicGridRecipe
implements ValhallaRecipe,
ValhallaKeyedRecipe {
    private final NamespacedKey shapedKey;
    private final NamespacedKey shapelessKey;
    private final String name;
    private String displayName = null;
    private String description = null;
    private Map<Integer, SlotEntry> items = new HashMap<Integer, SlotEntry>();
    private ItemStack result = new ItemBuilder(Material.WOODEN_SWORD).name("&r&fReplace me!").lore("&7I'm just a placeholder item!").get();
    private boolean requireValhallaTools = false;
    private boolean tinker = false;
    private int tinkerGridIndex = -1;
    private int toolIndex = -1;
    private boolean shapeless = false;
    private boolean hiddenFromBook = false;
    private List<DynamicItemModifier> modifiers = new ArrayList<DynamicItemModifier>();
    private boolean unlockedForEveryone = false;
    private ToolRequirement toolRequirement = new ToolRequirement(ToolRequirementType.NOT_REQUIRED, -1);
    private Collection<String> validations = new HashSet<String>();

    public DynamicGridRecipe(String name) {
        this.name = name;
        this.shapedKey = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "gridrecipe_" + name + "_shaped");
        this.shapelessKey = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "gridrecipe_" + name + "_shapeless");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.shapedKey;
    }

    public NamespacedKey getKey2() {
        return this.shapelessKey;
    }

    @Override
    public void registerRecipe() {
        ShapedRecipe shaped = this.getShapedRecipe();
        ShapelessRecipe shapeless = this.getShapelessRecipe();
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.shapedKey) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.shapedKey);
        }
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.shapelessKey) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.shapelessKey);
        }
        if (shaped != null) {
            ValhallaMMO.getInstance().getServer().addRecipe((Recipe)shaped);
        } else {
            ValhallaMMO.logWarning("Could not generate recipe for " + this.getName() + ", it has no ingredients!");
        }
        if (shapeless != null) {
            ValhallaMMO.getInstance().getServer().addRecipe((Recipe)shapeless);
        }
    }

    @Override
    public void unregisterRecipe() {
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.shapedKey) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.shapedKey);
        }
        if (ValhallaMMO.getInstance().getServer().getRecipe(this.shapelessKey) != null) {
            ValhallaMMO.getInstance().getServer().removeRecipe(this.shapelessKey);
        }
    }

    public ToolRequirement getToolRequirement() {
        return this.toolRequirement;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public List<DynamicItemModifier> getModifiers() {
        return this.modifiers;
    }

    public Map<Integer, SlotEntry> getItems() {
        return this.items;
    }

    public int getTinkerGridIndex() {
        return this.tinkerGridIndex;
    }

    public int getToolIndex() {
        return this.toolIndex;
    }

    public boolean requireValhallaTools() {
        return this.requireValhallaTools;
    }

    public boolean isShapeless() {
        return this.shapeless;
    }

    @Override
    public boolean isUnlockedForEveryone() {
        return this.unlockedForEveryone;
    }

    public boolean tinker() {
        return this.tinker;
    }

    public Collection<String> getValidations() {
        return this.validations;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setHiddenFromBook(boolean hiddenFromBook) {
        this.hiddenFromBook = hiddenFromBook;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setToolRequirement(ToolRequirement toolRequirement) {
        this.toolRequirement = toolRequirement;
    }

    public void setUnlockedForEveryone(boolean unlockedForEveryone) {
        this.unlockedForEveryone = unlockedForEveryone;
    }

    public void setItems(Map<Integer, SlotEntry> items) {
        this.items = items;
    }

    public void setTinkerGridIndex(int tinkerGridIndex) {
        this.tinkerGridIndex = tinkerGridIndex;
    }

    public void setModifiers(List<DynamicItemModifier> modifiers) {
        this.modifiers = modifiers;
        DynamicItemModifier.sortModifiers(this.modifiers);
    }

    public void setRequireValhallaTools(boolean requireValhallaTools) {
        this.requireValhallaTools = requireValhallaTools;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public void setShapeless(boolean shapeless) {
        this.shapeless = shapeless;
    }

    public void setTinker(boolean tinker) {
        this.tinker = tinker;
    }

    public void setToolIndex(int toolIndex) {
        this.toolIndex = toolIndex;
    }

    public void setValidations(Collection<String> validations) {
        this.validations = validations;
    }

    @Override
    public boolean isHiddenFromBook() {
        return this.hiddenFromBook;
    }

    public ShapelessRecipe getShapelessRecipe() {
        if (!this.shapeless || this.items.isEmpty()) {
            return null;
        }
        ShapelessRecipe recipe = new ShapelessRecipe(this.shapelessKey, this.recipeBookIcon(this.tinker ? this.getGridTinkerEquipment().getItem() : this.result));
        for (Integer i : this.items.keySet()) {
            RecipeChoice choice;
            SlotEntry entry = this.items.get(i);
            ItemBuilder item = new ItemBuilder(entry.getItem());
            TranslationManager.translateItem(item);
            RecipeChoice recipeChoice = choice = entry.getOption() == null ? null : entry.getOption().getChoice(item.get());
            if (choice == null) {
                choice = new RecipeChoice.MaterialChoice(item.getItem().getType());
            }
            if (i == this.toolIndex) {
                choice = new RecipeChoice.MaterialChoice(ItemUtils.getNonAirMaterialsArray());
            }
            recipe.addIngredient(choice);
        }
        return recipe;
    }

    public ShapedRecipe getShapedRecipe() {
        if (this.items.isEmpty()) {
            return null;
        }
        ShapedRecipe recipe = new ShapedRecipe(this.shapedKey, this.recipeBookIcon(this.tinker ? this.getGridTinkerEquipment().getItem() : this.result));
        ShapeDetails details = this.getRecipeShapeStrings();
        recipe.shape(details.shape);
        for (char ci : details.items.keySet()) {
            RecipeChoice choice;
            SlotEntry entry = details.items.get(Character.valueOf(ci));
            ItemBuilder i = new ItemBuilder(entry.getItem());
            TranslationManager.translateItem(i);
            RecipeChoice recipeChoice = choice = entry.getOption() == null ? null : entry.getOption().getChoice(i.get());
            if (choice == null) {
                choice = new RecipeChoice.MaterialChoice(i.getItem().getType());
            }
            if (this.items.get(this.toolIndex) != null && this.items.get(this.toolIndex).equals(entry)) {
                choice = new RecipeChoice.MaterialChoice(ItemUtils.getNonAirMaterialsArray());
            }
            recipe.setIngredient(ci, choice);
        }
        return recipe;
    }

    private ItemStack recipeBookIcon(ItemStack i) {
        ResultChangingModifier changer = this.modifiers.stream().filter(m -> m instanceof ResultChangingModifier).reduce((first, second) -> second).orElse(null);
        if (changer != null) {
            i = Utils.thisorDefault(changer.getNewResult(ModifierContext.builder(new ItemBuilder(i)).get()), i);
        }
        ArrayList<String> gridDetails = new ArrayList<String>();
        if (this.shapeless) {
            String shapelessFormat = TranslationManager.getTranslation("ingredient_format_shapeless");
            Map<SlotEntry, Integer> contents = ItemUtils.getItemTotals(this.items.values());
            for (SlotEntry slotEntry : contents.keySet()) {
                int amount = contents.get(slotEntry);
                gridDetails.add(shapelessFormat.replace("%amount%", String.valueOf(amount)).replace("%ingredient%", TranslationManager.translatePlaceholders(SlotEntry.toString(slotEntry))));
            }
        } else {
            String shapeFormat = TranslationManager.getTranslation("ingredient_format_grid_shape");
            String charFormat = TranslationManager.getTranslation("ingredient_format_grid_ingredient");
            ShapeDetails details = this.getRecipeShapeStrings();
            for (String shapeLine : details.getShape()) {
                gridDetails.add(shapeFormat.replace("%characters%", shapeLine));
            }
            for (Character c : details.getItems().keySet()) {
                if (details.getItems().get(c) == null) continue;
                gridDetails.add(charFormat.replace("%character%", String.valueOf(c)).replace("%ingredient%", SlotEntry.toString(details.getItems().get(c))));
            }
        }
        SlotEntry tinkerItem = this.getGridTinkerEquipment();
        ItemBuilder result = new ItemBuilder(this.tinker ? (tinkerItem == null || ItemUtils.isEmpty(tinkerItem.getItem()) ? this.result : tinkerItem.getItem()) : this.result);
        List<String> def = TranslationManager.getListTranslation("default_recipe_description_grid");
        String string = TranslationManager.getTranslation("tinker_result_format");
        ArrayList<String> lore = new ArrayList<String>();
        for (String l : this.description == null ? def.toArray(new String[0]) : this.description.split("/n")) {
            lore.add(TranslationManager.translatePlaceholders(l.replace("%result%", this.tinker ? string.replace("%item%", SlotEntry.toString(this.getGridTinkerEquipment())) : ItemUtils.getItemName(result)).replace("%tinker%", this.tinker ? SlotEntry.toString(this.getGridTinkerEquipment()) : ItemUtils.getItemName(result))));
        }
        ItemBuilder icon = new ItemBuilder(i).lore(ItemUtils.setListPlaceholder(lore, "%ingredients%", gridDetails)).translate();
        if (this.displayName != null) {
            icon.name(TranslationManager.translatePlaceholders(this.displayName).replace("%item%", ItemUtils.getItemName(result)));
        } else if (this.tinker) {
            icon.name(string.replace("%item%", SlotEntry.toString(tinkerItem)));
        } else if (result.getMeta().hasDisplayName()) {
            icon.name(result.getMeta().getDisplayName());
        }
        return icon.translate().get();
    }

    public SlotEntry getGridTinkerEquipment() {
        if (this.tinkerGridIndex >= 0 && this.items.containsKey(this.tinkerGridIndex) && !ItemUtils.isEmpty(this.items.get(this.tinkerGridIndex).getItem())) {
            return this.items.get(this.tinkerGridIndex);
        }
        SlotEntry tinker = null;
        for (int i = 0; i < 9; ++i) {
            ItemStack matrixItem;
            SlotEntry entry = this.items.get(i);
            if (entry == null || ItemUtils.isEmpty(matrixItem = entry.getItem())) continue;
            if (tinker == null) {
                tinker = entry;
            }
            if (EquipmentClass.getMatchingClass(ItemUtils.getItemMeta(matrixItem)) == null) continue;
            return entry;
        }
        return tinker;
    }

    public ShapeDetails getRecipeShapeStrings() {
        List<String> shape = new ArrayList<String>();
        HashBiMap ingredientMap = HashBiMap.create();
        int i = 0;
        StringBuilder usedChars = new StringBuilder();
        for (int r = 0; r < 3; ++r) {
            StringBuilder row = new StringBuilder();
            for (int c = 0; c < 3; ++c) {
                Character itemChar;
                SlotEntry entry = this.items.get(i);
                ++i;
                if (entry == null) {
                    row.append(' ');
                    continue;
                }
                SlotEntry entry2 = ingredientMap.values().stream().filter(entry::isSimilar).findAny().orElse(null);
                Character c2 = itemChar = entry2 == null ? null : (Character)ingredientMap.inverse().get((Object)entry2);
                if (itemChar == null) {
                    itemChar = Character.valueOf(this.getItemChar(entry, usedChars.toString()));
                }
                row.append(itemChar);
                if (ingredientMap.containsValue((Object)entry)) continue;
                usedChars.append(itemChar);
                ingredientMap.put((Object)itemChar, (Object)entry);
            }
            shape.add(row.toString());
        }
        shape = DynamicGridRecipe.trimShape(shape);
        return new ShapeDetails(shape.toArray(new String[0]), (Map<Character, SlotEntry>)ingredientMap);
    }

    public static List<String> trimShape(List<String> shape) {
        if (shape.get(0).equalsIgnoreCase("   ") && shape.get(1).equalsIgnoreCase("   ")) {
            shape.remove(0);
            shape.remove(0);
        } else if (shape.get(0).equalsIgnoreCase("   ")) {
            shape.remove(0);
        }
        if (shape.size() == 3 && shape.get(shape.size() - 1).equalsIgnoreCase("   ") && shape.get(shape.size() - 2).equalsIgnoreCase("   ")) {
            shape.remove(shape.size() - 1);
            shape.remove(shape.size() - 1);
        } else if (shape.get(shape.size() - 1).equalsIgnoreCase("   ")) {
            shape.remove(shape.size() - 1);
        }
        if (shape.stream().allMatch(s -> s.endsWith("  "))) {
            shape = shape.stream().map(s -> s.substring(0, s.length() - 2)).collect(Collectors.toList());
        }
        if (shape.stream().allMatch(s -> s.endsWith(" "))) {
            shape = shape.stream().map(s -> s.substring(0, s.length() - 1)).collect(Collectors.toList());
        }
        if (shape.stream().allMatch(s -> s.startsWith("  "))) {
            shape = shape.stream().map(s -> s.substring(2)).collect(Collectors.toList());
        }
        if (shape.stream().allMatch(s -> s.startsWith(" "))) {
            shape = shape.stream().map(s -> s.substring(1)).collect(Collectors.toList());
        }
        return shape;
    }

    private char getItemChar(SlotEntry i, String usedChars) {
        if (i == null) {
            return ' ';
        }
        if (ItemUtils.isEmpty(i.getItem())) {
            return ' ';
        }
        String itemName = ChatColor.stripColor((String)Utils.chat(TranslationManager.translatePlaceholders(SlotEntry.toString(i))));
        char possibleCharacter = (itemName.isEmpty() ? i.getItem().getType().toString() : itemName).toUpperCase(Locale.US).charAt(0);
        if (usedChars.contains(String.valueOf(possibleCharacter)) && usedChars.contains(String.valueOf(possibleCharacter = i.getItem().getType().toString().toUpperCase(Locale.US).charAt(0)))) {
            for (Character c : Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'))) {
                if (usedChars.contains(String.valueOf(c))) continue;
                return c.charValue();
            }
        }
        return possibleCharacter;
    }

    public static class ShapeDetails {
        String[] shape;
        Map<Character, SlotEntry> items;

        public ShapeDetails(String[] shape, Map<Character, SlotEntry> items) {
            this.shape = shape;
            this.items = items;
        }

        public String[] getShape() {
            return this.shape;
        }

        public Map<Character, SlotEntry> getItems() {
            return this.items;
        }
    }
}

