/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.dom;

import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.event.PlayerEnterCombatEvent;
import me.athlaeos.valhallammo.event.PlayerLeaveCombatEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CombatLog {
    private static final int combatDuration = ValhallaMMO.getPluginConfig().getInt("combat_time_frame");
    private final Player who;
    private long timeLastStartedCombat = 0L;
    private long timeLastCombatAction = 0L;
    private boolean isInCombat = false;
    private long timeInCombat = 0L;

    public CombatLog(Player who) {
        this.who = who;
    }

    public void combatAction() {
        if (this.timeLastCombatAction + 10000L < System.currentTimeMillis()) {
            PlayerEnterCombatEvent event = new PlayerEnterCombatEvent(this.who);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.timeLastStartedCombat = event.getWhen();
                this.timeLastCombatAction = event.getWhen();
                this.timeInCombat = 0L;
                this.isInCombat = true;
            }
        } else {
            this.timeInCombat += System.currentTimeMillis() - this.timeLastCombatAction;
            this.timeLastCombatAction = System.currentTimeMillis();
        }
    }

    public void checkPlayerLeftCombat() {
        if (this.isInCombat && this.timeLastCombatAction + (long)combatDuration < System.currentTimeMillis()) {
            PlayerLeaveCombatEvent event = new PlayerLeaveCombatEvent(this.who, this.timeLastStartedCombat, this.timeLastCombatAction + (long)combatDuration);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.isInCombat = false;
                this.timeInCombat = event.getTimeInCombat(this.timeLastStartedCombat);
            }
        }
    }

    public boolean isInCombat() {
        return this.isInCombat;
    }

    public long getTimeInCombat() {
        return this.timeInCombat;
    }

    public long getTimeLastCombatAction() {
        return this.timeLastCombatAction;
    }

    public long getTimeLastStartedCombat() {
        return this.timeLastStartedCombat;
    }
}

