/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.dom;

import me.athlaeos.valhallammo.ValhallaMMO;

public enum MinecraftVersion {
    MINECRAFT_1_26(19.0f, "1_26", "1.26", null),
    MINECRAFT_1_25(18.0f, "1_25", "1.25", null),
    MINECRAFT_1_24(17.0f, "1_24", "1.24", null),
    MINECRAFT_1_23(16.0f, "1_23", "1.23", null),
    MINECRAFT_1_22_3(15.3f, "1_22_3", "1.22.3", null),
    MINECRAFT_1_22_2(15.2f, "1_22_2", "1.22.2", null),
    MINECRAFT_1_22_1(15.1f, "1_22_1", "1.22.1", null),
    MINECRAFT_1_22(15.0f, "1_22", "1.22", null),
    MINECRAFT_1_21_10(14.91f, "1_21_10", "1.21.10", "v1_21_R6", "v1_21_R5"),
    MINECRAFT_1_21_9(14.9f, "1_21_9", "1.21.9", "v1_21_R6", "v1_21_R5"),
    MINECRAFT_1_21_8(14.8f, "1_21_8", "1.21.8", "v1_21_R5"),
    MINECRAFT_1_21_7(14.7f, "1_21_7", "1.21.7", "v1_21_R5"),
    MINECRAFT_1_21_6(14.6f, "1_21_6", "1.21.6", "v1_21_R5"),
    MINECRAFT_1_21_5(14.5f, "1_21_5", "1.21.5", "v1_21_R4"),
    MINECRAFT_1_21_4(14.4f, "1_21_4", "1.21.4", "v1_21_R3"),
    MINECRAFT_1_21_3(14.3f, "1_21_3", "1.21.3", "v1_21_R2"),
    MINECRAFT_1_21_2(14.2f, "1_21_2", "1.21.2", "v1_21_R1"),
    MINECRAFT_1_21_1(14.1f, "1_21_1", "1.21.1", "v1_21_R1"),
    MINECRAFT_1_21(14.0f, "1_21", "1.21", "v1_21_R1"),
    MINECRAFT_1_20_6(13.6f, "1_20_6", "1.20.6", "v1_20_R4"),
    MINECRAFT_1_20_5(13.5f, "1_20_5", "1.20.5", "v1_20_R4"),
    MINECRAFT_1_20_4(13.4f, "1_20_4", "1.20.4", "v1_20_R3"),
    MINECRAFT_1_20_3(13.3f, "1_20_3", "1.20.3", "v1_20_R3"),
    MINECRAFT_1_20_2(13.2f, "1_20_2", "1.20.2", "v1_20_R2"),
    MINECRAFT_1_20_1(13.1f, "1_20_1", "1.20.1", "v1_20_R1"),
    MINECRAFT_1_20(13.0f, "1_20", "1.20", "v1_20_R1"),
    MINECRAFT_1_19_4(12.4f, "1_19_4", "1.19.4", "v1_19_R3"),
    MINECRAFT_1_19_3(12.3f, "1_19_3", "1.19.3", "v1_19_R2"),
    MINECRAFT_1_19_2(12.2f, "1_19_2", "1.19.2", "v1_19_R1"),
    MINECRAFT_1_19_1(12.1f, "1_19_1", "1.19.1", "v1_19_R1"),
    MINECRAFT_1_19(12.0f, "1_19", "1.19", "v1_19_R1"),
    MINECRAFT_1_18(11.0f, "1_18", "1.18", null),
    MINECRAFT_1_17(10.0f, "1_17", "1.17", null),
    MINECRAFT_1_16(9.0f, "1_16", "1.16", null),
    MINECRAFT_1_15(8.0f, "1_15", "1.15", null),
    MINECRAFT_1_14(7.0f, "1_14", "1.14", null),
    MINECRAFT_1_13(6.0f, "1_13", "1.13", null),
    MINECRAFT_1_12(5.0f, "1_12", "1.12", null),
    MINECRAFT_1_11(4.0f, "1_11", "1.11", null),
    MINECRAFT_1_10(3.0f, "1_10", "1.10", null),
    MINECRAFT_1_9(2.0f, "1_9", "1.9", null),
    MINECRAFT_1_8(1.0f, "1_8", "1.8", null),
    INCOMPATIBLE(-1.0f, null, null, null);

    private final float v;
    private final String versionString1;
    private final String versionString2;
    private final String nmsVersion;
    private final String paperVersion;
    private static final MinecraftVersion serverVersion;

    private static MinecraftVersion init() {
        String v = ValhallaMMO.getInstance().getServer().getVersion();
        for (MinecraftVersion version : MinecraftVersion.values()) {
            if (version.versionString1 == null || version.versionString2 == null || !v.contains(version.versionString1) && !v.contains(version.versionString2)) continue;
            return version;
        }
        return INCOMPATIBLE;
    }

    private MinecraftVersion(float v, String v1, String v2, String nmsVersion) {
        this.v = v;
        this.versionString1 = v1;
        this.versionString2 = v2;
        this.nmsVersion = nmsVersion;
        this.paperVersion = nmsVersion;
    }

    private MinecraftVersion(float v, String v1, String v2, String nmsVersion, String paperVersion) {
        this.v = v;
        this.versionString1 = v1;
        this.versionString2 = v2;
        this.nmsVersion = nmsVersion;
        this.paperVersion = paperVersion;
    }

    public String getVersionString() {
        return this.versionString1;
    }

    public static boolean currentVersionOlderThan(MinecraftVersion version) {
        if (serverVersion == INCOMPATIBLE) {
            return false;
        }
        return MinecraftVersion.serverVersion.v <= version.v;
    }

    public String getNmsVersion() {
        return this.nmsVersion;
    }

    public String getPaperVersion() {
        return this.paperVersion;
    }

    public static boolean currentVersionNewerThan(MinecraftVersion version) {
        if (serverVersion == INCOMPATIBLE) {
            return false;
        }
        return MinecraftVersion.serverVersion.v >= version.v;
    }

    public static MinecraftVersion getServerVersion() {
        return serverVersion;
    }

    static {
        serverVersion = MinecraftVersion.init();
    }
}

