/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.event;

import me.athlaeos.valhallammo.ValhallaMMO;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerJumpEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private static final PlayerJumpEventListener listener = new PlayerJumpEventListener();
    private final Player player;

    public PlayerJumpEvent(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static void register(ValhallaMMO plugin) {
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)plugin);
    }

    private static class PlayerJumpEventListener
    implements Listener {
        private PlayerJumpEventListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onStatisticJump(EntityExhaustionEvent e) {
            HumanEntity humanEntity;
            if (!e.getExhaustionReason().toString().contains("JUMP") || !((humanEntity = e.getEntity()) instanceof Player)) {
                return;
            }
            Player p = (Player)humanEntity;
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerJumpEvent(p));
        }
    }
}

