/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.MetaRequirement;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCauldronRecipe;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetIngredientsMenu;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.SetRecipeOptionMenu;
import me.athlaeos.valhallammo.gui.SetValidationsMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.IngredientSelectionMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.ValidationSelectionMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class CauldronRecipeEditor
extends Menu
implements SetModifiersMenu,
SetRecipeOptionMenu,
SetIngredientsMenu,
SetValidationsMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final int catalystIndex = 20;
    private static final int resultIndex = 24;
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final DynamicCauldronRecipe recipe;
    private Map<ItemStack, Integer> ingredients;
    private SlotEntry catalyst;
    private ItemStack result;
    private List<DynamicItemModifier> modifiers;
    private boolean timedRecipe;
    private int cookTime;
    private MetaRequirement metaRequirement;
    private boolean tinker;
    private boolean requireValhallaTools;
    private boolean unlockedForEveryone;
    private Collection<String> validations;
    private String displayName;
    private String description;
    private static final ItemStack toggleValhallaToolRequirementButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_valhallatoolrequirement", Material.DIAMOND_PICKAXE)).name("&eValhalla Tools").stringTag(BUTTON_ACTION_KEY, "toggleValhallaToolRequirementButton").lore("&7If enabled, armors and tools used", "&7as catalyst will need to possess ", "&7custom attributes. If disabled, vanilla ", "&7equipment can be used too.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleTinkerButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_toggletinker", Material.ANVIL)).name("&eTinker Catalyst").stringTag(BUTTON_ACTION_KEY, "toggleTinkerButton").lore("&7If enabled, the recipe will", "&7modify the catalyst item.", "&7Otherwise, it will simply produce the", "&7item specified as the result.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleTimedRecipeButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_toggletimedrecipe", Material.BREWING_STAND)).name("&fTimed Recipe").stringTag(BUTTON_ACTION_KEY, "toggleTimedRecipeButton").lore("&7If enabled, the cauldron will", "&7instead of requiring a catalyst", "&7to produce a recipe require the", "&7ingredients to be in the cauldron", "&7for a specified duration", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack metaRequirementButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_toggleexactmeta", Material.PAPER)).name("&dMeta Requirement").stringTag(BUTTON_ACTION_KEY, "metaRequirementButton").lore("&7Determines the manner in which ", "&7ingredients will need to match player", "&7items.", "&eClick to select next option", "&8&m                <>                ").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack selectValidationButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_selectvalidation", Material.BARRIER)).name("&eBlock condition").stringTag(BUTTON_ACTION_KEY, "selectValidationButton").lore("&7Block conditions are checks", "&7to allow/disallow recipes based on", "&7block environment.", "&7These conditions may also change", "&7the environment after crafting.", "&eClick to open the menu", "&8&m                <>                ", "%description%").get();
    private static final ItemStack cookTimeButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_cooktime", Material.CLOCK)).name("&eCooking Time").stringTag(BUTTON_ACTION_KEY, "cookTimeButton").lore("&7How long it takes to produce the result.", "&71 second is equal to 20 ticks", "&eClick to increase/decrease by 10 ticks", "&eShift-click to increase/decrease by 200 ticks").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack ingredientsButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_ingredients", Material.WRITABLE_BOOK)).name("&7Ingredients").stringTag(BUTTON_ACTION_KEY, "ingredientsButton").lore("&7The cauldron must have all the listed", "&7ingredients stored within it to", "&7craft this recipe.", "&eClick to open the menu and insert your", "&eingredients there.", "&8&m                <>                ", "%ingredients%").get();
    private static final ItemStack modifierButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_modifiers", Material.WRITABLE_BOOK)).name("&dDynamic Item Modifiers").stringTag(BUTTON_ACTION_KEY, "modifierButton").lore("&7Modifiers are functions to edit", "&7the output item based on player", "&7stats or to apply crafting conditions.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack recipeOptionsButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_recipeoptions", Material.WRITABLE_BOOK)).name("&bIngredient Options").stringTag(BUTTON_ACTION_KEY, "recipeOptionsButton").lore("&7Ingredient options are ingredient", "&7flags you can put on an ingredient", "&7to change its behavior during crafting.", "&eClick to open the menu").get();
    private static final ItemStack toggleUnlockedForEveryoneButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_unlockedforeveryone", Material.PAPER)).name("&eUnlocked for Everyone").stringTag(BUTTON_ACTION_KEY, "toggleUnlockedForEveryoneButton").lore("&7If enabled, the recipe will", "&7available to everyone regardless", "&7if unlocked or not. Otherwise it", "&7will have to be unlocked through", "&7perk rewards.", "&eClick to toggle on/off").get();
    private static final ItemStack setDisplayNameButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_setdisplayname", Material.NAME_TAG)).name("&aSet Display Name").stringTag(BUTTON_ACTION_KEY, "setDisplayNameButton").lore("&7Sets the display name of the recipe.", "&7The display name is visible in the", "&7recipe book and is usually used", "&7to roughly describe the purpose of", "&7tinkering recipes since the output is", "&7non-descriptive.", "&eLeft-Click to set display name", "&cRight-Click to nullify display name", "&7A nullified display name defaults to", "&7the name of the input/output", "&8&m                <>                ", "&7Currently set to: %display_name%").get();
    private static final ItemStack setDescriptionButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_recipe_cauldron_setdescription", Material.WRITABLE_BOOK)).name("&aSet Description").stringTag(BUTTON_ACTION_KEY, "setDescriptionButton").lore("&7Sets the description of the recipe.", "&7The description is visible in the", "&7recipe book as lore.", "&eLeft-Click to set description", "&cRight-Click to nullify description", "&7A nullified description defaults to", "&7a default default recipe format in", "&7the language file.", "&8&m                <>                ", "&7Currently set to: %description%").get();
    private static final ItemStack confirmButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_save", Material.STRUCTURE_VOID)).name("&aConfirm").stringTag(BUTTON_ACTION_KEY, "confirmButton").lore("&aRight-click &7to save changes").get();
    private boolean confirmDeletion = false;
    private static final ItemStack deleteButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
    private static final ItemStack backToMenuButton = new ItemBuilder(CauldronRecipeEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();

    public CauldronRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicCauldronRecipe recipe) {
        super(playerMenuUtility);
        IngredientChoice ingredientChoice;
        this.recipe = recipe;
        this.ingredients = recipe.getIngredients();
        this.catalyst = recipe.getCatalyst();
        IngredientChoice ingredientChoice2 = this.catalyst.getOption();
        if (ingredientChoice2 instanceof RecipeOption) {
            RecipeOption o = (RecipeOption)ingredientChoice2;
            ingredientChoice = o.getNew();
        } else {
            ingredientChoice = this.catalyst.getOption();
        }
        this.catalyst.setOption(ingredientChoice);
        this.result = recipe.getResult();
        this.modifiers = recipe.getModifiers();
        this.requireValhallaTools = recipe.requiresValhallaTools();
        this.tinker = recipe.tinkerCatalyst();
        this.timedRecipe = recipe.isTimedRecipe();
        this.cookTime = recipe.getCookTime();
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.metaRequirement = recipe.getMetaRequirement();
        this.validations = recipe.getValidations();
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
    }

    public CauldronRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicCauldronRecipe recipe, String newName) {
        super(playerMenuUtility);
        this.recipe = new DynamicCauldronRecipe(newName);
        this.ingredients = new HashMap<ItemStack, Integer>(recipe.getIngredients());
        this.catalyst = new SlotEntry(recipe.getCatalyst().getItem().clone(), recipe.getCatalyst().getOption());
        this.result = recipe.getResult().clone();
        this.modifiers = new ArrayList<DynamicItemModifier>(recipe.getModifiers().stream().map(DynamicItemModifier::copy).toList());
        this.requireValhallaTools = recipe.requiresValhallaTools();
        this.tinker = recipe.tinkerCatalyst();
        this.timedRecipe = recipe.isTimedRecipe();
        this.cookTime = recipe.getCookTime();
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.metaRequirement = recipe.getMetaRequirement();
        this.validations = new HashSet<String>(recipe.getValidations());
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf206\uf80c\uf80a\uf808\uf802&8%recipe%" : TranslationManager.getTranslation("editormenu_cauldronrecipes")).replace("%recipe%", this.recipe.getName());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        ItemStack cursor = e.getCursor();
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.CAULDRON.getId()).open();
                    return;
                }
                case "modifierButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "ingredientsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new IngredientSelectionMenu(this.playerMenuUtility, this, ConfigManager.getConfig("config.yml").get().getInt("cauldron_max_capacity", 3)).open();
                    return;
                }
                case "recipeOptionsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new RecipeOptionMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this recipe?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    CustomRecipeRegistry.unregister(this.recipe.getName());
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.CAULDRON.getId()).open();
                    return;
                }
                case "setDisplayNameButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the display name be? (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        CauldronRecipeEditor.this.displayName = answer;
                                    }
                                    CauldronRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionaire);
                        break;
                    }
                    this.displayName = null;
                    break;
                }
                case "setDescriptionButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the description be? Use '/n' to separate lines. (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        CauldronRecipeEditor.this.description = answer;
                                    }
                                    CauldronRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&aValid placeholders are:");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%ingredients% &afor the ingredients");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%catalyst% &afor the catalyst item");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%result% &afor a preformatted result");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%tinker% &afor the raw name of the tinkered result");
                        break;
                    }
                    this.description = null;
                    break;
                }
                case "confirmButton": {
                    if (ItemUtils.isEmpty(this.result) || this.catalyst == null || ItemUtils.isEmpty(this.catalyst.getItem())) {
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cPlease add a result!");
                        this.setMenuItems();
                        return;
                    }
                    this.recipe.setIngredients(this.ingredients);
                    this.recipe.setCatalyst(this.catalyst);
                    this.recipe.setResult(this.result);
                    this.recipe.setModifiers(this.modifiers);
                    this.recipe.setRequiresValhallaTools(this.requireValhallaTools);
                    this.recipe.setTinkerCatalyst(this.tinker);
                    this.recipe.setTimedRecipe(this.timedRecipe);
                    this.recipe.setCookTime(this.cookTime);
                    this.recipe.setUnlockedForEveryone(this.unlockedForEveryone);
                    this.recipe.setMetaRequirement(this.metaRequirement);
                    this.recipe.setValidations(this.validations);
                    this.recipe.setDescription(this.description);
                    this.recipe.setDisplayName(this.displayName);
                    CustomRecipeRegistry.register(this.recipe, true);
                    CustomRecipeRegistry.setChangesMade();
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.CAULDRON.getId()).open();
                    return;
                }
                case "selectValidationButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new ValidationSelectionMenu(this.playerMenuUtility, this, Material.CAULDRON).open();
                    return;
                }
                case "toggleValhallaToolRequirementButton": {
                    this.requireValhallaTools = !this.requireValhallaTools;
                    break;
                }
                case "toggleTinkerButton": {
                    this.tinker = !this.tinker;
                    break;
                }
                case "cookTimeButton": {
                    this.cookTime = Math.max(0, this.cookTime + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 200 : 10));
                    break;
                }
                case "toggleTimedRecipeButton": {
                    this.timedRecipe = !this.timedRecipe;
                    break;
                }
                case "metaRequirementButton": {
                    int currentRequirement = Arrays.asList(MetaRequirement.values()).indexOf((Object)this.metaRequirement);
                    currentRequirement = e.isLeftClick() ? (currentRequirement + 1 >= MetaRequirement.values().length ? 0 : ++currentRequirement) : (currentRequirement - 1 < 0 ? MetaRequirement.values().length - 1 : --currentRequirement);
                    this.metaRequirement = MetaRequirement.values()[currentRequirement];
                    break;
                }
                case "toggleUnlockedForEveryoneButton": {
                    boolean bl = this.unlockedForEveryone = !this.unlockedForEveryone;
                }
            }
        }
        if (24 == e.getRawSlot()) {
            if (!this.tinker && !ItemUtils.isEmpty(cursor)) {
                this.result = cursor.clone();
            }
        } else if (20 == e.getRawSlot()) {
            this.catalyst = !ItemUtils.isEmpty(cursor) ? new SlotEntry(new ItemBuilder(cursor.clone()).get(), new MaterialChoice()) : new SlotEntry(new ItemBuilder(this.catalyst.getItem()).get(), new MaterialChoice());
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        this.inventory.setItem(24, null);
        if (!this.tinker || this.timedRecipe) {
            this.inventory.setItem(24, this.result.clone());
        } else {
            this.inventory.setItem(24, new ItemBuilder(this.catalyst.getItem()).name("&dTinkered Catalyst").get());
        }
        if (!this.timedRecipe) {
            this.inventory.setItem(20, new ItemBuilder(this.catalyst.getItem()).name("&f" + SlotEntry.toString(this.catalyst)).lore(SlotEntry.getOptionLore(this.catalyst)).get());
        } else {
            this.inventory.setItem(20, new ItemBuilder(cookTimeButton).name(String.format("&fTime to cook: &e%d, %ss", this.cookTime, StringUtils.toTimeStamp2(this.cookTime, 20L))).get());
        }
        ArrayList<String> modifierLore = new ArrayList<String>();
        this.modifiers.forEach(m -> modifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        ArrayList<String> validationLore = new ArrayList<String>();
        if (!this.validations.isEmpty()) {
            for (String v : this.validations) {
                Validation validation = ValidationRegistry.getValidation(v);
                validationLore.add(validation.activeDescription());
            }
        } else {
            validationLore.add("&aNo special conditions required");
        }
        ArrayList<String> lore = new ArrayList<String>();
        String format = TranslationManager.getTranslation("ingredient_format_shapeless");
        if (!this.ingredients.isEmpty()) {
            for (ItemStack entry : this.ingredients.keySet()) {
                int amount = this.ingredients.get(entry);
                lore.add(format.replace("%amount%", String.valueOf(amount)).replace("%ingredient%", this.metaRequirement.getChoice().ingredientDescription(entry)));
            }
        } else {
            lore.add("&eReaction occurs for free");
        }
        ItemBuilder resultMeta = new ItemBuilder(this.result);
        String tinkerFormat = TranslationManager.getTranslation("tinker_result_format");
        List<String> description = ItemUtils.setListPlaceholder(Arrays.asList(this.description == null ? "&eDefault".split("/n") : this.description.replace("%catalyst%", SlotEntry.toString(this.catalyst)).replace("%tinker%", this.tinker ? SlotEntry.toString(this.catalyst) : ItemUtils.getItemName(resultMeta)).replace("%result%", this.tinker ? tinkerFormat.replace("%item%", SlotEntry.toString(this.catalyst)) : ItemUtils.getItemName(resultMeta)).split("/n")), "%ingredients%", lore);
        this.inventory.setItem(0, new ItemBuilder(setDisplayNameButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDisplayNameButton), "%display_name%", List.of(this.displayName == null ? "&eDefault" : this.displayName))).get());
        this.inventory.setItem(1, new ItemBuilder(setDescriptionButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDescriptionButton), "%description%", description)).get());
        this.inventory.setItem(5, new ItemBuilder(toggleUnlockedForEveryoneButton).name("&eUnlocked for Everyone " + (this.unlockedForEveryone ? "&aYes" : "&fNo")).get());
        if (!this.timedRecipe) {
            this.inventory.setItem(11, recipeOptionsButton);
        }
        if (!this.timedRecipe) {
            this.inventory.setItem(17, new ItemBuilder(toggleValhallaToolRequirementButton).name("&eValhalla Tools: " + (this.requireValhallaTools ? "&aYes" : "&fNo")).get());
        }
        this.inventory.setItem(22, new ItemBuilder(ingredientsButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(ingredientsButton), "%ingredients%", lore)).get());
        this.inventory.setItem(25, new ItemBuilder(modifierButton).lore(modifierLore).get());
        this.inventory.setItem(31, new ItemBuilder(metaRequirementButton).name("&fMeta Requirement: &e" + String.valueOf((Object)this.metaRequirement)).appendLore(this.metaRequirement.getDescription()).get());
        if (!this.timedRecipe) {
            this.inventory.setItem(35, new ItemBuilder(toggleTinkerButton).name("&eTinker: " + (this.tinker ? "&aYes" : "&fNo")).get());
        }
        this.inventory.setItem(39, new ItemBuilder(selectValidationButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(selectValidationButton), "%description%", validationLore)).get());
        this.inventory.setItem(41, new ItemBuilder(toggleTimedRecipeButton).name("&eTimed Recipe: " + (this.timedRecipe ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, confirmButton);
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        this.modifiers = resultModifiers;
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        return this.modifiers;
    }

    @Override
    public void setRecipeOption(RecipeOption option) {
        if (option == null) {
            return;
        }
        if (!option.isCompatible(this.catalyst.getItem()) || !option.isCompatibleWithInputItem(true)) {
            Utils.sendMessage((CommandSender)this.playerMenuUtility.getOwner(), "&cNot compatible with this item");
        } else {
            this.catalyst.setOption(option);
        }
    }

    @Override
    public void setIngredients(Map<ItemStack, Integer> ingredients) {
        this.ingredients = ingredients;
    }

    @Override
    public Map<ItemStack, Integer> getIngredients() {
        return this.ingredients;
    }

    @Override
    public void setValidations(Collection<String> validations) {
        this.validations = validations;
    }

    @Override
    public Collection<String> getValidations() {
        return this.validations;
    }
}

