/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.commands.valhallasubcommands.ExportCommand;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.item.CustomItem;
import me.athlaeos.valhallammo.item.CustomItemRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class CustomItemManagementMenu
extends Menu
implements SetModifiersMenu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    private static final NamespacedKey BUTTON_DATA = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_data");
    private static final ItemStack createNewButton = new ItemBuilder(CustomItemManagementMenu.getButtonData("editor_newrecipe", Material.LIME_DYE)).name("&b&lNew").lore("&fClick with item to register it").stringTag(KEY_ACTION, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack nextPageButton = new ItemBuilder(CustomItemManagementMenu.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(KEY_ACTION, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButton = new ItemBuilder(CustomItemManagementMenu.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(KEY_ACTION, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private int page = 0;
    private String deleteConfirm = null;
    private String reApplyConfirm = null;
    private CustomItem currentItem = null;

    public CustomItemManagementMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf31b\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_customitems"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        ItemStack cursor = e.getCursor();
        if (!ItemUtils.isEmpty(cursor)) {
            cursor = cursor.clone();
        }
        if (!StringUtils.isEmpty(action)) {
            this.deleteConfirm = null;
            this.reApplyConfirm = null;
            switch (action) {
                case "createNewButton": {
                    if (ItemUtils.isEmpty(e.getCursor())) {
                        return;
                    }
                    final ItemStack finalCursor = e.getCursor().clone();
                    this.playerMenuUtility.setPreviousMenu(this);
                    e.getWhoClicked().closeInventory();
                    Questionnaire questionnaire = new Questionnaire(this, (Player)e.getWhoClicked(), null, null, new Question[]{new Question("&fWhat should the item's id be? (type in chat, or 'cancel' to cancel)", s -> !CustomItemRegistry.getItems().containsKey(s), "&cItem with this id already exists! Try again")}){
                        final /* synthetic */ CustomItemManagementMenu this$0;
                        {
                            this.this$0 = this$0;
                            super(who, onStart, onFinish, questions);
                        }

                        @Override
                        public Action<Player> getOnFinish() {
                            if (this.getQuestions().isEmpty()) {
                                return super.getOnFinish();
                            }
                            Question question = this.getQuestions().get(0);
                            if (question.getAnswer() == null) {
                                return super.getOnFinish();
                            }
                            return p -> {
                                String answer = question.getAnswer().replaceAll(" ", "_").toLowerCase(Locale.US);
                                if (answer.contains("cancel")) {
                                    this.this$0.playerMenuUtility.getPreviousMenu().open();
                                } else if (CustomItemRegistry.getItems().containsKey(answer)) {
                                    Utils.sendMessage((CommandSender)this.getWho(), "&cItem id already exists!");
                                    this.this$0.playerMenuUtility.getPreviousMenu().open();
                                } else {
                                    CustomItemRegistry.register(answer, finalCursor);
                                    this.this$0.playerMenuUtility.getPreviousMenu().open();
                                }
                            };
                        }
                    };
                    Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                    return;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                }
            }
            this.setMenuItems();
            return;
        }
        String storedValue = ItemUtils.getPDCString(BUTTON_DATA, clickedItem, null);
        if (StringUtils.isEmpty(storedValue)) {
            return;
        }
        CustomItem clicked = CustomItemRegistry.getItem(storedValue);
        if (clicked != null) {
            if (e.getClick() == ClickType.MIDDLE) {
                if (ExportCommand.prepareOrUnprepareItem(storedValue)) {
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&aPrepared " + storedValue + " for export");
                } else {
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cRemoved " + storedValue + " from export");
                }
            } else if (e.isLeftClick()) {
                this.currentItem = clicked;
                if (!e.isShiftClick()) {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this).open();
                    return;
                }
                e.getWhoClicked().getInventory().addItem(new ItemStack[]{CustomItemRegistry.getProcessedItem(storedValue, (Player)e.getWhoClicked())});
            } else if (ItemUtils.isEmpty(cursor)) {
                this.reApplyConfirm = null;
                if (this.deleteConfirm != null && this.deleteConfirm.equals(storedValue) && e.isRightClick()) {
                    CustomItemRegistry.getItems().remove(storedValue);
                    e.getWhoClicked().sendMessage(Utils.chat("&aItem removed!"));
                } else {
                    this.deleteConfirm = storedValue;
                }
            } else {
                this.deleteConfirm = null;
                if (this.reApplyConfirm != null && this.reApplyConfirm.equals(storedValue)) {
                    CustomItem item = CustomItemRegistry.getItem(storedValue);
                    if (item != null) {
                        item.setItem(cursor.clone());
                        e.getWhoClicked().sendMessage(Utils.chat("&aItem replaced!"));
                    } else {
                        e.getWhoClicked().sendMessage(Utils.chat("&cItem no longer exists"));
                    }
                } else {
                    this.reApplyConfirm = storedValue;
                }
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        ArrayList<ItemStack> buttons = new ArrayList<ItemStack>();
        ArrayList<String> itemIDs = new ArrayList<String>(CustomItemRegistry.getItems().keySet());
        itemIDs.sort(Comparator.comparing(s -> s));
        for (String item : itemIDs) {
            String[] stringArray;
            ItemBuilder itemBuilder = new ItemBuilder(CustomItemRegistry.getItem(item).getItem()).name("&f" + item).lore("&fClick to edit its modifiers", "&fShift-Click to get a copy", "&cRight-Click with nothing to delete", "&cRight-Click with item to overwrite");
            if (ExportCommand.isPrepared(item)) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "&aPrepared for export";
                stringArray = stringArray2;
                stringArray2[1] = "";
            } else {
                stringArray = new String[]{};
            }
            ItemBuilder icon = itemBuilder.prependLore(stringArray).stringTag(BUTTON_DATA, item);
            if (this.deleteConfirm != null && this.deleteConfirm.equals(item)) {
                icon.prependLore("&cRight-Click to confirm deletion");
            }
            if (this.reApplyConfirm != null && this.reApplyConfirm.equals(item)) {
                icon.prependLore("&cRight-Click to overwrite item");
            }
            buttons.add(icon.get());
        }
        buttons.add(createNewButton);
        Map pages = Utils.paginate(45, buttons);
        this.page = Math.max(1, Math.min(this.page, pages.size()));
        if (!pages.isEmpty()) {
            pages.get(this.page - 1).forEach(xva$0 -> this.inventory.addItem(new ItemStack[]{xva$0}));
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(53, nextPageButton);
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        if (this.currentItem != null) {
            this.currentItem.setModifiers(resultModifiers);
        }
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        return this.currentItem == null ? null : this.currentItem.getModifiers();
    }
}

