/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategory;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierCategoryRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierPriority;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.RelationalToItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicBrewingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCauldronRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicCookingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicSmithingRecipe;
import me.athlaeos.valhallammo.crafting.recipetypes.ImmersiveCraftingRecipe;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.item.CustomItem;
import me.athlaeos.valhallammo.item.CustomItemRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class DynamicModifierMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    private static final NamespacedKey KEY_MODIFIER_ID = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_modifier_id");
    private static final NamespacedKey KEY_MODIFIER_CATEGORY_ID = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_modifier_category_id");
    private static final NamespacedKey KEY_MODIFIER_BUTTON = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_modifier_button");
    private final List<ItemStack> scrollItems = new ArrayList<ItemStack>(ModifierCategoryRegistry.getCategories().values().stream().sorted(Comparator.comparingInt(ModifierCategory::order)).map(c -> new ItemBuilder(c.icon()).stringTag(KEY_MODIFIER_CATEGORY_ID, c.id()).get()).toList());
    private static final List<Integer> modifierButtonIndexes = Arrays.asList(3, 4, 5, 6, 7, 12, 13, 14, 15, 16, 21, 22, 23, 24, 25, 30, 31, 32, 33, 34, 39, 40, 41, 42, 43);
    private static final List<Integer> scrollBarIndexes = Arrays.asList(45, 46, 47, 48, 49, 50, 51, 52, 53);
    private static final ItemStack modifierPriorityButton = new ItemBuilder(Material.CLOCK).stringTag(KEY_ACTION, "modifierPriorityButton").name("&6&lPriority").get();
    private static final ItemStack confirmButton = new ItemBuilder(Material.STRUCTURE_VOID).stringTag(KEY_ACTION, "confirmButton").name("&b&lSave").get();
    private static final ItemStack createNewButton = new ItemBuilder(DynamicModifierMenu.getButtonData("editor_newrecipe", Material.LIME_DYE)).name("&b&lNew").stringTag(KEY_ACTION, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack copyFromRecipeButton = new ItemBuilder(DynamicModifierMenu.getButtonData("editor_modifiers_copyfromrecipe", Material.CRAFTING_TABLE)).name("&b&lCopy from Recipe").lore("&fCopies the modifiers from a selected", "&frecipe. This overwrites existing", "&fmodifiers with the same ID!").stringTag(KEY_ACTION, "copyFromRecipeButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack copyFromIndexButton = new ItemBuilder(DynamicModifierMenu.getButtonData("editor_modifiers_copyfromindexeditem", Material.ENDER_CHEST)).name("&d&lCopy from Indexed Item").lore("&fCopies the modifiers from a selected", "&findexed item. This overwrites existing", "&fmodifiers with the same ID!").stringTag(KEY_ACTION, "copyFromIndexButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack cancelButton = new ItemBuilder(Material.BARRIER).stringTag(KEY_ACTION, "cancelButton").name("&cDelete").get();
    private static final ItemStack nextPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "nextPageButton").name("&7&lNext page").get();
    private static final ItemStack previousPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "previousPageButton").name("&7&lPrevious page").get();
    private final Menu menu;
    private View view = View.VIEW_MODIFIERS;
    private int currentPage = 0;
    private ModifierCategory currentCategory = ModifierCategoryRegistry.ALL;
    private final List<DynamicItemModifier> currentModifiers;
    private DynamicItemModifier currentModifier = null;
    private ModifierPriority priority = ModifierPriority.NEUTRAL;
    private final boolean showRelational;
    private static final List<ItemStack> recipeButtons = new ArrayList<ItemStack>();
    private static final List<ItemStack> itemButtons = new ArrayList<ItemStack>();
    private final NamespacedKey RECIPES_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_recipes");
    private final NamespacedKey INDEX_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_index");

    public DynamicModifierMenu(PlayerMenuUtility playerMenuUtility, Menu menu) {
        super(playerMenuUtility);
        this.menu = menu;
        this.showRelational = false;
        if (menu instanceof SetModifiersMenu) {
            SetModifiersMenu m = (SetModifiersMenu)((Object)menu);
            this.currentModifiers = m.getResultModifiers();
        } else {
            this.currentModifiers = new ArrayList<DynamicItemModifier>();
        }
    }

    public DynamicModifierMenu(PlayerMenuUtility playerMenuUtility, Menu menu, boolean showAdvanced) {
        super(playerMenuUtility);
        this.menu = menu;
        this.showRelational = showAdvanced;
        if (menu instanceof SetModifiersMenu) {
            SetModifiersMenu m = (SetModifiersMenu)((Object)menu);
            this.currentModifiers = m.getResultModifiers();
        } else {
            this.currentModifiers = new ArrayList<DynamicItemModifier>();
        }
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf301\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_ingredientselection"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String clickedIndexedItem;
        String clickedCategory;
        String clickedModifier;
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "confirmButton": {
                    Menu menu;
                    if (this.view == View.NEW_MODIFIER) {
                        if (this.currentModifier == null) break;
                        this.currentModifiers.removeIf(m -> m.getName().equalsIgnoreCase(this.currentModifier.getName()));
                        this.currentModifier.setPriority(this.priority);
                        this.currentModifiers.add(this.currentModifier);
                        DynamicItemModifier.sortModifiers(this.currentModifiers);
                        this.priority = ModifierPriority.NEUTRAL;
                        this.currentModifier = null;
                        this.view = View.VIEW_MODIFIERS;
                        break;
                    }
                    if (this.view == View.PICK_MODIFIERS) {
                        this.view = View.VIEW_MODIFIERS;
                        break;
                    }
                    if (this.view != View.VIEW_MODIFIERS || !((menu = this.menu) instanceof SetModifiersMenu)) break;
                    SetModifiersMenu m2 = (SetModifiersMenu)((Object)menu);
                    m2.setResultModifiers(this.currentModifiers);
                    this.menu.open();
                    break;
                }
                case "copyFromRecipeButton": {
                    this.view = View.RECIPE_MODIFIERS;
                    break;
                }
                case "copyFromIndexButton": {
                    this.view = View.INDEX_MODIFIERS;
                    break;
                }
                case "createNewButton": {
                    this.view = View.PICK_MODIFIERS;
                    break;
                }
                case "nextPageButton": {
                    ++this.currentPage;
                    break;
                }
                case "previousPageButton": {
                    --this.currentPage;
                    break;
                }
                case "cancelButton": {
                    if (this.view == View.RECIPE_MODIFIERS || this.view == View.INDEX_MODIFIERS) {
                        this.view = View.VIEW_MODIFIERS;
                        break;
                    }
                    if (this.currentModifier == null) break;
                    if (this.currentModifiers.removeIf(m -> m.getName().equalsIgnoreCase(this.currentModifier.getName()))) {
                        this.view = View.VIEW_MODIFIERS;
                        break;
                    }
                    this.view = View.PICK_MODIFIERS;
                    break;
                }
                case "modifierPriorityButton": {
                    int currentIndex = Arrays.asList(ModifierPriority.values()).indexOf((Object)this.priority);
                    if (e.getClick().isRightClick()) {
                        currentIndex = Math.min(ModifierPriority.values().length - 1, currentIndex + 1);
                    } else if (e.getClick().isLeftClick()) {
                        currentIndex = currentIndex - 1 < 0 ? ModifierPriority.values().length - 1 : currentIndex - 1;
                    }
                    this.priority = ModifierPriority.values()[currentIndex];
                }
            }
        }
        if (!StringUtils.isEmpty(clickedModifier = ItemUtils.getPDCString(KEY_MODIFIER_ID, clickedItem, null))) {
            if (this.view == View.PICK_MODIFIERS) {
                this.currentModifier = ModifierRegistry.createModifier(clickedModifier);
                this.view = View.NEW_MODIFIER;
            } else if (this.view == View.VIEW_MODIFIERS) {
                for (DynamicItemModifier modifier : this.currentModifiers) {
                    if (!modifier.getName().equals(clickedModifier)) continue;
                    this.currentModifier = modifier;
                    this.priority = modifier.getPriority();
                    this.view = View.NEW_MODIFIER;
                    break;
                }
            }
        }
        if (!StringUtils.isEmpty(clickedCategory = ItemUtils.getPDCString(KEY_MODIFIER_CATEGORY_ID, clickedItem, ""))) {
            this.currentCategory = ModifierCategoryRegistry.getCategory(clickedCategory);
        }
        String clickedRecipe = ItemUtils.getPDCString(this.RECIPES_KEY, clickedItem, null);
        ArrayList<DynamicItemModifier> newModifiers = new ArrayList<DynamicItemModifier>();
        if (clickedRecipe != null) {
            if (CustomRecipeRegistry.getGridRecipes().containsKey(clickedRecipe)) {
                newModifiers.addAll(CustomRecipeRegistry.getGridRecipes().get(clickedRecipe).getModifiers().stream().map(DynamicItemModifier::copy).toList());
            } else if (CustomRecipeRegistry.getCookingRecipes().containsKey(clickedRecipe)) {
                newModifiers.addAll(CustomRecipeRegistry.getCookingRecipes().get(clickedRecipe).getModifiers().stream().map(DynamicItemModifier::copy).toList());
            } else if (CustomRecipeRegistry.getBrewingRecipes().containsKey(clickedRecipe)) {
                newModifiers.addAll(CustomRecipeRegistry.getBrewingRecipes().get(clickedRecipe).getModifiers().stream().map(DynamicItemModifier::copy).toList());
            } else if (CustomRecipeRegistry.getSmithingRecipes().containsKey(clickedRecipe)) {
                newModifiers.addAll(CustomRecipeRegistry.getSmithingRecipes().get(clickedRecipe).getResultModifiers().stream().map(DynamicItemModifier::copy).toList());
            } else if (CustomRecipeRegistry.getCauldronRecipes().containsKey(clickedRecipe)) {
                newModifiers.addAll(CustomRecipeRegistry.getCauldronRecipes().get(clickedRecipe).getModifiers().stream().map(DynamicItemModifier::copy).toList());
            } else if (CustomRecipeRegistry.getImmersiveRecipes().containsKey(clickedRecipe)) {
                newModifiers.addAll(CustomRecipeRegistry.getImmersiveRecipes().get(clickedRecipe).getModifiers().stream().map(DynamicItemModifier::copy).toList());
            } else {
                Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cThis recipe has already been deleted");
            }
            if (!newModifiers.isEmpty()) {
                this.currentModifiers.removeIf(cm -> newModifiers.stream().anyMatch(nm -> cm.getName().equalsIgnoreCase(nm.getName())));
                this.currentModifiers.addAll(newModifiers);
                this.view = View.VIEW_MODIFIERS;
            }
        }
        if ((clickedIndexedItem = ItemUtils.getPDCString(this.INDEX_KEY, clickedItem, null)) != null) {
            if (CustomItemRegistry.getItems().containsKey(clickedIndexedItem)) {
                newModifiers.addAll(CustomItemRegistry.getItem(clickedIndexedItem).getModifiers().stream().map(DynamicItemModifier::copy).toList());
            } else {
                Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cThis item has already been deleted");
            }
            if (!newModifiers.isEmpty()) {
                this.currentModifiers.removeIf(cm -> newModifiers.stream().anyMatch(nm -> cm.getName().equalsIgnoreCase(nm.getName())));
                this.currentModifiers.addAll(newModifiers);
                this.view = View.VIEW_MODIFIERS;
            }
        }
        if (ItemUtils.getPDCInt(KEY_MODIFIER_BUTTON, clickedItem, 0) > 0 && this.currentModifier != null) {
            int buttonPressed = modifierButtonIndexes.indexOf(e.getRawSlot());
            this.currentModifier.onButtonPress(e, this, buttonPressed);
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        switch (this.view.ordinal()) {
            case 1: {
                this.setViewModifiersView();
                break;
            }
            case 0: {
                this.setPickModifiersView();
                break;
            }
            case 2: {
                this.setNewModifierView();
                break;
            }
            case 4: {
                this.setItemIndexModifiersView();
                break;
            }
            case 3: {
                this.setRecipeModifiersView();
            }
        }
    }

    private void setRecipeModifiersView() {
        ArrayList<ItemStack> buttons = new ArrayList<ItemStack>();
        if (recipeButtons.isEmpty()) {
            for (DynamicGridRecipe dynamicGridRecipe : CustomRecipeRegistry.getGridRecipes().values()) {
                buttons.add(this.icon(dynamicGridRecipe.getName(), "&6Grid Recipes", dynamicGridRecipe.tinker() ? Objects.requireNonNullElse(dynamicGridRecipe.getGridTinkerEquipment(), new SlotEntry(dynamicGridRecipe.getResult(), new MaterialChoice())).getItem() : dynamicGridRecipe.getResult(), dynamicGridRecipe.getModifiers(), true));
            }
            for (DynamicCookingRecipe dynamicCookingRecipe : CustomRecipeRegistry.getCookingRecipes().values()) {
                buttons.add(this.icon(dynamicCookingRecipe.getName(), "&c" + StringUtils.toPascalCase(dynamicCookingRecipe.getType().toString().replace("_", " ")) + " Recipes", dynamicCookingRecipe.tinker() ? dynamicCookingRecipe.getInput().getItem() : dynamicCookingRecipe.getResult(), dynamicCookingRecipe.getModifiers(), true));
            }
            for (DynamicSmithingRecipe dynamicSmithingRecipe : CustomRecipeRegistry.getSmithingRecipes().values()) {
                buttons.add(this.icon(dynamicSmithingRecipe.getName(), "&9Smithing Recipes", dynamicSmithingRecipe.tinkerBase() ? dynamicSmithingRecipe.getBase().getItem() : dynamicSmithingRecipe.getResult(), dynamicSmithingRecipe.getResultModifiers(), true));
            }
            for (DynamicBrewingRecipe dynamicBrewingRecipe : CustomRecipeRegistry.getBrewingRecipes().values()) {
                buttons.add(this.icon(dynamicBrewingRecipe.getName(), "&dBrewing Recipes", dynamicBrewingRecipe.tinker() ? dynamicBrewingRecipe.getIngredient().getItem() : dynamicBrewingRecipe.getResult(), dynamicBrewingRecipe.getModifiers(), true));
            }
            for (DynamicCauldronRecipe dynamicCauldronRecipe : CustomRecipeRegistry.getCauldronRecipes().values()) {
                buttons.add(this.icon(dynamicCauldronRecipe.getName(), "&bCauldron Recipes", dynamicCauldronRecipe.tinkerCatalyst() ? dynamicCauldronRecipe.getCatalyst().getItem() : dynamicCauldronRecipe.getResult(), dynamicCauldronRecipe.getModifiers(), true));
            }
            for (ImmersiveCraftingRecipe immersiveCraftingRecipe : CustomRecipeRegistry.getImmersiveRecipes().values()) {
                buttons.add(this.icon(immersiveCraftingRecipe.getName(), "&aImmersive Recipes", immersiveCraftingRecipe.tinker() ? immersiveCraftingRecipe.getTinkerInput().getItem() : immersiveCraftingRecipe.getResult(), immersiveCraftingRecipe.getModifiers(), true));
            }
            recipeButtons.addAll(buttons);
        } else {
            buttons.addAll(recipeButtons);
        }
        buttons.sort(Comparator.comparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder((ItemStack)item)))));
        Map pages = Utils.paginate(45, buttons);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            for (ItemStack i : pages.get(this.currentPage - 1)) {
                this.inventory.addItem(new ItemStack[]{i});
            }
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(53, nextPageButton);
        this.inventory.setItem(49, cancelButton);
    }

    private void setItemIndexModifiersView() {
        ArrayList<ItemStack> buttons = new ArrayList<ItemStack>();
        if (itemButtons.isEmpty()) {
            ArrayList<String> itemIDs = new ArrayList<String>(CustomItemRegistry.getItems().keySet());
            itemIDs.sort(Comparator.comparing(s -> s));
            for (String i : itemIDs) {
                CustomItem item = Catch.catchOrElse(() -> CustomItemRegistry.getItem(i), null);
                if (item == null) continue;
                buttons.add(this.icon(item.getId(), "&6Grid Recipes", item.getItem(), item.getModifiers(), false));
            }
            itemButtons.addAll(buttons);
        } else {
            buttons.addAll(itemButtons);
        }
        Map pages = Utils.paginate(45, buttons);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            for (String i : pages.get(this.currentPage - 1)) {
                this.inventory.addItem(new ItemStack[]{i});
            }
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(53, nextPageButton);
        this.inventory.setItem(49, cancelButton);
    }

    private ItemStack icon(String name, String source, ItemStack base, List<DynamicItemModifier> modifiers, boolean recipes) {
        return new ItemBuilder(base).name("&e" + name + "&f from " + source).lore("&fModifiers:", "").stringTag(recipes ? this.RECIPES_KEY : this.INDEX_KEY, name).appendLore(modifiers.stream().map(m -> "&f> " + m.getDisplayName()).toList()).get();
    }

    private void setNewModifierView() {
        if (this.currentModifier != null) {
            if (this.currentModifier.getButtons() != null) {
                for (Integer b : this.currentModifier.getButtons().keySet()) {
                    if (b >= modifierButtonIndexes.size()) {
                        throw new IllegalArgumentException("Modifier " + this.currentModifier.getName() + " has button in invalid position " + b + ", must be between 0 and 25(non-inclusive)!");
                    }
                    ItemStack base = this.currentModifier.getButtons().get(b);
                    if (ItemUtils.isEmpty(base)) {
                        throw new IllegalStateException("Modifier " + this.currentModifier.getName() + " has empty button in slot " + b);
                    }
                    ItemStack button = new ItemBuilder(base).intTag(KEY_MODIFIER_BUTTON, 1).get();
                    this.inventory.setItem(modifierButtonIndexes.get(b).intValue(), button);
                }
            }
            ArrayList<String> modifierPriorityLore = new ArrayList<String>(List.of("&e" + String.valueOf((Object)this.priority), "&8&m                <>                ", this.priority.getVisual(), "&8&m                <>                "));
            modifierPriorityLore.addAll(StringUtils.separateStringIntoLines(this.priority.getDescription(), 40));
            ItemStack priorityButton = new ItemBuilder(modifierPriorityButton).lore(modifierPriorityLore).name("&fExecution Priority: &e" + String.valueOf((Object)this.priority)).get();
            this.inventory.setItem(19, priorityButton);
        }
        this.inventory.setItem(53, confirmButton);
        this.inventory.setItem(45, cancelButton);
    }

    private void setPickModifiersView() {
        for (int i = 0; i < 36; ++i) {
            this.inventory.setItem(i, null);
        }
        Map<String, DynamicItemModifier> modifiers = ModifierRegistry.getModifiers();
        Collection currentStringModifiers = this.currentModifiers.stream().map(DynamicItemModifier::getName).collect(Collectors.toSet());
        ArrayList<DynamicItemModifier> sortedModifiers = new ArrayList<DynamicItemModifier>(modifiers.values());
        sortedModifiers.sort(Comparator.comparing(DynamicItemModifier::getDisplayName));
        ArrayList<ItemStack> totalModifierButtons = new ArrayList<ItemStack>();
        for (DynamicItemModifier modifier : sortedModifiers) {
            if (currentStringModifiers.contains(modifier.getName()) || modifier instanceof RelationalToItemModifier && !this.showRelational || !this.currentCategory.equals(ModifierCategoryRegistry.ALL) && !modifier.getCategories().contains(this.currentCategory.id())) continue;
            ItemStack icon = new ItemBuilder(modifier.getModifierIcon()).lore(StringUtils.separateStringIntoLines(modifier.getDescription(), 40)).name(modifier.getDisplayName()).flag(ItemFlag.HIDE_DYE, ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_ENCHANTS).wipeAttributes().stringTag(KEY_MODIFIER_ID, modifier.getName()).get();
            totalModifierButtons.add(icon);
        }
        Map pages = Utils.paginate(36, totalModifierButtons);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            for (ItemStack i : pages.get(this.currentPage - 1)) {
                this.inventory.addItem(new ItemStack[]{i});
            }
        }
        this.inventory.setItem(36, previousPageButton);
        this.inventory.setItem(44, nextPageButton);
        this.inventory.setItem(40, confirmButton);
        this.setScrollBar();
    }

    private void setViewModifiersView() {
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, null);
        }
        List<DynamicItemModifier> modifiers = this.currentModifiers.stream().filter(m -> this.showRelational || !(m instanceof RelationalToItemModifier)).limit(45L).sorted(Comparator.comparingInt(a -> a.getPriority().getPriorityRating())).toList();
        for (DynamicItemModifier modifier : modifiers) {
            if (ItemUtils.isEmpty(modifier.getModifierIcon())) {
                ValhallaMMO.logWarning("Modifier " + modifier.getName() + " has no icon, please notify plugin author Athlaeos!");
            }
            ItemStack icon = new ItemBuilder(ItemUtils.isEmpty(modifier.getModifierIcon()) ? new ItemStack(Material.BARRIER) : modifier.getModifierIcon()).lore(StringUtils.separateStringIntoLines(modifier.getActiveDescription(), 40)).name(modifier.getDisplayName()).stringTag(KEY_MODIFIER_ID, modifier.getName()).flag(ItemFlag.HIDE_DYE, ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
            this.inventory.addItem(new ItemStack[]{icon});
        }
        if (this.currentModifiers.size() <= 44) {
            this.inventory.addItem(new ItemStack[]{createNewButton});
        }
        this.inventory.setItem(46, copyFromIndexButton);
        this.inventory.setItem(49, confirmButton);
        this.inventory.setItem(52, copyFromRecipeButton);
    }

    private void setScrollBar() {
        for (ModifierCategory category : ModifierCategoryRegistry.getCategories().values()) {
            for (int o = 0; o < 9 && o < this.scrollItems.size(); ++o) {
                ItemStack iconToPut = this.scrollItems.get(o);
                this.inventory.setItem(scrollBarIndexes.get(o).intValue(), iconToPut);
            }
            ItemStack centerItem = this.inventory.getItem(49);
            if (ItemUtils.isEmpty(centerItem)) continue;
            String centerValue = ItemUtils.getPDCString(KEY_MODIFIER_CATEGORY_ID, centerItem, "");
            if (!ItemUtils.isEmpty(centerItem) && this.currentCategory.id().equalsIgnoreCase(centerValue)) break;
            Collections.rotate(this.scrollItems, 1);
        }
    }

    public static void resetCache() {
        recipeButtons.clear();
        itemButtons.clear();
    }

    private static enum View {
        PICK_MODIFIERS,
        VIEW_MODIFIERS,
        NEW_MODIFIER,
        RECIPE_MODIFIERS,
        INDEX_MODIFIERS;

    }
}

