/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.CustomRecipeRegistry;
import me.athlaeos.valhallammo.crafting.ToolRequirement;
import me.athlaeos.valhallammo.crafting.ToolRequirementType;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.DynamicItemModifier;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.IngredientChoice;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.crafting.recipetypes.DynamicGridRecipe;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetModifiersMenu;
import me.athlaeos.valhallammo.gui.SetRecipeOptionMenu;
import me.athlaeos.valhallammo.gui.SetValidationsMenu;
import me.athlaeos.valhallammo.gui.implementations.DynamicModifierMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.ValidationSelectionMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class GridRecipeEditor
extends Menu
implements SetModifiersMenu,
SetRecipeOptionMenu,
SetValidationsMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final List<Integer> gridIndexes = Arrays.asList(11, 12, 13, 20, 21, 22, 29, 30, 31);
    private static final int resultIndex = 23;
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final DynamicGridRecipe recipe;
    private RecipeOption selectedOption = null;
    private final Map<Integer, SlotEntry> items;
    private ItemStack result;
    private boolean requireValhallaTools;
    private boolean tinker;
    private int tinkerGridIndex;
    private int toolIndex;
    private boolean shapeless;
    private boolean hidden;
    private List<DynamicItemModifier> modifiers;
    private boolean unlockedForEveryone;
    private final ToolRequirement toolRequirement;
    private Collection<String> validations;
    private String displayName;
    private String description;
    private static final ItemStack toggleValhallaToolRequirementButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_valhallatoolrequirement", Material.DIAMOND_PICKAXE)).name("&eValhalla Tools").stringTag(BUTTON_ACTION_KEY, "toggleValhallaToolRequirementButton").lore("&7If enabled, any armors or tools", "&7in the recipe need to have ValhallaMMO ", "&7custom attributes. If disabled, vanilla ", "&7equipment can be used too.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleTinkerButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_toggletinker", Material.ANVIL)).name("&eTinker Tools").stringTag(BUTTON_ACTION_KEY, "toggleTinkerButton").lore("&7If enabled, the recipe will", "&7improve the first tool or armor", "&7found in the grid (or one specified", "&7in the \"tinker this item\" option)", "&7Otherwise, it will simply produce the", "&7item specified as the result.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack toggleHiddenButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_togglehidden", Material.ANVIL)).name("&eHidden from Recipe Book").stringTag(BUTTON_ACTION_KEY, "toggleHiddenButton").lore("&7If enabled, the recipe will", "&7not be visible in the recipe book.", "&eClick to toggle on/off").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack selectTinkerItemButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_selecttinkeritem", Material.ANVIL)).name("&eSelect which tool to tinker").stringTag(BUTTON_ACTION_KEY, "selectTinkerItemButton").lore("&eDrag-and-drop onto the", "&eitem in the grid &7you want the", "&7recipe to tinker.", "&eDrag-and-drop it onto itself", "&7to remove the previous selection.", "&eIf none are selected, it will", "&edefault to the first equipment found").get();
    private static final ItemStack selectValidationButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_selectvalidation", Material.BARRIER)).name("&eBlock condition").stringTag(BUTTON_ACTION_KEY, "selectValidationButton").lore("&7Block conditions are checks", "&7to allow/disallow recipes based on", "&7block environment.", "&7These conditions may also change", "&7the environment after crafting.", "&eClick to open the menu", "&8&m                <>                ", "%description%").get();
    private static final ItemStack selectToolItemButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_selecttoolitem", Material.IRON_HOE)).name("&eSelect which item is the tool").stringTag(BUTTON_ACTION_KEY, "selectToolItemButton").lore("&eDrag-and-drop onto the", "&eitem in the grid &7you want to", "&7mark as the tool required", "&7to make the recipe.", "&eDrag-and-drop it onto itself", "&7to remove the previous selection.", "&eIf none are selected, the tool", "&e(if any) needs to be in the player's", "&einventory").get();
    private static final ItemStack toggleShapelessButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_toggleshapeless", Material.SLIME_BALL)).name("&eShapeless").stringTag(BUTTON_ACTION_KEY, "toggleShapelessButton").lore("&7If enabled, the ingredients will", "&7not need to be in any specific", "&7configuration to craft.", "&7Otherwise the player will need", "&7to match the shape of the ingredients", "&7given here exactly").get();
    private static final ItemStack modifierButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_modifiers", Material.WRITABLE_BOOK)).name("&dDynamic Item Modifiers").stringTag(BUTTON_ACTION_KEY, "modifierButton").lore("&7Modifiers are functions to edit", "&7the output item based on player", "&7stats or to apply crafting conditions.", "&eClick to open the menu", "&8&m                <>                ", "%modifiers%").get();
    private static final ItemStack recipeOptionsButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_recipeoptions", Material.WRITABLE_BOOK)).name("&bIngredient Options").stringTag(BUTTON_ACTION_KEY, "recipeOptionsButton").lore("&7Ingredient options are ingredient", "&7flags you can put on an ingredient", "&7to change its behavior during crafting.", "&eClick to open the menu").get();
    private static final ItemStack toggleUnlockedForEveryoneButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_unlockedforeveryone", Material.PAPER)).name("&eUnlocked for Everyone").stringTag(BUTTON_ACTION_KEY, "toggleUnlockedForEveryoneButton").lore("&7If enabled, the recipe will", "&7available to everyone regardless", "&7if unlocked or not. Otherwise it", "&7will have to be unlocked through", "&7perk rewards.", "&eClick to toggle on/off").get();
    private static final ItemStack setToolRequirementButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_settoolrequirement", Material.CRAFTING_TABLE)).name("&eTool Required").stringTag(BUTTON_ACTION_KEY, "setToolRequirementButton").lore("%description%", "&8&m                <>                ", "&7Determines whether this recipe requires", "&7a tool to craft.", "&7If no ingredient is marked as tool it", "&7will need to be in the player's ", "&7inventory.", "&7A tool is determined by its \"Tool ID\"", "&7which can be applied with a modifier.", "&eRight/Left click to change the", "&eID required, hold Shift during clicks", "&eto change the requirement type").get();
    private static final ItemStack setDisplayNameButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_setdisplayname", Material.NAME_TAG)).name("&aSet Display Name").stringTag(BUTTON_ACTION_KEY, "setDisplayNameButton").lore("&7Sets the display name of the recipe.", "&7The display name is visible in the", "&7recipe book and is usually used", "&7to roughly describe the purpose of", "&7tinkering recipes since the output is", "&7non-descriptive.", "&eLeft-Click to set display name", "&cRight-Click to nullify display name", "&7A nullified display name defaults to", "&7the name of the input/output", "&8&m                <>                ", "&7Currently set to: %display_name%").get();
    private static final ItemStack setDescriptionButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_recipe_grid_setdescription", Material.WRITABLE_BOOK)).name("&aSet Description").stringTag(BUTTON_ACTION_KEY, "setDescriptionButton").lore("&7Sets the description of the recipe.", "&7The description is visible in the", "&7recipe book as lore.", "&eLeft-Click to set description", "&cRight-Click to nullify description", "&7A nullified description defaults to", "&7a default default recipe format in", "&7the language file.", "&8&m                <>                ", "&7Currently set to: %description%").get();
    private static final ItemStack confirmButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_save", Material.STRUCTURE_VOID)).name("&aConfirm").stringTag(BUTTON_ACTION_KEY, "confirmButton").lore("&aRight-click &7to save changes").get();
    private boolean confirmDeletion = false;
    private static final ItemStack deleteButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
    private static final ItemStack backToMenuButton = new ItemBuilder(GridRecipeEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();

    public GridRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicGridRecipe recipe) {
        super(playerMenuUtility);
        this.recipe = recipe;
        this.items = recipe.getItems();
        this.result = recipe.getResult();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinker();
        this.tinkerGridIndex = recipe.getTinkerGridIndex();
        this.toolIndex = recipe.getToolIndex();
        this.shapeless = recipe.isShapeless();
        this.modifiers = recipe.getModifiers();
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.toolRequirement = recipe.getToolRequirement();
        this.validations = recipe.getValidations();
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
        this.hidden = recipe.isHiddenFromBook();
    }

    public GridRecipeEditor(PlayerMenuUtility playerMenuUtility, DynamicGridRecipe recipe, String newName) {
        super(playerMenuUtility);
        this.recipe = new DynamicGridRecipe(newName);
        this.items = new HashMap<Integer, SlotEntry>(recipe.getItems());
        for (SlotEntry entry : this.items.values()) {
            IngredientChoice ingredientChoice;
            IngredientChoice ingredientChoice2 = entry.getOption();
            if (ingredientChoice2 instanceof RecipeOption) {
                RecipeOption o = (RecipeOption)ingredientChoice2;
                ingredientChoice = o.getNew();
            } else {
                ingredientChoice = entry.getOption();
            }
            entry.setOption(ingredientChoice);
        }
        this.result = recipe.getResult().clone();
        this.requireValhallaTools = recipe.requireValhallaTools();
        this.tinker = recipe.tinker();
        this.tinkerGridIndex = recipe.getTinkerGridIndex();
        this.toolIndex = recipe.getToolIndex();
        this.shapeless = recipe.isShapeless();
        this.modifiers = new ArrayList<DynamicItemModifier>(recipe.getModifiers().stream().map(DynamicItemModifier::copy).toList());
        this.unlockedForEveryone = recipe.isUnlockedForEveryone();
        this.toolRequirement = new ToolRequirement(recipe.getToolRequirement().getToolRequirementType(), recipe.getToolRequirement().getRequiredToolID());
        this.validations = new HashSet<String>(recipe.getValidations());
        this.displayName = recipe.getDisplayName();
        this.description = recipe.getDescription();
        this.hidden = recipe.isHiddenFromBook();
        this.recipe.setItems(this.items);
        this.recipe.setResult(this.result);
        this.recipe.setModifiers(this.modifiers);
        this.recipe.setShapeless(this.shapeless);
        this.recipe.setTinker(this.tinker);
        this.recipe.setRequireValhallaTools(this.requireValhallaTools);
        this.recipe.setTinkerGridIndex(this.tinkerGridIndex);
        this.recipe.setToolIndex(this.toolIndex);
        this.recipe.setToolRequirement(this.toolRequirement);
        this.recipe.setUnlockedForEveryone(this.unlockedForEveryone);
        this.recipe.setValidations(this.validations);
        this.recipe.setDescription(this.description);
        this.recipe.setDisplayName(this.displayName);
        this.recipe.setHiddenFromBook(this.hidden);
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf201\uf80c\uf80a\uf808\uf802&8%recipe%" : TranslationManager.getTranslation("editormenu_gridrecipes")).replace("%recipe%", this.recipe.getName());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        ItemStack cursor = e.getCursor();
        if (e.getClickedInventory() instanceof PlayerInventory && !ItemUtils.isEmpty(cursor) && (cursor.equals((Object)selectTinkerItemButton) || cursor.equals((Object)selectToolItemButton))) {
            e.getWhoClicked().setItemOnCursor(null);
            e.setCancelled(true);
            this.setMenuItems();
            return;
        }
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.CRAFTING_TABLE.getId()).open();
                    return;
                }
                case "modifierButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new DynamicModifierMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "recipeOptionsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new RecipeOptionMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this recipe?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    CustomRecipeRegistry.unregister(this.recipe.getName());
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.CRAFTING_TABLE.getId()).open();
                    return;
                }
                case "setDisplayNameButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the display name be? (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        GridRecipeEditor.this.displayName = answer;
                                    }
                                    GridRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionaire);
                        break;
                    }
                    this.displayName = null;
                    break;
                }
                case "setDescriptionButton": {
                    if (e.isLeftClick()) {
                        this.playerMenuUtility.setPreviousMenu(this);
                        e.getWhoClicked().closeInventory();
                        Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&aWhat should the description be? Use '/n' to separate lines. (type 'cancel' to cancel)", null, "")}){

                            @Override
                            public Action<Player> getOnFinish() {
                                if (this.getQuestions().isEmpty()) {
                                    return super.getOnFinish();
                                }
                                Question question = this.getQuestions().get(0);
                                if (question.getAnswer() == null) {
                                    return super.getOnFinish();
                                }
                                return p -> {
                                    String answer = Utils.chat(question.getAnswer());
                                    if (!answer.contains("cancel")) {
                                        GridRecipeEditor.this.description = answer;
                                    }
                                    GridRecipeEditor.this.playerMenuUtility.getPreviousMenu().open();
                                };
                            }
                        };
                        Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&aValid placeholders are:");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%ingredients% &afor the ingredients");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%result% &afor a preformatted result");
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "          &2%tinker% &afor the raw name of the tinkered result");
                        break;
                    }
                    this.description = null;
                    break;
                }
                case "confirmButton": {
                    if (this.items.isEmpty()) {
                        Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cPlease add some ingredients!");
                        this.setMenuItems();
                        return;
                    }
                    this.recipe.setItems(this.items);
                    this.recipe.setResult(this.result);
                    this.recipe.setModifiers(this.modifiers);
                    this.recipe.setShapeless(this.shapeless);
                    this.recipe.setTinker(this.tinker);
                    this.recipe.setRequireValhallaTools(this.requireValhallaTools);
                    this.recipe.setTinkerGridIndex(this.tinkerGridIndex);
                    this.recipe.setToolIndex(this.toolIndex);
                    this.recipe.setToolRequirement(this.toolRequirement);
                    this.recipe.setUnlockedForEveryone(this.unlockedForEveryone);
                    this.recipe.setValidations(this.validations);
                    this.recipe.setDescription(this.description);
                    this.recipe.setDisplayName(this.displayName);
                    this.recipe.setHiddenFromBook(this.hidden);
                    CustomRecipeRegistry.register(this.recipe, true);
                    CustomRecipeRegistry.setChangesMade();
                    new RecipeOverviewMenu(this.playerMenuUtility, RecipeOverviewMenu.CRAFTING_TABLE.getId()).open();
                    return;
                }
                case "selectValidationButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new ValidationSelectionMenu(this.playerMenuUtility, this, Material.CRAFTING_TABLE).open();
                    return;
                }
                case "setToolRequirementButton": {
                    if (e.getClick().isShiftClick()) {
                        int toolRequirement = Arrays.asList(ToolRequirementType.values()).indexOf((Object)this.toolRequirement.getToolRequirementType());
                        toolRequirement = e.getClick().isLeftClick() ? (toolRequirement + 1 >= ToolRequirementType.values().length ? 0 : ++toolRequirement) : (toolRequirement - 1 < 0 ? ToolRequirementType.values().length - 1 : --toolRequirement);
                        this.toolRequirement.setToolRequirementType(ToolRequirementType.values()[toolRequirement]);
                        break;
                    }
                    this.toolRequirement.setRequiredToolID(e.getClick().isLeftClick() ? this.toolRequirement.getRequiredToolID() + 1 : Math.max(-1, this.toolRequirement.getRequiredToolID() - 1));
                    break;
                }
                case "toggleValhallaToolRequirementButton": {
                    this.requireValhallaTools = !this.requireValhallaTools;
                    break;
                }
                case "toggleHiddenButton": {
                    this.hidden = !this.hidden;
                    break;
                }
                case "toggleTinkerButton": {
                    this.tinker = !this.tinker;
                    break;
                }
                case "toggleShapelessButton": {
                    this.shapeless = !this.shapeless;
                    break;
                }
                case "toggleUnlockedForEveryoneButton": {
                    this.unlockedForEveryone = !this.unlockedForEveryone;
                    break;
                }
                case "selectTinkerItemButton": 
                case "selectToolItemButton": {
                    e.setCancelled(false);
                }
            }
        }
        action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, cursor, "");
        if (23 == e.getRawSlot() || gridIndexes.contains(e.getRawSlot())) {
            if (e.getRawSlot() == 23 && !this.tinker && !ItemUtils.isEmpty(cursor)) {
                this.result = cursor.clone();
            } else if (gridIndexes.contains(e.getRawSlot())) {
                int index = gridIndexes.indexOf(e.getRawSlot());
                if (!ItemUtils.isEmpty(cursor)) {
                    SlotEntry entry = this.items.get(index);
                    if (entry != null && !ItemUtils.isEmpty(entry.getItem())) {
                        if (!StringUtils.isEmpty(action) && action.equals("selectTinkerItemButton")) {
                            this.tinkerGridIndex = index;
                            e.getWhoClicked().setItemOnCursor(null);
                        } else if (!StringUtils.isEmpty(action) && action.equals("selectToolItemButton")) {
                            this.toolIndex = index;
                            e.getWhoClicked().setItemOnCursor(null);
                        } else {
                            String option = ItemUtils.getPDCString(RecipeOptionMenu.KEY_OPTION_ID, cursor, null);
                            if (option != null && this.selectedOption != null) {
                                this.selectedOption = this.selectedOption.getNew();
                                if (!this.selectedOption.isCompatible(entry.getItem()) || !this.selectedOption.isCompatibleWithInputItem(false)) {
                                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cNot compatible with this item");
                                } else {
                                    if (this.selectedOption.isUnique()) {
                                        this.items.forEach((k, v) -> {
                                            IngredientChoice choice = v.getOption();
                                            if (choice != null && choice.equals(this.selectedOption)) {
                                                this.items.get(k).setOption(null);
                                            }
                                            Utils.sendMessage((CommandSender)e.getWhoClicked(), "Because this option is only allowed once, " + k + " had its option removed");
                                        });
                                    }
                                    this.items.get(index).setOption(this.selectedOption);
                                    e.getWhoClicked().setItemOnCursor(null);
                                }
                            } else {
                                this.items.put(index, new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice()));
                            }
                        }
                    } else {
                        this.items.put(index, new SlotEntry(new ItemBuilder(cursor.clone()).amount(1).get(), new MaterialChoice()));
                    }
                } else {
                    this.items.remove(index);
                    if (this.toolIndex == index) {
                        this.toolIndex = -1;
                    }
                    if (this.tinkerGridIndex == index) {
                        this.tinkerGridIndex = -1;
                    }
                }
            }
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        } else {
            if (ItemUtils.isEmpty(e.getCursor())) {
                return;
            }
            for (Integer slot : e.getRawSlots()) {
                if (!gridIndexes.contains(slot) || e.getView().getInventory(slot.intValue()) == null || e.getView().getInventory(slot.intValue()) instanceof PlayerInventory) continue;
                e.setCancelled(true);
                int index = gridIndexes.indexOf(slot);
                SlotEntry entry = this.items.get(index);
                if (entry != null && !ItemUtils.isEmpty(entry.getItem())) continue;
                this.items.put(index, new SlotEntry(new ItemBuilder(e.getCursor().clone()).amount(1).get(), new MaterialChoice()));
            }
        }
    }

    @Override
    public void setMenuItems() {
        List<String> list;
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        for (Integer i : gridIndexes) {
            this.inventory.setItem(i.intValue(), null);
        }
        for (Integer slot : this.items.keySet()) {
            SlotEntry entry = this.items.get(slot);
            if (ItemUtils.isEmpty(entry.getItem())) continue;
            ArrayList<String> lore = new ArrayList<String>();
            if (this.tinkerGridIndex == slot) {
                lore.add(Utils.chat("&8&m            <&7Tinkering&8&m>            "));
                lore.add(Utils.chat("&aThis item will be tinkered"));
            }
            if (this.toolIndex == slot) {
                lore.add(Utils.chat("&8&m              <&7Tool&8&m>              "));
                lore.add(Utils.chat("&aThis item can be any material as long"));
                lore.add(Utils.chat("&aas it matches the tool requirements"));
            }
            lore.addAll(SlotEntry.getOptionLore(entry));
            ItemStack icon = new ItemBuilder(entry.getItem().clone()).appendLore(lore).get();
            this.inventory.setItem(gridIndexes.get(slot).intValue(), icon);
        }
        if (!this.tinker) {
            this.inventory.setItem(23, this.result.clone());
        } else {
            SlotEntry tinkerItem = this.recipe.getGridTinkerEquipment();
            ItemStack editItem = tinkerItem == null ? null : tinkerItem.getItem();
            this.inventory.setItem(23, ItemUtils.isEmpty(editItem) ? new ItemBuilder(Material.BARRIER).name("&cNo valid tinkerable item found").lore("&7Recipe might not be craftable").get() : new ItemBuilder(editItem.getType()).name("&dTinkered Item").get());
        }
        ArrayList<String> modifierLore = new ArrayList<String>();
        this.modifiers.forEach(m -> modifierLore.addAll(StringUtils.separateStringIntoLines("&d> " + m.getActiveDescription(), 40)));
        boolean toolRequired = this.toolRequirement.getRequiredToolID() >= 0 && this.toolRequirement.getToolRequirementType() != ToolRequirementType.NOT_REQUIRED && this.toolRequirement.getToolRequirementType() != ToolRequirementType.NONE_MANDATORY;
        String toolSettings = "&7ID: &6" + this.toolRequirement.getRequiredToolID() + "&7 | Type: &6" + StringUtils.toPascalCase(this.toolRequirement.getToolRequirementType().toString().replace("_", " "));
        if (toolRequired) {
            switch (this.toolRequirement.getToolRequirementType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case EQUAL: {
                    list = List.of(toolSettings, Utils.chat("&eTool with ID " + this.toolRequirement.getRequiredToolID() + " required"));
                    break;
                }
                case NOT_REQUIRED: {
                    list = List.of(toolSettings, Utils.chat("&eNo tool required"));
                    break;
                }
                case NONE_MANDATORY: {
                    list = List.of(toolSettings, Utils.chat("&eNo tool is allowed to be used"));
                    break;
                }
                case EQUAL_OR_LESSER: {
                    list = List.of(toolSettings, Utils.chat("&eTool with ID of or lesser than " + this.toolRequirement.getRequiredToolID() + " required"));
                    break;
                }
                case EQUAL_OR_GREATER: {
                    list = List.of(toolSettings, Utils.chat("&eTool with ID of or greater than " + this.toolRequirement.getRequiredToolID() + " required"));
                    break;
                }
            }
        } else {
            list = List.of(toolSettings, Utils.chat("&eNo tool required"));
        }
        List<String> toolDescription = list;
        ItemStack toolRequirementButton = setToolRequirementButton.clone();
        toolRequirementButton = new ItemBuilder(toolRequirementButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(toolRequirementButton), "%description%", toolDescription)).get();
        ArrayList<String> validationLore = new ArrayList<String>();
        if (!this.validations.isEmpty()) {
            for (String v : this.validations) {
                Validation validation = ValidationRegistry.getValidation(v);
                validationLore.add(validation.activeDescription());
            }
        } else {
            validationLore.add("&aNo special conditions required");
        }
        ArrayList<String> gridDetails = new ArrayList<String>();
        if (this.recipe.isShapeless()) {
            String shapelessFormat = TranslationManager.getTranslation("ingredient_format_shapeless");
            Map<SlotEntry, Integer> contents = ItemUtils.getItemTotals(this.recipe.getItems().values());
            for (SlotEntry entry : contents.keySet()) {
                int amount = contents.get(entry);
                gridDetails.add(shapelessFormat.replace("%amount%", String.valueOf(amount)).replace("%ingredient%", SlotEntry.toString(entry)));
            }
        } else {
            String shapeFormat = TranslationManager.getTranslation("ingredient_format_grid_shape");
            String charFormat = TranslationManager.getTranslation("ingredient_format_grid_ingredient");
            DynamicGridRecipe.ShapeDetails details = this.recipe.getRecipeShapeStrings();
            for (String shapeLine : details.getShape()) {
                gridDetails.add(shapeFormat.replace("%characters%", shapeLine));
            }
            for (Character c : details.getItems().keySet()) {
                if (details.getItems().get(c) == null) continue;
                gridDetails.add(charFormat.replace("%character%", String.valueOf(c)).replace("%ingredient%", SlotEntry.toString(details.getItems().get(c))));
            }
        }
        ItemBuilder resultBuilder = new ItemBuilder(this.result);
        String tinkerFormat = TranslationManager.getTranslation("tinker_result_format");
        List<String> description = ItemUtils.setListPlaceholder(Arrays.asList(this.description == null ? "&eDefault".split("/n") : this.description.replace("%result%", this.tinker ? tinkerFormat.replace("%item%", SlotEntry.toString(this.recipe.getGridTinkerEquipment())) : ItemUtils.getItemName(resultBuilder)).replace("%tinker%", this.tinker ? SlotEntry.toString(this.recipe.getGridTinkerEquipment()) : ItemUtils.getItemName(resultBuilder)).split("/n")), "%ingredients%", gridDetails);
        this.inventory.setItem(0, new ItemBuilder(setDisplayNameButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDisplayNameButton), "%display_name%", List.of(this.displayName == null ? "&eDefault" : this.displayName))).get());
        this.inventory.setItem(1, new ItemBuilder(setDescriptionButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(setDescriptionButton), "%description%", description)).get());
        this.inventory.setItem(3, new ItemBuilder(selectValidationButton).lore(ItemUtils.setListPlaceholder(ItemUtils.getLore(selectValidationButton), "%description%", validationLore)).get());
        this.inventory.setItem(5, new ItemBuilder(toggleUnlockedForEveryoneButton).name("&eUnlocked for Everyone " + (this.unlockedForEveryone ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(8, new ItemBuilder(toggleHiddenButton).name("&eHidden from Recipe Book: " + (this.hidden ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(9, selectTinkerItemButton);
        this.inventory.setItem(17, new ItemBuilder(toggleValhallaToolRequirementButton).name("&eValhalla Tools: " + (this.requireValhallaTools ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(19, recipeOptionsButton);
        this.inventory.setItem(24, new ItemBuilder(modifierButton).lore(modifierLore).get());
        this.inventory.setItem(25, new ItemBuilder(toolRequirementButton).name("&eTool Required: " + (toolRequired ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(27, selectToolItemButton);
        this.inventory.setItem(32, new ItemBuilder(toggleShapelessButton).name("&eShapeless: " + (this.shapeless ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(35, new ItemBuilder(toggleTinkerButton).name("&eTinker: " + (this.tinker ? "&aYes" : "&fNo")).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, confirmButton);
    }

    @Override
    public void setResultModifiers(List<DynamicItemModifier> resultModifiers) {
        this.modifiers = resultModifiers;
    }

    @Override
    public List<DynamicItemModifier> getResultModifiers() {
        return this.modifiers;
    }

    @Override
    public void setRecipeOption(RecipeOption option) {
        this.selectedOption = option;
        if (option == null) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> this.playerMenuUtility.getOwner().setItemOnCursor(new ItemBuilder(option.getIcon()).stringTag(RecipeOptionMenu.KEY_OPTION_ID, option.getName()).get()), 1L);
    }

    @Override
    public void setValidations(Collection<String> validations) {
        this.validations = validations;
    }

    @Override
    public Collection<String> getValidations() {
        return this.validations;
    }
}

