/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetIngredientsMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class IngredientSelectionMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    private static final ItemStack confirmButton = new ItemBuilder(IngredientSelectionMenu.getButtonData("editor_ingredient_selection_save", Material.STRUCTURE_VOID)).name("&aConfirm").stringTag(KEY_ACTION, "confirmButton").lore("&aRight-click &7to save changes").get();
    private static final ItemStack cancelButton = new ItemBuilder(IngredientSelectionMenu.getButtonData("editor_ingredient_selection_return", Material.BOOK)).stringTag(KEY_ACTION, "cancelButton").name("&7Return to menu without saving").get();
    private final Menu menu;
    private Map<ItemStack, Integer> currentIngredients = new HashMap<ItemStack, Integer>();
    private List<ItemStack> listedIngredients = new ArrayList<ItemStack>();
    private int stackCap = 45;

    public IngredientSelectionMenu(PlayerMenuUtility playerMenuUtility, Menu menu) {
        super(playerMenuUtility);
        this.menu = menu;
        if (menu instanceof SetIngredientsMenu) {
            SetIngredientsMenu m = (SetIngredientsMenu)((Object)menu);
            this.currentIngredients = m.getIngredients();
            this.listedIngredients = ItemUtils.decompressStacks(m.getIngredients());
        }
    }

    public IngredientSelectionMenu(PlayerMenuUtility playerMenuUtility, Menu menu, int stackCap) {
        super(playerMenuUtility);
        this.menu = menu;
        this.stackCap = Math.min(stackCap, 45);
        if (menu instanceof SetIngredientsMenu) {
            SetIngredientsMenu m = (SetIngredientsMenu)((Object)menu);
            this.currentIngredients = m.getIngredients();
            this.listedIngredients = ItemUtils.decompressStacks(m.getIngredients());
        }
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf300\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_ingredientselection"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String action;
        ItemStack clickedItem = e.getCurrentItem();
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        if (e.getRawSlot() < this.stackCap) {
            e.setCancelled(false);
        }
        ItemStack[] originalContents = Arrays.copyOfRange(this.inventory.getContents(), 0, this.stackCap);
        ArrayList<ItemStack> listedContents = new ArrayList<ItemStack>(Arrays.asList(originalContents));
        listedContents.remove(confirmButton);
        Map<ItemStack, Integer> contents = ItemUtils.compressStacks(listedContents);
        this.listedIngredients = ItemUtils.decompressStacks(contents);
        this.currentIngredients = new HashMap<ItemStack, Integer>(contents);
        if (!ItemUtils.isEmpty(clickedItem) && !StringUtils.isEmpty(action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null))) {
            switch (action) {
                case "confirmButton": {
                    Menu menu = this.menu;
                    if (!(menu instanceof SetIngredientsMenu)) break;
                    SetIngredientsMenu m = (SetIngredientsMenu)((Object)menu);
                    m.setIngredients(this.currentIngredients);
                    this.menu.open();
                    return;
                }
                case "cancelButton": {
                    this.menu.open();
                }
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        for (int i = 0; i < 45; ++i) {
            if (i < this.stackCap) {
                this.inventory.setItem(i, null);
                continue;
            }
            this.inventory.setItem(i, new ItemStack(Material.RED_STAINED_GLASS_PANE));
        }
        for (ItemStack ingredient : this.listedIngredients.stream().limit(this.stackCap).toList()) {
            this.inventory.addItem(new ItemStack[]{ingredient});
        }
        this.inventory.setItem(45, cancelButton);
        this.inventory.setItem(53, confirmButton);
    }
}

