/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Question;
import me.athlaeos.valhallammo.dom.Questionnaire;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.implementations.LootPoolEditor;
import me.athlaeos.valhallammo.gui.implementations.LootTableOverviewMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootPool;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class LootTableEditor
extends Menu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final NamespacedKey BUTTON_DATA = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_data");
    private static final int iconIndex = 4;
    private static final int preservationTypeIndex = 10;
    private static final int poolDescriptionIndex = 16;
    private static final int previousPageIndex = 27;
    private static final int nextPageIndex = 35;
    private static final int deleteIndex = 45;
    private static final int backToMenuIndex = 53;
    private static final int[] poolIndexes = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final LootTable table;
    private static final ItemStack togglePreservationTypeButton = new ItemBuilder(LootTableEditor.getButtonData("editor_loottable_preservationmode", Material.COMPARATOR)).name("&eLoot Preservation Mode").stringTag(BUTTON_ACTION_KEY, "togglePreservationTypeButton").lore("&7Determines how vanilla loot is treated", "&7with this loot table involved.", "&7Vanilla loot can be", "&a- Preserved entirely, generated", "&aloot is added to vanilla loot", "&e- Removed if loot table generated", "&eloot", "&c- Removed regardless of generated", "&cloot", "", "&eClick to cycle").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private final ItemStack iconLabel;
    private static final ItemStack poolDescriptionLabel = new ItemBuilder(LootTableEditor.getButtonData("editor_loottable_descriptionlabel", Material.PAPER)).name("&9What's a pool?").lore("&fA loot pool is a subdivision of a", "&floot table.", "&fLoottables can have as many pools", "&fas you want, each possibly", "&fcontributing to drops as long as", "&fits filter conditions pass. ", "&fThis makes tables more structured", "&fand allows for more control.").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack nextPageButton = new ItemBuilder(LootTableEditor.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(BUTTON_ACTION_KEY, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButton = new ItemBuilder(LootTableEditor.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(BUTTON_ACTION_KEY, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack deleteButton = new ItemBuilder(LootTableEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Loot Table").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(LootTableEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Loot Table").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm table deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
    private static final ItemStack backToMenuButton = new ItemBuilder(LootTableEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();
    private static final ItemStack createNewButton = new ItemBuilder(LootTableEditor.getButtonData("editor_loottable_newpool", Material.LIME_DYE)).name("&b&lNew Pool").stringTag(BUTTON_ACTION_KEY, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private boolean confirmDeletion = false;
    private int page = 0;

    public LootTableEditor(PlayerMenuUtility playerMenuUtility, LootTable table) {
        super(playerMenuUtility);
        this.table = table;
        this.iconLabel = new ItemBuilder(table.getIcon()).lore("&fThe icon of the loot table.", "&fNot visible to players, it's", "&fjust for your own organization", "&fneeds.", "&6Click with item to change icon").name("&eLoot Table Icon").get();
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf310\uf80c\uf80a\uf808\uf802&8%table%" : TranslationManager.getTranslation("editormenu_loottables")).replace("%table%", this.table.getKey());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        LootPool pool;
        String data;
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        ItemStack cursor = e.getCursor();
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new LootTableOverviewMenu(this.playerMenuUtility).open();
                    return;
                }
                case "togglePreservationTypeButton": {
                    int currentMode = Arrays.asList(LootTable.VanillaLootPreservationType.values()).indexOf((Object)this.table.getVanillaLootPreservationType());
                    currentMode = e.getClick().isLeftClick() ? (currentMode + 1 >= LootTable.VanillaLootPreservationType.values().length ? 0 : ++currentMode) : (currentMode - 1 < 0 ? LootTable.VanillaLootPreservationType.values().length - 1 : --currentMode);
                    this.table.setVanillaLootPreservationType(LootTable.VanillaLootPreservationType.values()[currentMode]);
                    break;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this loot table?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    LootTableRegistry.getLootTables().remove(this.table.getKey());
                    new LootTableOverviewMenu(this.playerMenuUtility).open();
                    return;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                    break;
                }
                case "createNewButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    e.getWhoClicked().closeInventory();
                    Questionnaire questionnaire = new Questionnaire((Player)e.getWhoClicked(), null, null, new Question[]{new Question("&fWhat should the pool's key be? (type in chat, or 'cancel' to cancel)", s -> !this.table.getPools().containsKey(s), "&cPool with this key already exists! Try again")}){

                        @Override
                        public Action<Player> getOnFinish() {
                            if (this.getQuestions().isEmpty()) {
                                return super.getOnFinish();
                            }
                            Question question = this.getQuestions().get(0);
                            if (question.getAnswer() == null) {
                                return super.getOnFinish();
                            }
                            return p -> {
                                String answer = question.getAnswer().replaceAll(" ", "_").toLowerCase(Locale.US);
                                if (answer.contains("cancel")) {
                                    LootTableEditor.this.playerMenuUtility.getPreviousMenu().open();
                                } else if (LootTableEditor.this.table.getPools().containsKey(answer)) {
                                    Utils.sendMessage((CommandSender)this.getWho(), "&cPool key already exists!");
                                } else {
                                    LootPool pool = LootTableEditor.this.table.addPool(answer);
                                    new LootPoolEditor(LootTableEditor.this.playerMenuUtility, pool).open();
                                }
                            };
                        }
                    };
                    Questionnaire.startQuestionnaire((Player)e.getWhoClicked(), questionnaire);
                }
            }
        }
        if (!StringUtils.isEmpty(data = ItemUtils.getPDCString(BUTTON_DATA, clicked, null)) && (pool = this.table.getPools().get(data)) != null) {
            new LootPoolEditor(this.playerMenuUtility, pool).open();
            return;
        }
        if (4 == e.getRawSlot() && !ItemUtils.isEmpty(cursor)) {
            this.table.setIcon(cursor.getType());
            this.iconLabel.setType(cursor.getType());
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        this.inventory.setItem(4, this.iconLabel);
        ArrayList<LootPool> pools = new ArrayList<LootPool>(this.table.getPools().values());
        pools.sort(Comparator.comparing(LootPool::getKey));
        ArrayList<ItemStack> buttons = new ArrayList<ItemStack>();
        pools.forEach(p -> {
            ItemBuilder builder = new ItemBuilder(Material.BOOK).name("&6" + p.getKey()).stringTag(BUTTON_DATA, p.getKey());
            if (!p.getPredicates().isEmpty()) {
                builder.appendLore("&6" + (p.getPredicateSelection() == LootTable.PredicateSelection.ANY ? "Any" : "All") + "&e of the following conditions");
                builder.appendLore("&emust pass:");
                p.getPredicates().forEach(pr -> builder.appendLore(StringUtils.separateStringIntoLines("&f> " + pr.getActiveDescription(), 40)));
            }
            if (p.getEntries().isEmpty()) {
                builder.appendLore("&cPool has no drops");
            } else if (p.isWeighted()) {
                builder.appendLore(String.format("&6Can drop up to %d%s", p.getWeightedRolls(), p.getBonusLuckRolls() > 0.0 ? String.format("(+%.1f/luck)", p.getBonusLuckRolls()) : ""), String.format("&6items from a selection of %d", p.getEntries().size()));
            } else {
                builder.appendLore(String.format("&6Has %d potential chanced drops", p.getEntries().size()));
            }
            buttons.add(builder.get());
        });
        buttons.add(createNewButton);
        Map pages = Utils.paginate(poolIndexes.length, buttons);
        this.page = Math.max(1, Math.min(this.page, pages.size()));
        if (!pages.isEmpty()) {
            int index = 0;
            for (ItemStack i : pages.get(this.page - 1)) {
                this.inventory.setItem(poolIndexes[index], i);
                ++index;
            }
        }
        ItemBuilder itemBuilder = new ItemBuilder(togglePreservationTypeButton);
        this.inventory.setItem(10, itemBuilder.name("&eLoot Mode: " + (switch (this.table.getVanillaLootPreservationType()) {
            default -> throw new IncompatibleClassChangeError();
            case LootTable.VanillaLootPreservationType.KEEP -> "&fAdd to Vanilla";
            case LootTable.VanillaLootPreservationType.CLEAR -> "&fClear Vanilla";
            case LootTable.VanillaLootPreservationType.CLEAR_UNLESS_EMPTY -> "&fOverwrite Vanilla";
        })).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(53, backToMenuButton);
        this.inventory.setItem(16, poolDescriptionLabel);
        if (this.page < pages.size()) {
            this.inventory.setItem(35, nextPageButton);
        }
        if (this.page > 1) {
            this.inventory.setItem(27, previousPageButton);
        }
    }
}

