/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.implementations.LootTableSelectionMenu;
import me.athlaeos.valhallammo.gui.implementations.ReplacementTableSelectionMenu;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.BlockLootTables;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.BlockReplacementTables;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.ContainerLootTables;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.ContainerReplacementTables;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.EntityLootTables;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.EntityReplacementTables;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.FishingLootTable;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.FishingReplacementTable;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.GlobalReplacementTable;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.TableCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class LootTableOverviewMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    public static final NamespacedKey KEY_TABLE_CATEGORY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_table_category");
    public static final NamespacedKey KEY_TABLE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_table");
    public static final TableCategory BLOCKS_LOOT = new BlockLootTables(12);
    public static final TableCategory ENTITIES_LOOT = new EntityLootTables(21);
    public static final TableCategory CONTAINERS_LOOT = new ContainerLootTables(30);
    public static final TableCategory FISHING_LOOT = new FishingLootTable(39);
    public static final TableCategory GLOBAL_REPLACEMENT = new GlobalReplacementTable(5);
    public static final TableCategory BLOCKS_REPLACEMENT = new BlockReplacementTables(14);
    public static final TableCategory ENTITIES_REPLACEMENT = new EntityReplacementTables(23);
    public static final TableCategory CONTAINERS_REPLACEMENT = new ContainerReplacementTables(32);
    public static final TableCategory FISHING_REPLACEMENT = new FishingReplacementTable(41);
    private static final Map<String, TableCategory> categories = new HashMap<String, TableCategory>();
    private static final ItemStack filler;
    private static final ItemStack nextPageButton;
    private static final ItemStack previousPageButton;
    private static final ItemStack backToMenuButton;
    private static final ItemStack editLootTablesButton;
    private static final ItemStack editReplacementTablesButton;
    private int currentPage = 0;
    private TableCategory currentCategory = null;

    public static void registerCategory(TableCategory category) {
        categories.put(category.getId(), category);
    }

    public static Map<String, TableCategory> getCategories() {
        return new HashMap<String, TableCategory>(categories);
    }

    public LootTableOverviewMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    public LootTableOverviewMenu(PlayerMenuUtility playerMenuUtility, String category) {
        super(playerMenuUtility);
        this.currentCategory = categories.get(category);
    }

    @Override
    public String getMenuName() {
        return this.currentCategory == null ? Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf311\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_loottableoverview")) : Utils.chat(this.currentCategory.getTitle());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        String clickedCategory = ItemUtils.getPDCString(KEY_TABLE_CATEGORY, clickedItem, "");
        String clickedTable = ItemUtils.getPDCString(KEY_TABLE, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new LootTableOverviewMenu(this.playerMenuUtility).open();
                    return;
                }
                case "editLootTablesButton": {
                    new LootTableSelectionMenu(this.playerMenuUtility, this, null).open();
                    return;
                }
                case "editReplacementTablesButton": {
                    new ReplacementTableSelectionMenu(this.playerMenuUtility, this, null).open();
                    return;
                }
                case "nextPageButton": {
                    ++this.currentPage;
                    break;
                }
                case "previousPageButton": {
                    --this.currentPage;
                }
            }
        } else if (!StringUtils.isEmpty(clickedCategory)) {
            this.currentCategory = categories.get(clickedCategory);
            if (this.currentCategory != null) {
                if (this.currentCategory.getCategoryOptions().isEmpty()) {
                    this.currentCategory.onButtonClick(e, null, this);
                } else {
                    new LootTableOverviewMenu(this.playerMenuUtility, this.currentCategory.getId()).open();
                }
                return;
            }
        } else if (!StringUtils.isEmpty(clickedTable) && this.currentCategory != null) {
            this.currentCategory.onButtonClick(e, clickedTable, this);
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (this.currentCategory != null) {
            this.setPickOptionView();
        } else {
            this.setViewCategoriesView();
        }
    }

    private void setPickOptionView() {
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 45; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        List<ItemStack> recipes = this.currentCategory.getCategoryOptions();
        Map<Integer, List<ItemStack>> pages = Utils.paginate(45, recipes);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            pages.get(this.currentPage - 1).forEach(xva$0 -> this.inventory.addItem(new ItemStack[]{xva$0}));
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(49, backToMenuButton);
        this.inventory.setItem(53, nextPageButton);
    }

    private void setViewCategoriesView() {
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        for (TableCategory category : categories.values()) {
            this.inventory.setItem(category.getPosition(), new ItemBuilder(category.getIcon()).stringTag(KEY_TABLE_CATEGORY, category.getId()).get());
        }
        this.inventory.setItem(48, editLootTablesButton);
        this.inventory.setItem(50, editReplacementTablesButton);
    }

    static {
        LootTableOverviewMenu.registerCategory(BLOCKS_LOOT);
        LootTableOverviewMenu.registerCategory(ENTITIES_LOOT);
        LootTableOverviewMenu.registerCategory(CONTAINERS_LOOT);
        LootTableOverviewMenu.registerCategory(FISHING_LOOT);
        LootTableOverviewMenu.registerCategory(GLOBAL_REPLACEMENT);
        LootTableOverviewMenu.registerCategory(BLOCKS_REPLACEMENT);
        LootTableOverviewMenu.registerCategory(ENTITIES_REPLACEMENT);
        LootTableOverviewMenu.registerCategory(CONTAINERS_REPLACEMENT);
        LootTableOverviewMenu.registerCategory(FISHING_REPLACEMENT);
        filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
        nextPageButton = new ItemBuilder(LootTableOverviewMenu.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(KEY_ACTION, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        previousPageButton = new ItemBuilder(LootTableOverviewMenu.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(KEY_ACTION, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        backToMenuButton = new ItemBuilder(LootTableOverviewMenu.getButtonData("editor_backtomenu", Material.BOOK)).name("&fBack to Menu").stringTag(KEY_ACTION, "backToMenuButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        editLootTablesButton = new ItemBuilder(LootTableOverviewMenu.getButtonData("editor_loottable_edit", Material.BOOK)).name("&fEdit Loot Tables").stringTag(KEY_ACTION, "editLootTablesButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
        editReplacementTablesButton = new ItemBuilder(LootTableOverviewMenu.getButtonData("editor_replacementtable_edit", Material.KNOWLEDGE_BOOK)).name("&fEdit Replacement Tables").stringTag(KEY_ACTION, "editReplacementTablesButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    }
}

