/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOptionRegistry;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetRecipeOptionMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class RecipeOptionMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    public static final NamespacedKey KEY_OPTION_ID = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_option_id");
    private static final ItemStack cancelButton = new ItemBuilder(Material.BARRIER).stringTag(KEY_ACTION, "cancelButton").name("&fCancel").get();
    private static final ItemStack nextPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "nextPageButton").name("&7&lNext page").get();
    private static final ItemStack previousPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "previousPageButton").name("&7&lPrevious page").get();
    private final Menu menu;
    private int currentPage = 0;
    private RecipeOption currentOption = null;

    public RecipeOptionMenu(PlayerMenuUtility playerMenuUtility, Menu menu) {
        super(playerMenuUtility);
        this.menu = menu;
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf302\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_ingredientoptionselection"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String clickedOption;
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "nextPageButton": {
                    ++this.currentPage;
                    break;
                }
                case "previousPageButton": {
                    --this.currentPage;
                    break;
                }
                case "cancelButton": {
                    Menu menu;
                    if (this.currentOption != null && (menu = this.menu) instanceof SetRecipeOptionMenu) {
                        SetRecipeOptionMenu m = (SetRecipeOptionMenu)((Object)menu);
                        m.setRecipeOption(null);
                    }
                    this.menu.open();
                    this.menu.setMenuItems();
                    return;
                }
            }
        }
        if (!StringUtils.isEmpty(clickedOption = ItemUtils.getPDCString(KEY_OPTION_ID, clickedItem, null))) {
            e.setCancelled(true);
            this.currentOption = this.playerMenuUtility.getOptions().getOrDefault(clickedOption, RecipeOptionRegistry.createOption(clickedOption));
            this.currentOption.onClick(e);
            if (!e.isCancelled()) {
                Menu menu = this.menu;
                if (menu instanceof SetRecipeOptionMenu) {
                    SetRecipeOptionMenu m = (SetRecipeOptionMenu)((Object)menu);
                    m.setRecipeOption(this.currentOption.getNew());
                }
                this.menu.open();
                this.menu.setMenuItems();
                return;
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, null);
        }
        Map<String, RecipeOption> options = RecipeOptionRegistry.getOptions();
        ArrayList<ItemStack> totalOptionButtons = new ArrayList<ItemStack>();
        for (String optionName : options.keySet()) {
            RecipeOption option = this.playerMenuUtility.getOptions().getOrDefault(optionName, options.get(optionName));
            if (option == null) continue;
            option = option.getNew();
            ItemStack icon = new ItemBuilder(option.getIcon()).stringTag(KEY_OPTION_ID, option.getName()).get();
            totalOptionButtons.add(icon);
        }
        totalOptionButtons.sort(Comparator.comparing(ItemStack::getType));
        Map pages = Utils.paginate(45, totalOptionButtons);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            for (ItemStack i : pages.get(this.currentPage - 1)) {
                this.inventory.addItem(new ItemStack[]{i});
            }
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(49, cancelButton);
        this.inventory.setItem(53, nextPageButton);
    }
}

