/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.RecipeOption;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.SlotEntry;
import me.athlaeos.valhallammo.crafting.ingredientconfiguration.implementations.MaterialChoice;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetLootPredicatesMenu;
import me.athlaeos.valhallammo.gui.SetRecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.LootPredicateMenu;
import me.athlaeos.valhallammo.gui.implementations.RecipeOptionMenu;
import me.athlaeos.valhallammo.gui.implementations.ReplacementEntryEditor;
import me.athlaeos.valhallammo.gui.implementations.ReplacementTableEditor;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementEntry;
import me.athlaeos.valhallammo.loot.ReplacementPool;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ReplacementPoolEditor
extends Menu
implements SetLootPredicatesMenu,
SetRecipeOptionMenu {
    private static final NamespacedKey BUTTON_ACTION_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_action");
    private static final NamespacedKey BUTTON_DATA = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "button_data");
    private static final int predicatesIndex = 1;
    private static final int predicateTypeIndex = 2;
    private static final int replacementItemIndex = 4;
    private static final int optionIndex = 5;
    private static final int previousPageIndex = 27;
    private static final int nextPageIndex = 35;
    private static final int deleteIndex = 45;
    private static final int backToMenuIndex = 53;
    private static final int[] entryIndexes = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private final ReplacementTable table;
    private final ReplacementPool pool;
    private boolean tinker = false;
    private static final ItemStack togglePredicateModeButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_loottable_predicatemode", Material.COMPARATOR)).name("&eFilter Mode").stringTag(BUTTON_ACTION_KEY, "togglePredicateModeButton").lore("&7Determines to what extent filters", "&7should pass.", "&7Should all filters pass", "&7or should any filter pass?", "&eClick to toggle").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack predicatesButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_loottable_pool_predicates", Material.HOPPER)).name("&bFilter").stringTag(BUTTON_ACTION_KEY, "predicatesButton").lore("&7The filter decides if this pool", "&7is capable of dropping anything", "&7based on conditions.", "&eClick to open the menu", "&8&m                <>                ", "%predicates%").get();
    private static final ItemStack recipeOptionsButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_recipe_cooking_recipeoptions", Material.WRITABLE_BOOK)).name("&bMatcher Options").stringTag(BUTTON_ACTION_KEY, "recipeOptionsButton").lore("&7Matcher options are item matching", "&7conditions. Only items matching the", "&7selected condition will be used for", "&7replacement.", "&eClick to open the menu").get();
    private static final ItemStack nextPageButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(BUTTON_ACTION_KEY, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(BUTTON_ACTION_KEY, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack deleteButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_delete", Material.BARRIER)).stringTag(BUTTON_ACTION_KEY, "deleteButton").name("&cDelete Recipe").get();
    private static final ItemStack deleteConfirmButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_deleteconfirm", Material.BARRIER)).name("&cDelete Recipe").stringTag(BUTTON_ACTION_KEY, "deleteConfirmButton").enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1).lore("&aRight-click &7to confirm recipe deletion").flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
    private static final ItemStack backToMenuButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_backtomenu", Material.BOOK)).stringTag(BUTTON_ACTION_KEY, "backToMenuButton").name("&fBack to Menu").get();
    private static final ItemStack createNewButton = new ItemBuilder(ReplacementPoolEditor.getButtonData("editor_loottable_newentry", Material.LIME_DYE)).name("&b&lNew Entry").stringTag(BUTTON_ACTION_KEY, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private boolean confirmDeletion = false;
    private int page = 0;

    public ReplacementPoolEditor(PlayerMenuUtility playerMenuUtility, ReplacementPool pool) {
        super(playerMenuUtility);
        this.pool = pool;
        this.table = LootTableRegistry.getReplacementTables().get(pool.getParentTable());
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf313\uf80c\uf80a\uf808\uf802&8%pool%" : TranslationManager.getTranslation("editormenu_lootpool")).replace("%pool%", this.table.getKey());
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        ReplacementEntry entry;
        String data;
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        if (this.table == null) {
            Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cLoot Table has already been deleted");
            e.getWhoClicked().closeInventory();
            return;
        }
        ItemStack clicked = e.getCurrentItem();
        String action = ItemUtils.getPDCString(BUTTON_ACTION_KEY, clicked, "");
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "backToMenuButton": {
                    new ReplacementTableEditor(this.playerMenuUtility, this.table).open();
                    LootTableRegistry.resetReplacementTableCache();
                    return;
                }
                case "togglePredicateModeButton": {
                    int currentMode = Arrays.asList(LootTable.PredicateSelection.values()).indexOf((Object)this.pool.getPredicateSelection());
                    currentMode = e.getClick().isLeftClick() ? (currentMode + 1 >= LootTable.PredicateSelection.values().length ? 0 : ++currentMode) : (currentMode - 1 < 0 ? LootTable.PredicateSelection.values().length - 1 : --currentMode);
                    this.pool.setPredicateSelection(LootTable.PredicateSelection.values()[currentMode]);
                    break;
                }
                case "recipeOptionsButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new RecipeOptionMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "predicatesButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    new LootPredicateMenu(this.playerMenuUtility, this).open();
                    return;
                }
                case "deleteButton": {
                    this.confirmDeletion = true;
                    Utils.sendMessage((CommandSender)e.getWhoClicked(), "&cAre you sure you want to delete this loot pool?");
                    this.setMenuItems();
                    return;
                }
                case "deleteConfirmButton": {
                    if (!e.isRightClick()) break;
                    this.table.getReplacementPools().remove(this.pool.getKey());
                    new ReplacementTableEditor(this.playerMenuUtility, this.table).open();
                    LootTableRegistry.resetReplacementTableCache();
                    return;
                }
                case "nextPageButton": {
                    ++this.page;
                    break;
                }
                case "previousPageButton": {
                    this.page = Math.max(0, this.page - 1);
                    break;
                }
                case "tinkerToggleButton": {
                    this.tinker = !this.tinker;
                    break;
                }
                case "createNewButton": {
                    this.playerMenuUtility.setPreviousMenu(this);
                    ReplacementEntry entry2 = this.pool.addEntry(ItemUtils.isEmpty(e.getCursor()) ? new ItemBuilder(Material.GOLD_INGOT).name("&eReplace me!").lore("&fI'm just a placeholder drop!").get() : e.getCursor().clone());
                    new ReplacementEntryEditor(this.playerMenuUtility, this.pool, entry2).open();
                    LootTableRegistry.resetReplacementTableCache();
                }
            }
        }
        if (4 == e.getRawSlot()) {
            if (!ItemUtils.isEmpty(e.getCursor())) {
                this.pool.setToReplace(new SlotEntry(new ItemBuilder(e.getCursor().clone()).amount(1).get(), new MaterialChoice()));
            } else if (this.pool.getToReplace() != null) {
                this.pool.getToReplace().setOption(null);
            }
        }
        if (!StringUtils.isEmpty(data = ItemUtils.getPDCString(BUTTON_DATA, clicked, null)) && (entry = this.pool.getEntries().get(UUID.fromString(data))) != null) {
            new ReplacementEntryEditor(this.playerMenuUtility, this.pool, entry).open();
            return;
        }
        this.confirmDeletion = false;
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        e.setCancelled(true);
        if (e.getRawSlots().size() == 1) {
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 0; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        ArrayList<ReplacementEntry> entries = new ArrayList<ReplacementEntry>(this.pool.getEntries().values());
        entries.sort(Comparator.comparing(ReplacementEntry::getWeight));
        ArrayList<ItemStack> buttons = new ArrayList<ItemStack>();
        entries.forEach(p -> {
            ItemBuilder builder = new ItemBuilder(p.tinker() ? this.pool.getToReplace().getItem() : p.getReplaceBy()).stringTag(BUTTON_DATA, p.getUuid().toString());
            builder.name("&e" + (String)(p.tinker() ? "Tinkered " + this.pool.getToReplace().getOption().ingredientDescription(this.pool.getToReplace().getItem()) : ItemUtils.getItemName(new ItemBuilder(p.getReplaceBy()))));
            if (!p.getPredicates().isEmpty()) {
                builder.appendLore("&6" + (p.getPredicateSelection() == LootTable.PredicateSelection.ANY ? "Any" : "All") + "&e of the following conditions");
                builder.appendLore("&emust pass:");
                p.getPredicates().forEach(pr -> builder.appendLore(StringUtils.separateStringIntoLines("&f> " + pr.getActiveDescription(), 40)));
            }
            double combinedWeight = this.pool.getEntries().values().stream().mapToDouble(ReplacementEntry::getWeight).sum();
            builder.appendLore("&eEntry weight: " + p.getWeight() + (p.getWeightBonusLooting() > 0.0 ? String.format(" (+%.1f/fortune)", p.getWeightBonusLooting()) : "") + (p.getWeightBonusLuck() > 0.0 ? String.format(" (+%.1f/luck)", p.getWeightBonusLuck()) : ""), "&6With a combined weight of " + combinedWeight, String.format("&6this entry has a %.1f%% chance", p.getWeight() / combinedWeight * 100.0), "&6of dropping per roll (ignoring luck)");
            buttons.add(builder.get());
        });
        buttons.add(createNewButton);
        Map pages = Utils.paginate(entryIndexes.length, buttons);
        this.page = Math.max(1, Math.min(this.page, pages.size()));
        if (!pages.isEmpty()) {
            int index = 0;
            for (ItemStack i : pages.get(this.page - 1)) {
                this.inventory.setItem(entryIndexes[index], i);
                ++index;
            }
        }
        ArrayList<String> predicateLore = new ArrayList<String>();
        this.pool.getPredicates().forEach(p -> predicateLore.addAll(StringUtils.separateStringIntoLines("&d> " + p.getActiveDescription(), 40)));
        ItemBuilder predicateIcon = new ItemBuilder(predicatesButton).placeholderLore("%predicates%", predicateLore);
        ItemBuilder itemBuilder = new ItemBuilder(togglePredicateModeButton);
        this.inventory.setItem(2, itemBuilder.name("&eFilter Mode: " + (switch (this.pool.getPredicateSelection()) {
            default -> throw new IncompatibleClassChangeError();
            case LootTable.PredicateSelection.ALL -> "&aALL conditions must pass";
            case LootTable.PredicateSelection.ANY -> "&aANY condition must pass";
        })).get());
        this.inventory.setItem(45, this.confirmDeletion ? deleteConfirmButton : deleteButton);
        this.inventory.setItem(53, backToMenuButton);
        this.inventory.setItem(1, predicateIcon.get());
        this.inventory.setItem(5, recipeOptionsButton);
        ItemStack icon = new ItemBuilder(this.pool.getToReplace().getItem().clone()).appendLore(SlotEntry.getOptionLore(this.pool.getToReplace())).get();
        this.inventory.setItem(4, icon);
        if (this.page < pages.size()) {
            this.inventory.setItem(35, nextPageButton);
        }
        if (this.page > 1) {
            this.inventory.setItem(27, previousPageButton);
        }
    }

    @Override
    public void setPredicates(Collection<LootPredicate> predicates) {
    }

    @Override
    public Collection<LootPredicate> getPredicates() {
        return this.pool.getPredicates();
    }

    @Override
    public void setRecipeOption(RecipeOption option) {
        if (option == null) {
            return;
        }
        if (!option.isCompatible(this.pool.getToReplace().getItem()) || !option.isCompatibleWithInputItem(true)) {
            Utils.sendMessage((CommandSender)this.playerMenuUtility.getOwner(), "&cNot compatible with this item");
        } else {
            this.pool.getToReplace().setOption(option);
        }
    }
}

