/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.placeholder.PlaceholderRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.PowerProfile;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpense;
import me.athlaeos.valhallammo.skills.perkresourcecost.ResourceExpenseRegistry;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockCondition;
import me.athlaeos.valhallammo.skills.perkunlockconditions.UnlockConditionRegistry;
import me.athlaeos.valhallammo.skills.skills.Perk;
import me.athlaeos.valhallammo.skills.skills.PerkConnectionIcon;
import me.athlaeos.valhallammo.skills.skills.PerkRegistry;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import me.athlaeos.valhallammo.skills.skills.implementations.PowerSkill;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SkillTreeMenu
extends Menu {
    private static final NamespacedKey buttonKey = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "valhalla_button_id");
    private static final Map<Skill, List<List<List<Perk>>>> skillTrees = new HashMap<Skill, List<List<List<Perk>>>>();
    private static final Map<Skill, Pair<Integer, Integer>> coordinateOffsets = new HashMap<Skill, Pair<Integer, Integer>>();
    private final Player target;
    private final List<ItemStack> skillIcons = new ArrayList<ItemStack>();
    private Skill selectedSkill;
    private final Map<Skill, ItemStack[][]> skillTreeItems = new HashMap<Skill, ItemStack[][]>();
    private int x;
    private int y;
    private static final ItemStack directionN;
    private static final ItemStack directionNE;
    private static final ItemStack directionE;
    private static final ItemStack directionSE;
    private static final ItemStack directionS;
    private static final ItemStack directionSW;
    private static final ItemStack directionW;
    private static final ItemStack directionNW;
    private final String perk_requirement_warning_levels = TranslationManager.getTranslation("perk_requirement_warning_levels");
    private final String perk_requirement_status_unlockable = TranslationManager.getTranslation("perk_requirement_status_unlockable");
    private final String perk_requirement_status_unlocked = TranslationManager.getTranslation("perk_requirement_status_unlocked");
    private final String perk_requirement_status_permanently_locked = TranslationManager.getTranslation("perk_requirement_status_permanently_locked");
    private final String perk_requirement_status_fake_unlocked = TranslationManager.getTranslation("perk_requirement_status_fake_unlocked");
    private String perkConfirmation = null;

    public SkillTreeMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
        this.selectedSkill = SkillRegistry.getSkill(PowerSkill.class);
        this.x = this.selectedSkill.getCenterX() + 4;
        this.y = this.selectedSkill.getCenterY() + 2;
        this.target = playerMenuUtility.getOwner();
        this.buildSkillTrees();
    }

    public SkillTreeMenu(PlayerMenuUtility playerMenuUtility, Player target) {
        super(playerMenuUtility);
        this.selectedSkill = SkillRegistry.getSkill(PowerSkill.class);
        this.x = this.selectedSkill.getCenterX() + 4;
        this.y = this.selectedSkill.getCenterY() + 2;
        this.target = target;
        this.buildSkillTrees();
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf001" : TranslationManager.getTranslation("skilltree"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        e.setCancelled(true);
        ItemStack i = e.getCurrentItem();
        if (!ItemUtils.isEmpty(i)) {
            ItemMeta meta = ItemUtils.getItemMeta(i);
            if (meta == null) {
                this.setMenuItems();
                return;
            }
            int x2 = this.x;
            int y2 = this.y;
            int s = e.getSlot();
            if (this.selectedSkill.isNavigable()) {
                if ((s == 0 || s == 4 || s == 8) && this.y - 1 >= 2) {
                    --this.y;
                }
                if ((s == 36 || s == 40 || s == 44) && this.y + 3 < this.currentSkillTreeHeight()) {
                    ++this.y;
                }
                if ((s == 0 || s == 18 || s == 36) && this.x - 1 >= 4) {
                    --this.x;
                }
                if ((s == 8 || s == 26 || s == 44) && this.x + 5 < this.currentSkillTreeWidth()) {
                    ++this.x;
                }
                if (this.x != x2 || this.y != y2) {
                    this.setMenuItems();
                    this.perkConfirmation = null;
                    return;
                }
            }
            if (meta.getPersistentDataContainer().has(buttonKey, PersistentDataType.STRING)) {
                String id = (String)meta.getPersistentDataContainer().get(buttonKey, PersistentDataType.STRING);
                if (s >= 45) {
                    Skill selectedSkill = SkillRegistry.getSkill(id);
                    if (selectedSkill != null) {
                        this.selectedSkill = selectedSkill;
                        this.x = selectedSkill.getCenterX() + 4;
                        this.y = selectedSkill.getCenterY() + 2;
                    }
                } else {
                    if (this.selectedSkill == null) {
                        this.setMenuItems();
                        return;
                    }
                    Perk p = PerkRegistry.getPerk(id);
                    if (p != null) {
                        if (p.hasUnlocked(this.target)) {
                            for (String message : p.getMessages()) {
                                for (PerkReward reward : p.getRewards()) {
                                    if (message == null) continue;
                                    message = message.replace("{" + reward.getName() + "}", reward.rewardPlaceholder());
                                }
                                this.target.sendMessage(Utils.chat(message));
                            }
                        } else if (p.canUnlock(this.target)) {
                            if (this.perkConfirmation != null && this.perkConfirmation.equals(p.getName())) {
                                this.perkConfirmation = null;
                                PowerProfile account = ProfileRegistry.getPersistentProfile(this.target, PowerProfile.class);
                                Collection<String> perks = account.getUnlockedPerks();
                                perks.addAll(account.getPermanentlyUnlockedPerks());
                                perks.add(p.getName());
                                account.setUnlockedPerks(perks);
                                ProfileRegistry.setPersistentProfile(this.target, account, PowerProfile.class);
                                p.execute(this.target);
                                for (ResourceExpense expense : p.getExpenses()) {
                                    expense.purchase(this.target, true);
                                }
                                ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), this::setMenuItems, 2L);
                            } else {
                                this.perkConfirmation = p.getName();
                            }
                        } else {
                            for (ResourceExpense expense : p.getExpenses()) {
                                if (expense.canPurchase(this.target)) continue;
                                Utils.sendMessage((CommandSender)this.playerMenuUtility.getOwner(), expense.getInsufficientFundsMessage());
                            }
                        }
                        this.skillTreeItems.put(this.selectedSkill, this.getSkillTree(this.selectedSkill));
                    }
                }
            } else {
                this.perkConfirmation = null;
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
    }

    private int currentSkillTreeHeight() {
        return this.skillTreeItems.get(this.selectedSkill).length;
    }

    private int currentSkillTreeWidth() {
        return this.skillTreeItems.get(this.selectedSkill)[0].length;
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        this.setScrollBar();
        if (this.selectedSkill != null && this.skillTreeItems.containsKey(this.selectedSkill)) {
            ItemStack[][] treeView = this.getSkillTreeView(this.selectedSkill);
            if (!ArrayUtils.isEmpty((Object[])treeView)) {
                int index = 0;
                if (treeView.length >= 5) {
                    for (int r = 0; r < 5; ++r) {
                        ItemStack[] row = treeView[r];
                        if (row.length < 9) continue;
                        for (int i = 0; i < 9; ++i) {
                            if (row[i] != null) {
                                this.inventory.setItem(index, row[i]);
                            }
                            ++index;
                        }
                    }
                }
            }
            if (this.selectedSkill.isNavigable()) {
                this.inventory.setItem(0, directionNW);
                this.inventory.setItem(4, directionN);
                this.inventory.setItem(8, directionNE);
                this.inventory.setItem(18, directionW);
                this.inventory.setItem(26, directionE);
                this.inventory.setItem(36, directionSW);
                this.inventory.setItem(40, directionS);
                this.inventory.setItem(44, directionSE);
            }
        }
    }

    private void setScrollBar() {
        ItemMeta meta;
        ArrayList<ItemStack> icons = new ArrayList<ItemStack>(this.skillIcons);
        int iconsSize = icons.size();
        for (ItemStack i : this.skillIcons) {
            Skill s;
            String storedType;
            if (ItemUtils.isEmpty(i) || (meta = ItemUtils.getItemMeta(i)) == null || (storedType = this.getItemStoredSkillType(meta)) == null || (s = SkillRegistry.getSkill(storedType)) == null) continue;
            PowerProfile acc = ProfileCache.getOrCache(this.target, PowerProfile.class);
            meta.setDisplayName(Utils.chat(s.getDisplayName() + (acc.getNewGamePlus() > 0 ? TranslationManager.getTranslation("prestige_level_format").replace("%prestige_roman%", StringUtils.toRoman(acc.getNewGamePlus()).replace("%prestige_numeric%", String.valueOf(acc.getNewGamePlus()))) : "")));
            Profile p = ProfileRegistry.getPersistentProfile(this.target, s.getProfileType());
            double expRequired = s.expForLevel(p.getLevel() + 1);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : TranslationManager.getListTranslation("skilltree_icon_format")) {
                lore.add(Utils.chat(line.replace("%level_current%", "" + p.getLevel()).replace("%exp_current%", String.format("%.2f", p.getEXP())).replace("%exp_next%", expRequired < 0.0 ? TranslationManager.getTranslation("max_level") : String.format("%.2f", expRequired)).replace("%exp_total%", String.format("%.2f", p.getTotalEXP())).replace("%prestigepoints%", String.valueOf(acc.getSpendablePrestigePoints() - acc.getSpentPrestigePoints())).replace("%skillpoints%", String.valueOf(acc.getSpendableSkillPoints() - acc.getSpentSkillPoints()))));
            }
            meta.setLore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE, ItemFlag.HIDE_ENCHANTS});
            meta.setAttributeModifiers(null);
            ItemUtils.setMetaNoClone(i, meta);
        }
        if (iconsSize > 0) {
            for (int i = 0; i < SkillRegistry.getAllSkills().size(); ++i) {
                for (int o = 0; o < 9 && o < this.skillIcons.size(); ++o) {
                    ItemStack iconToPut = this.skillIcons.get(o);
                    this.inventory.setItem(45 + o, iconToPut);
                }
                ItemStack centerItem = this.inventory.getItem(49);
                if (centerItem != null) {
                    meta = ItemUtils.getItemMeta(centerItem);
                    if (meta == null) continue;
                    String stored = this.getItemStoredSkillType(meta);
                    if (stored != null && stored.equals(this.selectedSkill.getType())) break;
                }
                Collections.rotate(this.skillIcons, 1);
            }
        }
    }

    private String getItemStoredSkillType(ItemMeta meta) {
        return (String)meta.getPersistentDataContainer().get(buttonKey, PersistentDataType.STRING);
    }

    private ItemStack[][] getSkillTree(Skill skill) {
        ItemStack[][] skillTree;
        if (skill == null || !skillTrees.containsKey(skill)) {
            return null;
        }
        List<List<List<Perk>>> perks = skillTrees.get(skill);
        if (perks.isEmpty() || perks.get(0).isEmpty()) {
            return null;
        }
        for (Object[] objectArray : skillTree = new ItemStack[perks.size()][perks.get(0).size()]) {
            Arrays.fill(objectArray, null);
        }
        for (int r = 0; r < perks.size(); ++r) {
            List<List<Perk>> row = perks.get(r);
            if (row == null) continue;
            for (int c = 0; c < row.size(); ++c) {
                List<Perk> list = row.get(c);
                if (list == null) continue;
                for (Perk p : list) {
                    int data;
                    Pair<Integer, Integer> offsets = coordinateOffsets.get(skill);
                    if (p == null || !p.shouldBeVisible(this.target) || offsets == null || p.getPermissionRequirement() != null && !this.playerMenuUtility.getOwner().hasPermission(p.getPermissionRequirement())) continue;
                    ItemBuilder icon = new ItemBuilder(p.getIcon()).name(this.perkConfirmation != null && this.perkConfirmation.equals(p.getName()) ? TranslationManager.getTranslation("skilltree_perk_confirmation").replace("%perk%", p.getDisplayName()) : p.getDisplayName()).flag(ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE, ItemFlag.HIDE_ENCHANTS).wipeAttributes().stringTag(buttonKey, p.getName());
                    int unlockedStatus = p.hasPermanentlyLocked(this.target) ? 2 : (p.hasFakeUnlocked(this.target) ? 3 : (p.hasUnlocked(this.target) ? 1 : 0));
                    ArrayList<String> lore = new ArrayList<String>();
                    block9: for (String l : TranslationManager.getListTranslation("skilltree_perk_format")) {
                        ResourceExpense expense;
                        Iterator<Object> status;
                        if (l.contains("%description%")) {
                            String description = p.getDescription();
                            for (PerkReward reward : p.getRewards()) {
                                description = description.replace("{" + reward.getName() + "}", reward.rewardPlaceholder());
                            }
                            lore.addAll(Utils.chat(StringUtils.separateStringIntoLines(description, 40)));
                            continue;
                        }
                        if (l.contains("%warning_levels%")) {
                            if (unlockedStatus != 0 || p.metLevelRequirement(this.target) || StringUtils.isEmpty(this.perk_requirement_warning_levels)) continue;
                            lore.add(Utils.chat(this.perk_requirement_warning_levels));
                            continue;
                        }
                        if (l.contains("%status_unlocked%")) {
                            if (StringUtils.isEmpty((String)((Object)(status = (switch (unlockedStatus) {
                                case 1 -> this.perk_requirement_status_unlocked;
                                case 2 -> this.perk_requirement_status_permanently_locked;
                                case 3 -> this.perk_requirement_status_fake_unlocked;
                                default -> null;
                            }))))) continue;
                            lore.add(Utils.chat((String)((Object)status)));
                            continue;
                        }
                        if (l.contains("%warning_cost%")) {
                            if (unlockedStatus != 0 || p.metResourceRequirements(this.target)) continue;
                            status = p.getExpenses().iterator();
                            while (status.hasNext()) {
                                expense = (ResourceExpense)status.next();
                                if (expense.canPurchase(this.target)) continue;
                                lore.add(Utils.chat(expense.getInsufficientFundsMessage()));
                            }
                            continue;
                        }
                        if (l.contains("%status_unlockable%")) {
                            if (unlockedStatus != 0 || !p.canUnlock(this.target) || StringUtils.isEmpty(this.perk_requirement_status_unlockable)) continue;
                            lore.add(Utils.chat(this.perk_requirement_status_unlockable));
                            continue;
                        }
                        if (l.contains("%cost%")) {
                            if (unlockedStatus != 0) continue;
                            status = p.getExpenses().iterator();
                            while (status.hasNext()) {
                                expense = (ResourceExpense)status.next();
                                lore.add(Utils.chat(expense.getCostMessage()));
                            }
                            continue;
                        }
                        status = UnlockConditionRegistry.getConditionsSet().iterator();
                        while (status.hasNext()) {
                            UnlockCondition perkCondition;
                            UnlockCondition condition = (UnlockCondition)status.next();
                            if (!l.contains("%" + condition.getValuePlaceholder() + "%") && !l.contains("%" + condition.getFailurePlaceholder() + "%")) continue;
                            if (unlockedStatus != 0 || !p.getMappedConditions().containsKey(condition.getClass()) || (perkCondition = p.getMappedConditions().get(condition.getClass())) == null) continue block9;
                            if (l.contains("%" + condition.getValuePlaceholder() + "%")) {
                                lore.addAll(Utils.chat(perkCondition.getConditionMessages()));
                            }
                            if (!l.contains("%" + condition.getFailurePlaceholder() + "%") || p.metConditionRequirements(this.target, false) || StringUtils.isEmpty(perkCondition.getFailedConditionMessage())) continue block9;
                            lore.add(Utils.chat(perkCondition.getFailedConditionMessage()));
                            continue block9;
                        }
                        status = ResourceExpenseRegistry.getExpenses().values().iterator();
                        while (status.hasNext()) {
                            ResourceExpense perkExpense;
                            expense = (ResourceExpense)status.next();
                            if (!l.contains(expense.getCostPlaceholder()) && !l.contains(expense.getInsufficientCostPlaceholder())) continue;
                            if (unlockedStatus != 0 || !p.getMappedExpenses().containsKey(expense.getClass()) || (perkExpense = p.getMappedExpenses().get(expense.getClass())) == null) continue block9;
                            if (l.contains(expense.getCostPlaceholder()) && !StringUtils.isEmpty(perkExpense.getCostMessage())) {
                                lore.addAll(StringUtils.separateStringIntoLines(Utils.chat(perkExpense.getCostMessage()), 40));
                            }
                            if (!l.contains(expense.getInsufficientCostPlaceholder()) || perkExpense.canPurchase(this.target) || StringUtils.isEmpty(perkExpense.getInsufficientFundsMessage())) continue block9;
                            lore.add(Utils.chat(expense.getInsufficientFundsMessage()));
                            continue block9;
                        }
                        lore.add(Utils.chat(PlaceholderRegistry.parsePapi(PlaceholderRegistry.parse(l.replace("%level_required%", String.valueOf(p.getLevelRequirement())).replace("%skill%", p.getSkill().getDisplayName()), this.target), this.target)));
                    }
                    icon.lore(lore);
                    icon.flag(ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE, ItemFlag.HIDE_ENCHANTS);
                    icon.wipeAttributes();
                    boolean unlocked = p.hasUnlocked(this.target);
                    boolean unlockable = p.canUnlock(this.target);
                    int n = unlocked ? p.getCustomModelDataUnlocked() : (data = unlockable ? p.getCustomModelDataUnlockable() : p.getCustomModelDataVisible());
                    if (data > 0) {
                        icon.data(data);
                    }
                    int xOff = offsets.getOne();
                    int yOff = offsets.getTwo();
                    skillTree[r][c] = icon.get();
                    for (PerkConnectionIcon i : p.getConnectionLine()) {
                        ItemStack line;
                        int d;
                        int n2 = unlocked ? i.getUnlockedData() : (d = unlockable ? i.getUnlockableData() : i.getLockedData());
                        Material m = unlocked ? i.getUnlockedMaterial() : (unlockable ? i.getUnlockableMaterial() : i.getLockedMaterial());
                        skillTree[i.getY() + 2 + yOff][i.getX() + 4 + xOff] = line = new ItemBuilder(m).data(d).name("&r").get();
                    }
                }
            }
        }
        return skillTree;
    }

    private ItemStack[][] getSkillTreeView(Skill skill) {
        ItemStack[][] view = new ItemStack[5][9];
        ItemStack[][] fullSkillTree = this.skillTreeItems.get(skill);
        int x = Math.max(4, Math.min(fullSkillTree[0].length - 1, this.x + coordinateOffsets.get(skill).getOne()));
        int y = Math.max(2, Math.min(fullSkillTree.length - 1, this.y + coordinateOffsets.get(skill).getTwo()));
        ItemStack[][] skillTreeYSection = (ItemStack[][])Arrays.copyOfRange(fullSkillTree, y - 2, y + 3);
        for (int i = 0; i < skillTreeYSection.length; ++i) {
            ItemStack[] row = skillTreeYSection[i];
            if (row == null) continue;
            ItemStack[] nineWideRow = Arrays.copyOfRange(row, x - 4, x + 5);
            view[i] = nineWideRow;
        }
        return view;
    }

    private void buildSkillTrees() {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> {
            ArrayList<Skill> skills = new ArrayList<Skill>(SkillRegistry.getAllSkills().values());
            skills.sort(Comparator.comparingInt(Skill::getSkillTreeMenuOrderPriority));
            for (Skill s : skills) {
                if (!s.isLevelableSkill() || s.getRequiredPermission() != null && !this.playerMenuUtility.getOwner().hasPermission(s.getRequiredPermission())) continue;
                ItemStack skillIcon = new ItemBuilder(s.getIcon()).name(s.getDisplayName()).lore(StringUtils.separateStringIntoLines(Utils.chat(s.getDescription()), 40)).flag(ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE, ItemFlag.HIDE_ENCHANTS).wipeAttributes().stringTag(buttonKey, s.getType()).get();
                this.skillIcons.add(skillIcon);
                this.skillTreeItems.put(s, this.getSkillTree(s));
            }
            for (int i = 0; i < 9 && this.skillIcons.size() < 9; ++i) {
                this.skillIcons.addAll(new ArrayList<ItemStack>(this.skillIcons));
            }
            this.setMenuItems();
        });
    }

    public static void updateSkillTree(Skill skill) {
        if (!skill.isLevelableSkill()) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int offsetX = 0;
        int offsetY = 0;
        boolean initialized = false;
        for (Perk perk : skill.getPerks()) {
            minX = Math.min(perk.getX(), minX);
            maxX = Math.max(perk.getX(), maxX);
            minY = Math.min(perk.getY(), minY);
            maxY = Math.max(perk.getY(), maxY);
            initialized = true;
            for (PerkConnectionIcon line : perk.getConnectionLine()) {
                minX = Math.min(line.getX(), minX);
                maxX = Math.max(line.getX(), maxX);
                minY = Math.min(line.getY(), minY);
                maxY = Math.max(line.getY(), maxY);
            }
        }
        if (!initialized) {
            coordinateOffsets.put(skill, new Pair<Integer, Integer>(0, 0));
            ArrayList perks = new ArrayList();
            for (int i = 0; i < 5; ++i) {
                ArrayList<Object> rows = new ArrayList<Object>();
                for (int o = 0; o < 9; ++o) {
                    rows.add(null);
                }
                perks.add(rows);
            }
            skillTrees.put(skill, perks);
            return;
        }
        if (minX != 0) {
            offsetX = -minX;
        }
        if (minY != 0) {
            offsetY = -minY;
        }
        coordinateOffsets.put(skill, new Pair<Integer, Integer>(offsetX, offsetY));
        int width = Math.max(9, maxX + offsetX - (minX + offsetX)) + 8;
        int height = Math.max(5, maxY + offsetY - (minY + offsetY)) + 4;
        ArrayList perks = new ArrayList();
        for (int i = 0; i <= height; ++i) {
            ArrayList<Object> rows = new ArrayList<Object>();
            for (int o = 0; o < width; ++o) {
                rows.add(null);
            }
            perks.add(rows);
        }
        for (Perk perk : skill.getPerks()) {
            ArrayList<Perk> perksAtSpot = (ArrayList<Perk>)((List)perks.get(perk.getY() + 2 + offsetY)).get(perk.getX() + 4 + offsetX);
            if (perksAtSpot == null) {
                perksAtSpot = new ArrayList<Perk>();
            }
            perksAtSpot.add(perk);
            if (perksAtSpot.size() > 1) {
                perksAtSpot.sort(Comparator.comparingInt(Perk::getLevelRequirement));
            }
            ((List)perks.get(perk.getY() + 2 + offsetY)).set(perk.getX() + 4 + offsetX, perksAtSpot);
        }
        skillTrees.put(skill, perks);
    }

    public static void updateSkillTrees() {
        skillTrees.clear();
        coordinateOffsets.clear();
        for (Skill skill : SkillRegistry.getAllSkills().values()) {
            SkillTreeMenu.updateSkillTree(skill);
        }
    }

    static {
        SkillTreeMenu.updateSkillTrees();
        directionN = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_n", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_n")).get();
        directionNE = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_ne", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_ne")).get();
        directionE = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_e", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_e")).get();
        directionSE = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_se", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_se")).get();
        directionS = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_s", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_s")).get();
        directionSW = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_sw", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_sw")).get();
        directionW = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_w", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_w")).get();
        directionNW = new ItemBuilder(SkillTreeMenu.getButtonData("skilltree_direction_nw", Material.ARROW)).name(TranslationManager.getTranslation("skilltree_arrow_name_nw")).get();
    }
}

