/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetStatsMenu;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.item.item_attributes.AttributeWrapper;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class StatSelectionMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    private static final NamespacedKey KEY_ATTRIBUTE_ID = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_attribute_id");
    private static final ItemStack confirmButton = new ItemBuilder(Material.STRUCTURE_VOID).stringTag(KEY_ACTION, "confirmButton").name("&b&lSave").get();
    private static final ItemStack createNewButton = new ItemBuilder(StatSelectionMenu.getButtonData("editor_newrecipe", Material.LIME_DYE)).name("&b&lAdd Stat").stringTag(KEY_ACTION, "createNewButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack cancelButton = new ItemBuilder(Material.BARRIER).stringTag(KEY_ACTION, "cancelButton").name("&cDelete").get();
    private static final ItemStack nextPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "nextPageButton").name("&7&lNext page").get();
    private static final ItemStack previousPageButton = new ItemBuilder(Material.ARROW).stringTag(KEY_ACTION, "previousPageButton").name("&7&lPrevious page").get();
    private static final ItemStack valueButton = new ItemBuilder(Material.GOLDEN_SWORD).stringTag(KEY_ACTION, "valueButton").name("&fValue: &e").get();
    private final Menu menu;
    private View view = View.VIEW_STATS;
    private int currentPage = 0;
    private final Map<String, Double> currentAttributes;
    private String currentAttribute = null;
    private double value = 0.0;

    public StatSelectionMenu(PlayerMenuUtility playerMenuUtility, Menu menu) {
        super(playerMenuUtility);
        this.menu = menu;
        if (menu instanceof SetStatsMenu) {
            SetStatsMenu m = (SetStatsMenu)((Object)menu);
            this.currentAttributes = m.getStats();
        } else {
            this.currentAttributes = new HashMap<String, Double>();
        }
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf314\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_statselection"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String clickedAttribute;
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "confirmButton": {
                    Menu menu;
                    if (this.view == View.NEW_STAT) {
                        if (this.currentAttribute == null) break;
                        this.currentAttributes.put(this.currentAttribute, this.value);
                        this.currentAttribute = null;
                        this.value = 0.0;
                        this.view = View.VIEW_STATS;
                        break;
                    }
                    if (this.view == View.PICK_STAT) {
                        this.view = View.VIEW_STATS;
                        break;
                    }
                    if (this.view != View.VIEW_STATS || !((menu = this.menu) instanceof SetStatsMenu)) break;
                    SetStatsMenu m = (SetStatsMenu)((Object)menu);
                    m.setStats(this.currentAttributes);
                    this.menu.open();
                    break;
                }
                case "createNewButton": {
                    this.view = View.PICK_STAT;
                    break;
                }
                case "nextPageButton": {
                    ++this.currentPage;
                    break;
                }
                case "previousPageButton": {
                    --this.currentPage;
                    break;
                }
                case "cancelButton": {
                    if (this.currentAttribute == null) break;
                    if (this.currentAttributes.containsKey(this.currentAttribute)) {
                        this.view = View.VIEW_STATS;
                        this.currentAttributes.remove(this.currentAttribute);
                        break;
                    }
                    this.view = View.PICK_STAT;
                    break;
                }
                case "valueButton": {
                    AttributeWrapper wrapper = ItemAttributesRegistry.getCopy(this.currentAttribute);
                    if (wrapper == null) break;
                    this.value += (double)(e.isRightClick() ? -1 : 1) * (e.isShiftClick() ? wrapper.getBigIncrement() : wrapper.getSmallIncrement());
                }
            }
        }
        if (!StringUtils.isEmpty(clickedAttribute = ItemUtils.getPDCString(KEY_ATTRIBUTE_ID, clickedItem, null))) {
            if (this.view == View.PICK_STAT) {
                this.currentAttribute = clickedAttribute;
                this.view = View.NEW_STAT;
            } else if (this.view == View.VIEW_STATS) {
                for (String stat : this.currentAttributes.keySet()) {
                    if (!stat.equals(clickedAttribute)) continue;
                    this.currentAttribute = stat;
                    this.value = this.currentAttributes.get(stat);
                    this.view = View.NEW_STAT;
                    break;
                }
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        switch (this.view.ordinal()) {
            case 1: {
                this.setViewStatsView();
                break;
            }
            case 0: {
                this.setPickStatsView();
                break;
            }
            case 2: {
                this.setNewStatView();
            }
        }
    }

    private void setNewStatView() {
        AttributeWrapper wrapper;
        if (this.currentAttribute != null && (wrapper = ItemAttributesRegistry.getCopy(this.currentAttribute)) != null) {
            wrapper.setValue(this.value);
            this.inventory.setItem(22, new ItemBuilder(valueButton).name("&fSet to: &e" + wrapper.getFormat().format(this.value)).lore("&7Click to increase/decrease by " + wrapper.getFormat().format(wrapper.getSmallIncrement()), "&7Shift-Click to do so by " + wrapper.getFormat().format(wrapper.getBigIncrement())).get());
        }
        this.inventory.setItem(53, confirmButton);
        this.inventory.setItem(45, cancelButton);
    }

    private void setPickStatsView() {
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, null);
        }
        Map<String, AttributeWrapper> stats = ItemAttributesRegistry.getRegisteredAttributes();
        Set<String> currentStringStats = this.currentAttributes.keySet();
        ArrayList<AttributeWrapper> sortedStats = new ArrayList<AttributeWrapper>(stats.values());
        sortedStats.sort(Comparator.comparing(AttributeWrapper::getAttribute));
        ArrayList<ItemStack> totalStatButtons = new ArrayList<ItemStack>();
        for (AttributeWrapper stat : sortedStats) {
            if (currentStringStats.contains(stat.getAttribute()) || stat.getAttributeName() == null) continue;
            ItemStack icon = new ItemBuilder(stat.getIcon() == null ? Material.NAME_TAG : stat.getIcon()).name("&f" + stat.getAttributeName().replace("%icon%", "").replace("%value%", "").trim()).flag(ItemFlag.HIDE_DYE, ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_ENCHANTS).wipeAttributes().stringTag(KEY_ATTRIBUTE_ID, stat.getAttribute()).get();
            totalStatButtons.add(icon);
        }
        Map pages = Utils.paginate(45, totalStatButtons);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            for (ItemStack i : pages.get(this.currentPage - 1)) {
                this.inventory.addItem(new ItemStack[]{i});
            }
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(53, nextPageButton);
        this.inventory.setItem(49, confirmButton);
    }

    private void setViewStatsView() {
        for (int i = 0; i < 45; ++i) {
            this.inventory.setItem(i, null);
        }
        List stats = this.currentAttributes.keySet().stream().limit(45L).toList();
        for (String stat : stats) {
            AttributeWrapper wrapper = ItemAttributesRegistry.getCopy(stat);
            if (wrapper == null || wrapper.getAttributeName() == null) continue;
            wrapper.setValue(this.currentAttributes.get(stat));
            ItemStack icon = new ItemBuilder(wrapper.getIcon() == null ? Material.NAME_TAG : wrapper.getIcon()).lore(wrapper.getLoreDisplay()).name("&f" + wrapper.getAttributeName().replace("%icon%", "").replace("%value%", "").trim()).stringTag(KEY_ATTRIBUTE_ID, wrapper.getAttribute()).flag(ItemFlag.HIDE_DYE, ItemFlag.HIDE_ATTRIBUTES, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_ENCHANTS).wipeAttributes().get();
            this.inventory.addItem(new ItemStack[]{icon});
        }
        if (this.currentAttributes.size() <= 44) {
            this.inventory.addItem(new ItemStack[]{createNewButton});
        }
        this.inventory.setItem(49, confirmButton);
    }

    private static enum View {
        PICK_STAT,
        VIEW_STATS,
        NEW_STAT;

    }
}

