/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.crafting.blockvalidations.Validation;
import me.athlaeos.valhallammo.crafting.blockvalidations.ValidationRegistry;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtility;
import me.athlaeos.valhallammo.gui.SetValidationsMenu;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.ConventionUtils;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ValidationSelectionMenu
extends Menu {
    private static final NamespacedKey KEY_ACTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_action");
    public static final NamespacedKey KEY_VALIDATION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "key_validation");
    private final Menu menu;
    private final Material targetBlock;
    private Collection<String> currentValidations = new HashSet<String>();
    private static final ItemStack filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).name("&r").get();
    private static final ItemStack nextPageButton = new ItemBuilder(ValidationSelectionMenu.getButtonData("editor_nextpage", Material.ARROW)).name("&7&lNext page").stringTag(KEY_ACTION, "nextPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack previousPageButton = new ItemBuilder(ValidationSelectionMenu.getButtonData("editor_prevpage", Material.ARROW)).name("&7&lPrevious page").stringTag(KEY_ACTION, "previousPageButton").flag(ItemFlag.HIDE_ATTRIBUTES).wipeAttributes().get();
    private static final ItemStack cancelButton = new ItemBuilder(ValidationSelectionMenu.getButtonData("editor_validation_selection_return", Material.BOOK)).stringTag(KEY_ACTION, "cancelButton").name("&7Return to menu without saving").get();
    private static final ItemStack confirmButton = new ItemBuilder(ValidationSelectionMenu.getButtonData("editor_validation_selection_save", Material.STRUCTURE_VOID)).name("&aConfirm").stringTag(KEY_ACTION, "confirmButton").lore("&aRight-click &7to save changes").get();
    private int currentPage = 0;

    public ValidationSelectionMenu(PlayerMenuUtility playerMenuUtility, Menu menu, Material block) {
        super(playerMenuUtility);
        this.menu = menu;
        this.targetBlock = block;
        if (menu instanceof SetValidationsMenu) {
            SetValidationsMenu m = (SetValidationsMenu)((Object)menu);
            this.currentValidations = m.getValidations();
        }
    }

    @Override
    public String getMenuName() {
        return Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf30f\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_validationselection"));
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String clickedValidation;
        ItemStack clickedItem = e.getCurrentItem();
        if (ItemUtils.isEmpty(clickedItem)) {
            return;
        }
        e.setCancelled(!(e.getClickedInventory() instanceof PlayerInventory));
        String action = ItemUtils.getPDCString(KEY_ACTION, clickedItem, null);
        if (!StringUtils.isEmpty(action)) {
            switch (action) {
                case "confirmButton": {
                    Menu menu = this.menu;
                    if (!(menu instanceof SetValidationsMenu)) break;
                    SetValidationsMenu m = (SetValidationsMenu)((Object)menu);
                    m.setValidations(this.currentValidations);
                    this.menu.open();
                    return;
                }
                case "cancelButton": {
                    this.menu.open();
                    break;
                }
                case "nextPageButton": {
                    ++this.currentPage;
                    break;
                }
                case "previousPageButton": {
                    --this.currentPage;
                }
            }
        }
        if (!StringUtils.isEmpty(clickedValidation = ItemUtils.getPDCString(KEY_VALIDATION, clickedItem, null))) {
            if (this.currentValidations.contains(clickedValidation)) {
                this.currentValidations.remove(clickedValidation);
            } else {
                this.currentValidations.add(clickedValidation);
            }
        }
        this.setMenuItems();
    }

    @Override
    public void handleMenu(InventoryDragEvent e) {
        if (e.getRawSlots().size() == 1) {
            e.setCancelled(true);
            ClickType type = e.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction action = e.getType() == DragType.EVEN ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
            this.handleMenu(new InventoryClickEvent(e.getView(), InventoryType.SlotType.CONTAINER, ((Integer)new ArrayList(e.getRawSlots()).get(0)).intValue(), type, action));
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        if (!ValhallaMMO.getPluginConfig().getBoolean("admin_gui_filler_removal")) {
            for (int i = 45; i < 54; ++i) {
                this.inventory.setItem(i, filler);
            }
        }
        ArrayList<ItemStack> icons = new ArrayList<ItemStack>();
        for (Validation validation : ValidationRegistry.getValidations()) {
            if (this.targetBlock != null && !validation.isCompatible(this.targetBlock)) continue;
            ItemBuilder builder = new ItemBuilder(validation.icon()).flag(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ConventionUtils.getHidePotionEffectsFlag(), ItemFlag.HIDE_DYE).wipeAttributes().stringTag(KEY_VALIDATION, validation.id());
            if (this.currentValidations.contains(validation.id())) {
                builder.appendLore("&8&m                <>                ", "&2[&aEnabled&2]");
                builder.enchant(EnchantmentMappings.UNBREAKING.getEnchantment(), 1);
            } else {
                builder.appendLore("&8&m                <>                ", "&4[&cDisabled&4]");
            }
            icons.add(builder.get());
        }
        icons.sort(Comparator.comparing(ItemStack::getType).thenComparing(item -> ChatColor.stripColor((String)ItemUtils.getItemName(new ItemBuilder((ItemStack)item)))));
        Map pages = Utils.paginate(45, icons);
        this.currentPage = Math.max(1, Math.min(this.currentPage, pages.size()));
        if (!pages.isEmpty()) {
            pages.get(this.currentPage - 1).forEach(xva$0 -> this.inventory.addItem(new ItemStack[]{xva$0}));
        }
        this.inventory.setItem(45, previousPageButton);
        this.inventory.setItem(47, cancelButton);
        this.inventory.setItem(51, confirmButton);
        this.inventory.setItem(53, nextPageButton);
    }
}

