/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.gui.implementations.loottablecategories;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.gui.Menu;
import me.athlaeos.valhallammo.gui.PlayerMenuUtilManager;
import me.athlaeos.valhallammo.gui.implementations.LootTableOverviewMenu;
import me.athlaeos.valhallammo.gui.implementations.LootTableSelectionMenu;
import me.athlaeos.valhallammo.gui.implementations.loottablecategories.TableCategory;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class BlockLootTables
extends TableCategory {
    public BlockLootTables(int position) {
        super("loot_table_blocks", new ItemBuilder(Material.STONE).name("&eBlock Loot Tables").lore("&fLoot tables assigned to blocks, ", "&fdropped when broken.").get(), position, Utils.chat(ValhallaMMO.isResourcePackConfigForced() ? "&f\uf808\uf315\uf80c\uf80a\uf808\uf802" : TranslationManager.getTranslation("editormenu_blocktables")));
    }

    @Override
    public List<ItemStack> getCategoryOptions() {
        ArrayList<ItemBuilder> buttons = new ArrayList<ItemBuilder>();
        for (Material m : Material.values()) {
            if (!m.isBlock() || m.isAir()) continue;
            LootTable typeTable = LootTableRegistry.getLootTable(m);
            ItemBuilder builder = new ItemBuilder(m.isItem() ? m : Material.BARRIER).name((typeTable != null ? "&a" : "&c") + String.valueOf(m)).stringTag(LootTableOverviewMenu.KEY_TABLE, m.toString());
            if (typeTable == null) {
                builder.lore("&cNo loot table set");
            } else {
                builder.lore("&aHas loot table: " + typeTable.getKey());
            }
            builder.appendLore("&fClick to set new loot table", "&fShift-Click to remove loot table");
            buttons.add(builder);
        }
        buttons.sort(Comparator.comparing(ItemUtils::getItemName));
        return buttons.stream().map(ItemBuilder::get).collect(Collectors.toList());
    }

    @Override
    public void onButtonClick(InventoryClickEvent e, String storedValue, Menu openedFrom) {
        if (StringUtils.isEmpty(storedValue)) {
            return;
        }
        Material m = Catch.catchOrElse(() -> Material.valueOf((String)storedValue), null);
        if (m == null) {
            return;
        }
        if (!e.isShiftClick()) {
            new LootTableSelectionMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()), openedFrom, table -> {
                LootTableRegistry.getBlockLootTables().put(m.toString(), table.getKey());
                new LootTableOverviewMenu(PlayerMenuUtilManager.getPlayerMenuUtility((Player)e.getWhoClicked()), LootTableOverviewMenu.BLOCKS_LOOT.getId()).open();
            }).open();
        } else {
            LootTableRegistry.getBlockLootTables().remove(m.toString());
        }
    }
}

