/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Scaling;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AlchemyItemPropertyManager {
    private static final NamespacedKey NUMBER_TAGS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "alchemy_treatments");
    private static final NamespacedKey QUALITY_ALCHEMY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "quality_alchemy");
    private static final Map<Integer, String> qualityLore = new TreeMap<Integer, String>();
    private static final Map<Integer, String> tagLore = new HashMap<Integer, String>();
    private static final Map<Integer, String> tagRequiredErrors = new HashMap<Integer, String>();
    private static final Map<Integer, String> tagForbiddenErrors = new HashMap<Integer, String>();
    private static double qualityRoundingPrecision = 10.0;

    public static Map<Integer, String> getTagRequiredErrors() {
        return tagRequiredErrors;
    }

    public static Map<Integer, String> getTagLore() {
        return tagLore;
    }

    public static String getTagLore(Integer i) {
        return tagLore.get(i);
    }

    public static Map<Integer, String> getTagForbiddenErrors() {
        return tagForbiddenErrors;
    }

    public static void loadConfig() {
        ConfigurationSection tagRequiredSection;
        ConfigurationSection tagForbiddenSection;
        ConfigurationSection tagSection;
        YamlConfiguration config = ConfigManager.getConfig("skills/alchemy.yml").get();
        qualityRoundingPrecision = config.getDouble("quality_rounding_precision", 10.0);
        ConfigurationSection qualitySection = config.getConfigurationSection("quality_lore");
        if (qualitySection != null) {
            for (Object r : qualitySection.getKeys(false)) {
                try {
                    int rating = Integer.parseInt((String)r);
                    String lore = TranslationManager.translatePlaceholders(config.getString("quality_lore." + (String)r));
                    if (lore == null) continue;
                    qualityLore.put(rating, Utils.chat(lore));
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid quality rating in skills/alchemy.yml: quality_lore." + (String)r + " is not a number");
                }
            }
        }
        if ((tagSection = config.getConfigurationSection("tag_lore")) != null) {
            for (String r : tagSection.getKeys(false)) {
                try {
                    int tag = Integer.parseInt(r);
                    String lore = TranslationManager.translatePlaceholders(config.getString("tag_lore." + r));
                    if (lore == null) continue;
                    tagLore.put(tag, Utils.chat(lore));
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid number tag in skills/alchemy.yml: tag_lore." + r + " is not a number");
                }
            }
        }
        if ((tagForbiddenSection = config.getConfigurationSection("tag_error_disallowed")) != null) {
            for (String r : tagForbiddenSection.getKeys(false)) {
                try {
                    int tag = Integer.parseInt(r);
                    String lore = TranslationManager.translatePlaceholders(config.getString("tag_error_disallowed." + r));
                    if (lore == null) continue;
                    tagForbiddenErrors.put(tag, Utils.chat(lore));
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid number tag in skills/alchemy.yml: tag_error_disallowed." + r + " is not a number");
                }
            }
        }
        if ((tagRequiredSection = config.getConfigurationSection("tag_error_required")) != null) {
            for (String r : tagRequiredSection.getKeys(false)) {
                try {
                    int tag = Integer.parseInt(r);
                    String lore = TranslationManager.translatePlaceholders(config.getString("tag_error_required." + r));
                    if (lore == null) continue;
                    tagRequiredErrors.put(tag, Utils.chat(lore));
                }
                catch (IllegalArgumentException ignored) {
                    ValhallaMMO.logWarning("Invalid number tag in skills/alchemy.yml: tag_error_required." + r + " is not a number");
                }
            }
        }
    }

    public static boolean hasTag(ItemMeta i, int treatment) {
        return AlchemyItemPropertyManager.getTags(i).contains(treatment);
    }

    public static Collection<Integer> getTags(ItemMeta i) {
        HashSet<Integer> tags = new HashSet<Integer>();
        String value = ItemUtils.getPDCString(NUMBER_TAGS, i, null);
        if (StringUtils.isEmpty(value)) {
            return tags;
        }
        for (String tag : value.split(",")) {
            try {
                tags.add(Integer.parseInt(tag));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return tags;
    }

    public static void setTagLore(ItemBuilder item) {
        if (item == null) {
            return;
        }
        ArrayList currentLore = item.getLore() != null ? item.getLore() : new ArrayList();
        ArrayList<String> newLore = new ArrayList<String>();
        int tagIndex = -1;
        for (String l : currentLore) {
            if (tagLore.containsValue(l)) {
                if (tagIndex >= 0) continue;
                tagIndex = currentLore.indexOf(l);
                continue;
            }
            newLore.add(l);
        }
        Collection<Object> tags = CustomFlag.hasFlag(item.getMeta(), CustomFlag.HIDE_TAGS) ? new HashSet() : AlchemyItemPropertyManager.getTags(item.getMeta());
        for (Integer tag : tags.stream().filter(tagLore::containsKey).collect(Collectors.toSet())) {
            if (tagIndex <= 0) {
                newLore.add(tagLore.get(tag));
                continue;
            }
            newLore.add(tagIndex, tagLore.get(tag));
        }
        item.lore(newLore);
    }

    public static void addTag(ItemBuilder i, Integer ... tag) {
        Collection<Integer> tags = AlchemyItemPropertyManager.getTags(i.getMeta());
        tags.addAll(Set.of(tag));
        AlchemyItemPropertyManager.setTags(i, tags);
    }

    public static void removeTag(ItemBuilder i, Integer ... tag) {
        Collection<Integer> tags = AlchemyItemPropertyManager.getTags(i.getMeta());
        tags.removeAll(Set.of(tag));
        AlchemyItemPropertyManager.setTags(i, tags);
    }

    public static void setQualityLore(ItemBuilder item) {
        if (item == null) {
            return;
        }
        ArrayList currentLore = item.getLore() != null ? item.getLore() : new ArrayList();
        ArrayList<String> newLore = new ArrayList<String>();
        int tagIndex = -1;
        for (String l : currentLore) {
            if (qualityLore.containsValue(l)) {
                if (tagIndex >= 0) continue;
                tagIndex = currentLore.indexOf(l);
                continue;
            }
            newLore.add(l);
        }
        String qualityLore = AlchemyItemPropertyManager.getQualityLore(AlchemyItemPropertyManager.getQuality(item.getMeta()));
        if (qualityLore == null || CustomFlag.hasFlag(item.getMeta(), CustomFlag.HIDE_QUALITY)) {
            return;
        }
        if (newLore.isEmpty() || tagIndex < 0) {
            newLore.add(qualityLore);
        } else {
            newLore.add(tagIndex, qualityLore);
        }
        item.lore(newLore);
    }

    public static String getQualityLore(int quality) {
        String lore = null;
        for (int q : qualityLore.keySet()) {
            if (q > quality) continue;
            lore = qualityLore.get(q);
        }
        return lore;
    }

    public static int getQuality(ItemMeta i) {
        return ItemUtils.getPDCInt(QUALITY_ALCHEMY, i, 0);
    }

    public static boolean hasAlchemyQuality(ItemMeta meta) {
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(QUALITY_ALCHEMY, PersistentDataType.INTEGER);
    }

    public static void setTags(ItemBuilder item, Collection<Integer> tags) {
        if (item == null) {
            return;
        }
        if (tags == null || tags.isEmpty()) {
            item.getMeta().getPersistentDataContainer().remove(NUMBER_TAGS);
        } else {
            item.stringTag(NUMBER_TAGS, tags.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        AlchemyItemPropertyManager.setTagLore(item);
    }

    public static void setQuality(ItemBuilder item, Integer quality) {
        if (item == null) {
            return;
        }
        if (quality == null) {
            item.getMeta().getPersistentDataContainer().remove(QUALITY_ALCHEMY);
        } else {
            item.intTag(QUALITY_ALCHEMY, (int)Math.round(Utils.roundToMultiple(quality.intValue(), qualityRoundingPrecision)));
        }
        AlchemyItemPropertyManager.setQualityLore(item);
    }

    public static void applyAttributeScaling(ItemBuilder i, Scaling scaling, int quality, boolean duration, double minimumAmplifierFraction, double minimumDurationFraction) {
        Map<String, PotionEffectWrapper> defaultWrappers = PotionEffectRegistry.getStoredEffects(i.getMeta(), true);
        Map<String, PotionEffectWrapper> actualWrappers = PotionEffectRegistry.getStoredEffects(i.getMeta(), false);
        HashMap<String, PotionEffectWrapper> newWrappers = new HashMap<String, PotionEffectWrapper>();
        for (PotionEffectWrapper wrapper : defaultWrappers.values()) {
            PotionEffectWrapper actual = actualWrappers.get(wrapper.getEffect());
            if (actual == null) continue;
            double defaultStat = duration ? (double)wrapper.getDuration() : wrapper.getAmplifier();
            double minimum = defaultStat * (duration ? minimumDurationFraction : minimumAmplifierFraction);
            if (!duration && wrapper.isVanilla()) {
                minimum = (1.0 + defaultStat) * minimum - 1.0;
            }
            double result = Utils.round6Decimals(scaling.evaluate(scaling.getExpression().replace("%rating%", String.valueOf(quality)), defaultStat));
            result = Math.max(minimum, result);
            if (duration) {
                actual.setDuration((int)result);
            } else {
                actual.setAmplifier(wrapper.isVanilla() ? (double)((int)result) : result);
            }
            newWrappers.put(actual.getEffect(), actual);
        }
        PotionEffectRegistry.setActualStoredEffects(i, newWrappers);
    }
}

