/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.HashMap;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.item.FoodClass;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FoodPropertyManager {
    private static final Map<Material, FoodProperties> defaultProperties = new HashMap<Material, FoodProperties>();
    private static final NamespacedKey FOOD_CLASS;
    private static final NamespacedKey FOOD_VALUE;
    private static final NamespacedKey SATURATION_VALUE;
    private static final NamespacedKey CANCEL_POTION_EFFECTS;
    private static final NamespacedKey CANCEL_DIMINISHING_RETURNS;

    private static void setDefaultProperties(Material m, FoodClass type, int foodValue, float saturationValue) {
        defaultProperties.put(m, new FoodProperties(type, foodValue, saturationValue));
    }

    public static boolean isCustomFood(ItemMeta meta) {
        PersistentDataContainer c = meta.getPersistentDataContainer();
        return c.has(FOOD_CLASS, PersistentDataType.STRING) || c.has(FOOD_VALUE, PersistentDataType.INTEGER) || c.has(SATURATION_VALUE, PersistentDataType.DOUBLE) || c.has(CANCEL_POTION_EFFECTS, PersistentDataType.SHORT) || c.has(CANCEL_DIMINISHING_RETURNS, PersistentDataType.SHORT);
    }

    public static boolean shouldCancelDiminishingReturns(ItemMeta meta) {
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(CANCEL_DIMINISHING_RETURNS, PersistentDataType.SHORT);
    }

    public static void setCancelDiminishingReturns(ItemMeta meta, boolean cancel) {
        if (meta == null) {
            return;
        }
        if (!cancel) {
            meta.getPersistentDataContainer().remove(CANCEL_DIMINISHING_RETURNS);
        } else {
            meta.getPersistentDataContainer().set(CANCEL_DIMINISHING_RETURNS, PersistentDataType.SHORT, (Object)1);
        }
    }

    public static boolean shouldCancelDefaultPotionEffects(ItemMeta meta) {
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(CANCEL_POTION_EFFECTS, PersistentDataType.SHORT);
    }

    public static void setCancelPotionEffects(ItemMeta meta, boolean cancel) {
        if (meta == null) {
            return;
        }
        if (!cancel) {
            meta.getPersistentDataContainer().remove(CANCEL_POTION_EFFECTS);
        } else {
            meta.getPersistentDataContainer().set(CANCEL_POTION_EFFECTS, PersistentDataType.SHORT, (Object)1);
        }
    }

    public static float getSaturationValue(ItemStack i, ItemMeta meta) {
        if (meta == null) {
            return 0.0f;
        }
        FoodProperties properties = defaultProperties.get(i.getType());
        float defaultSaturation = properties == null ? 0.0f : properties.saturation;
        return ((Float)meta.getPersistentDataContainer().getOrDefault(SATURATION_VALUE, PersistentDataType.FLOAT, (Object)Float.valueOf(defaultSaturation))).floatValue();
    }

    public static void setSaturationValue(ItemMeta meta, Float foodValue) {
        if (meta == null) {
            return;
        }
        if (foodValue == null) {
            meta.getPersistentDataContainer().remove(FOOD_VALUE);
        } else {
            meta.getPersistentDataContainer().set(SATURATION_VALUE, PersistentDataType.FLOAT, (Object)foodValue);
        }
    }

    public static int getFoodValue(ItemStack i, ItemMeta meta) {
        if (meta == null) {
            return 0;
        }
        FoodProperties properties = defaultProperties.get(i.getType());
        int defaultFood = properties == null ? 0 : properties.food;
        return (Integer)meta.getPersistentDataContainer().getOrDefault(FOOD_VALUE, PersistentDataType.INTEGER, (Object)defaultFood);
    }

    public static void setFoodValue(ItemMeta meta, Integer foodValue) {
        if (meta == null) {
            return;
        }
        if (foodValue == null) {
            meta.getPersistentDataContainer().remove(FOOD_VALUE);
        } else {
            meta.getPersistentDataContainer().set(FOOD_VALUE, PersistentDataType.INTEGER, (Object)foodValue);
        }
    }

    public static FoodClass getFoodClass(ItemStack i, ItemMeta meta) {
        FoodProperties properties;
        if (meta == null) {
            return null;
        }
        String value = ItemUtils.getPDCString(FOOD_CLASS, meta, null);
        if (value != null) {
            try {
                return FoodClass.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return (properties = defaultProperties.get(i.getType())) == null ? null : properties.type;
    }

    public static void setFoodClass(ItemMeta meta, FoodClass foodClass) {
        if (meta == null) {
            return;
        }
        if (foodClass == null) {
            meta.getPersistentDataContainer().remove(FOOD_CLASS);
        } else {
            meta.getPersistentDataContainer().set(FOOD_CLASS, PersistentDataType.STRING, (Object)foodClass.toString());
        }
    }

    static {
        FoodPropertyManager.setDefaultProperties(Material.ENCHANTED_GOLDEN_APPLE, FoodClass.MAGICAL, 4, 9.6f);
        FoodPropertyManager.setDefaultProperties(Material.GOLDEN_APPLE, FoodClass.MAGICAL, 4, 9.6f);
        FoodPropertyManager.setDefaultProperties(Material.GOLDEN_CARROT, FoodClass.MAGICAL, 6, 14.4f);
        FoodPropertyManager.setDefaultProperties(Material.COOKED_CHICKEN, FoodClass.MEAT, 6, 7.2f);
        FoodPropertyManager.setDefaultProperties(Material.CHICKEN, FoodClass.MEAT, 2, 1.2f);
        FoodPropertyManager.setDefaultProperties(Material.COOKED_MUTTON, FoodClass.MEAT, 6, 9.6f);
        FoodPropertyManager.setDefaultProperties(Material.MUTTON, FoodClass.MEAT, 2, 1.2f);
        FoodPropertyManager.setDefaultProperties(Material.COOKED_PORKCHOP, FoodClass.MEAT, 8, 12.8f);
        FoodPropertyManager.setDefaultProperties(Material.PORKCHOP, FoodClass.MEAT, 3, 1.8f);
        FoodPropertyManager.setDefaultProperties(Material.COOKED_RABBIT, FoodClass.MEAT, 5, 6.0f);
        FoodPropertyManager.setDefaultProperties(Material.RABBIT, FoodClass.MEAT, 3, 1.8f);
        FoodPropertyManager.setDefaultProperties(Material.COOKED_BEEF, FoodClass.MEAT, 8, 12.8f);
        FoodPropertyManager.setDefaultProperties(Material.BEEF, FoodClass.MEAT, 3, 1.8f);
        FoodPropertyManager.setDefaultProperties(Material.RABBIT_STEW, FoodClass.MEAT, 10, 12.0f);
        FoodPropertyManager.setDefaultProperties(Material.SALMON, FoodClass.SEAFOOD, 2, 0.4f);
        FoodPropertyManager.setDefaultProperties(Material.COOKED_SALMON, FoodClass.SEAFOOD, 6, 9.6f);
        FoodPropertyManager.setDefaultProperties(Material.COD, FoodClass.SEAFOOD, 2, 0.4f);
        FoodPropertyManager.setDefaultProperties(Material.COOKED_COD, FoodClass.SEAFOOD, 5, 6.0f);
        FoodPropertyManager.setDefaultProperties(Material.TROPICAL_FISH, FoodClass.SEAFOOD, 1, 0.2f);
        FoodPropertyManager.setDefaultProperties(Material.BAKED_POTATO, FoodClass.VEGETABLE, 5, 6.0f);
        FoodPropertyManager.setDefaultProperties(Material.BEETROOT, FoodClass.VEGETABLE, 1, 1.2f);
        FoodPropertyManager.setDefaultProperties(Material.BEETROOT_SOUP, FoodClass.VEGETABLE, 6, 7.2f);
        FoodPropertyManager.setDefaultProperties(Material.CARROT, FoodClass.VEGETABLE, 3, 3.6f);
        FoodPropertyManager.setDefaultProperties(Material.DRIED_KELP, FoodClass.VEGETABLE, 1, 0.6f);
        FoodPropertyManager.setDefaultProperties(Material.MUSHROOM_STEW, FoodClass.VEGETABLE, 6, 7.2f);
        FoodPropertyManager.setDefaultProperties(Material.POTATO, FoodClass.VEGETABLE, 1, 0.6f);
        FoodPropertyManager.setDefaultProperties(Material.SUSPICIOUS_STEW, FoodClass.VEGETABLE, 6, 7.2f);
        FoodPropertyManager.setDefaultProperties(Material.BREAD, FoodClass.GRAIN, 5, 6.0f);
        FoodPropertyManager.setDefaultProperties(Material.CAKE, FoodClass.SWEET, 14, 2.8f);
        FoodPropertyManager.setDefaultProperties(Material.COOKIE, FoodClass.SWEET, 2, 0.4f);
        FoodPropertyManager.setDefaultProperties(Material.HONEY_BOTTLE, FoodClass.SWEET, 6, 1.2f);
        FoodPropertyManager.setDefaultProperties(Material.PUMPKIN_PIE, FoodClass.SWEET, 8, 4.8f);
        FoodPropertyManager.setDefaultProperties(Material.POISONOUS_POTATO, FoodClass.SPOILED, 2, 1.2f);
        FoodPropertyManager.setDefaultProperties(Material.PUFFERFISH, FoodClass.SPOILED, 1, 0.2f);
        FoodPropertyManager.setDefaultProperties(Material.ROTTEN_FLESH, FoodClass.SPOILED, 4, 0.8f);
        FoodPropertyManager.setDefaultProperties(Material.SPIDER_EYE, FoodClass.SPOILED, 2, 3.2f);
        FoodPropertyManager.setDefaultProperties(Material.APPLE, FoodClass.FRUIT, 4, 2.4f);
        FoodPropertyManager.setDefaultProperties(Material.CHORUS_FRUIT, FoodClass.FRUIT, 4, 2.4f);
        FoodPropertyManager.setDefaultProperties(Material.GLOW_BERRIES, FoodClass.FRUIT, 2, 0.4f);
        FoodPropertyManager.setDefaultProperties(Material.MELON_SLICE, FoodClass.FRUIT, 2, 1.2f);
        FoodPropertyManager.setDefaultProperties(Material.SWEET_BERRIES, FoodClass.FRUIT, 2, 0.4f);
        FoodPropertyManager.setDefaultProperties(Material.MILK_BUCKET, FoodClass.DAIRY, 0, 0.0f);
        FoodPropertyManager.setDefaultProperties(Material.POTION, FoodClass.BEVERAGE, 0, 0.0f);
        FOOD_CLASS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "food_class");
        FOOD_VALUE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "food_value");
        SATURATION_VALUE = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "saturation_value");
        CANCEL_POTION_EFFECTS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "cancel_potion_effects");
        CANCEL_DIMINISHING_RETURNS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "cancel_diminishing_returns");
    }

    private record FoodProperties(FoodClass type, int food, float saturation) {
    }
}

