/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.util.List;
import me.athlaeos.valhallammo.item.ItemBuilder;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class MetaHandler {
    public abstract boolean hasDisplayName();

    public abstract String getDisplayName();

    public abstract void setDisplayName(String var1);

    public abstract boolean hasLore();

    public abstract List<String> getLore();

    public abstract void setLore(List<String> var1);

    public abstract ItemMeta getMeta();

    public static MetaHandler of(ItemMeta meta) {
        return new ItemMetaHandler(meta);
    }

    public static MetaHandler of(ItemBuilder itemBuilder) {
        return new ItemBuilderMetaHandler(itemBuilder);
    }

    private static class ItemMetaHandler
    extends MetaHandler {
        private final ItemMeta meta;

        public ItemMetaHandler(ItemMeta meta) {
            this.meta = meta;
        }

        @Override
        public boolean hasDisplayName() {
            return this.meta.hasDisplayName();
        }

        @Override
        public String getDisplayName() {
            return this.meta.getDisplayName();
        }

        @Override
        public void setDisplayName(String name) {
            this.meta.setDisplayName(name);
        }

        @Override
        public boolean hasLore() {
            return this.meta.hasLore();
        }

        @Override
        public List<String> getLore() {
            return this.meta.getLore();
        }

        @Override
        public void setLore(List<String> lore) {
            this.meta.setLore(lore);
        }

        @Override
        public ItemMeta getMeta() {
            return this.meta;
        }
    }

    private static class ItemBuilderMetaHandler
    extends MetaHandler {
        private final ItemBuilder itemBuilder;

        public ItemBuilderMetaHandler(ItemBuilder itemBuilder) {
            this.itemBuilder = itemBuilder;
        }

        @Override
        public boolean hasDisplayName() {
            return this.getDisplayName() != null;
        }

        @Override
        public String getDisplayName() {
            return this.itemBuilder.getName();
        }

        @Override
        public void setDisplayName(String name) {
            this.itemBuilder.name(name);
        }

        @Override
        public boolean hasLore() {
            return this.getLore() != null;
        }

        @Override
        public List<String> getLore() {
            return this.itemBuilder.getLore();
        }

        @Override
        public void setLore(List<String> lore) {
            this.itemBuilder.lore(lore);
        }

        @Override
        public ItemMeta getMeta() {
            return this.itemBuilder.getMeta();
        }
    }
}

