/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.item;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTrigger;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTriggerRegistry;
import me.athlaeos.valhallammo.utility.StringUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PermanentPotionEffects {
    private static final NamespacedKey PERMANENT_EFFECTS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "permanent_potion_effects");
    private static final AdditionType additionType = Catch.catchOrElse(() -> AdditionType.valueOf(ValhallaMMO.getPluginConfig().getString("permanent_effect_stacking", "HIGHEST")), AdditionType.HIGHEST, "Invalid permanent_effect_stacking value given in config.yml");
    private static final Collection<UUID> entitiesWithPermanentEffects = new HashSet<UUID>();
    private static final Map<String, Integer> triggerDelay = new HashMap<String, Integer>();

    public static void initializeRunnable() {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskTimer((Plugin)ValhallaMMO.getInstance(), () -> {
            HashMap<String, Integer> triggersToDelay = new HashMap<String, Integer>();
            for (UUID uuid : new HashSet<UUID>(entitiesWithPermanentEffects)) {
                LivingEntity l;
                block9: {
                    Entity e;
                    block8: {
                        Player p;
                        e = ValhallaMMO.getInstance().getServer().getEntity(uuid);
                        if (e == null || !e.isValid() || e.isDead() || !(e instanceof LivingEntity)) break block8;
                        l = (LivingEntity)e;
                        if (!(e instanceof Player) || (p = (Player)e).isOnline()) break block9;
                    }
                    entitiesWithPermanentEffects.remove(uuid);
                    if (!(e instanceof LivingEntity)) continue;
                    LivingEntity l2 = (LivingEntity)e;
                    EffectTriggerRegistry.setEntityTriggerTypesAffected(l2, new ArrayList<String>());
                    continue;
                }
                EntityProperties properties = EntityCache.getAndCacheProperties(l);
                Map<String, List<PotionEffectWrapper>> permanentEffects = properties.getPermanentPotionEffects();
                if (permanentEffects.isEmpty()) {
                    entitiesWithPermanentEffects.remove(uuid);
                    continue;
                }
                for (String triggerID : new HashSet<String>(permanentEffects.keySet())) {
                    EffectTrigger trigger = EffectTriggerRegistry.getTrigger(triggerID);
                    if (!(trigger instanceof EffectTrigger.ConstantTrigger)) continue;
                    EffectTrigger.ConstantTrigger constantTrigger = (EffectTrigger.ConstantTrigger)trigger;
                    triggersToDelay.put(triggerID, constantTrigger.tickDelay());
                    if (triggerDelay.getOrDefault(triggerID, 0) > 0 || !constantTrigger.shouldTrigger(l)) continue;
                    trigger.trigger(l, permanentEffects.getOrDefault(triggerID, new ArrayList()));
                }
            }
            for (String trigger : new HashSet(triggersToDelay.keySet())) {
                int existingDelay = triggerDelay.getOrDefault(trigger, 0);
                if (existingDelay > 0) {
                    triggerDelay.put(trigger, existingDelay - 10);
                    continue;
                }
                triggerDelay.put(trigger, existingDelay + (Integer)triggersToDelay.get(trigger));
            }
        }, 10L, 10L);
    }

    public static Map<String, List<PotionEffectWrapper>> fromString(String str) {
        String[] effectStrings;
        HashMap<String, List<PotionEffectWrapper>> effects = new HashMap<String, List<PotionEffectWrapper>>();
        if (StringUtils.isEmpty(str)) {
            return effects;
        }
        for (String s : effectStrings = str.split(";")) {
            int duration;
            PotionEffectWrapper wrapper;
            double amplifier;
            String[] args = s.split(":");
            if (args.length <= 1 || (amplifier = Catch.catchOrElse(() -> Double.parseDouble(args[1]), -1.0).doubleValue()) < 0.0 || (wrapper = (PotionEffectWrapper)Catch.catchOrElse(() -> PotionEffectRegistry.getEffect(args[0]), null)) == null) continue;
            int n = args.length > 2 ? Catch.catchOrElse(() -> Integer.parseInt(args[2]), 0) : (duration = args[0].equals("NIGHT_VISION") ? 300 : 100);
            if (duration == 0) continue;
            wrapper.setDuration(duration);
            wrapper.setAmplifier(amplifier);
            String trigger = args.length > 3 ? args[3] : "constant";
            List existingWrappers = effects.getOrDefault(trigger, new ArrayList());
            existingWrappers.add(wrapper);
            effects.put(trigger, existingWrappers);
        }
        return effects;
    }

    public static Map<String, List<PotionEffectWrapper>> getPermanentPotionEffects(ItemMeta meta) {
        return PermanentPotionEffects.fromString((String)meta.getPersistentDataContainer().get(PERMANENT_EFFECTS, PersistentDataType.STRING));
    }

    public static void setPermanentPotionEffects(ItemMeta meta, Map<String, List<PotionEffectWrapper>> effects) {
        ArrayList<CallSite> dataStrings = new ArrayList<CallSite>();
        for (String trigger : effects.keySet()) {
            for (PotionEffectWrapper wrapper : (List)effects.getOrDefault(trigger, new ArrayList())) {
                dataStrings.add((CallSite)((Object)(wrapper.getEffect() + ":" + wrapper.getAmplifier() + ":" + wrapper.getDuration() + ":" + trigger)));
            }
        }
        meta.getPersistentDataContainer().set(PERMANENT_EFFECTS, PersistentDataType.STRING, (Object)String.join((CharSequence)";", dataStrings));
    }

    public static Map<String, List<PotionEffectWrapper>> getCombinedEffects(List<Map<String, List<PotionEffectWrapper>>> effects) {
        HashMap<String, Map> totalEffectAmplifiers = new HashMap<String, Map>();
        HashMap<String, Map> totalEffectDurations = new HashMap<String, Map>();
        for (Map<String, List<PotionEffectWrapper>> effectMap : effects) {
            for (String target : effectMap.keySet()) {
                List targetEffects = effectMap.getOrDefault(target, new ArrayList());
                for (PotionEffectWrapper effect : targetEffects) {
                    Map combinedAmplifiersOfTarget = totalEffectAmplifiers.getOrDefault(target, new HashMap());
                    if (effect.isVanilla()) {
                        combinedAmplifiersOfTarget.put(effect.getEffect(), additionType.get(combinedAmplifiersOfTarget.getOrDefault(effect.getEffect(), -1.0), effect.getAmplifier() + 1.0) - 1.0);
                    } else {
                        combinedAmplifiersOfTarget.put(effect.getEffect(), additionType.get(combinedAmplifiersOfTarget.getOrDefault(effect.getEffect(), 0.0), effect.getAmplifier()));
                    }
                    totalEffectAmplifiers.put(target, combinedAmplifiersOfTarget);
                    Map combinedDurationsOfTarget = totalEffectDurations.getOrDefault(target, new HashMap());
                    combinedDurationsOfTarget.put(effect.getEffect(), (int)AdditionType.HIGHEST.get(combinedDurationsOfTarget.getOrDefault(effect.getEffect(), 0).intValue(), effect.getDuration()));
                    totalEffectDurations.put(target, combinedDurationsOfTarget);
                }
            }
        }
        HashMap<String, List<PotionEffectWrapper>> finalEffects = new HashMap<String, List<PotionEffectWrapper>>();
        for (String trigger : totalEffectAmplifiers.keySet()) {
            for (String type : ((Map)totalEffectAmplifiers.getOrDefault(trigger, new HashMap())).keySet()) {
                PotionEffectWrapper effect = Catch.catchOrElse(() -> PotionEffectRegistry.getEffect(type), null);
                if (effect == null) continue;
                double amplifier = ((Map)totalEffectAmplifiers.getOrDefault(trigger, new HashMap())).getOrDefault(type, 0.0);
                int duration = ((Map)totalEffectDurations.getOrDefault(trigger, new HashMap())).getOrDefault(type, 0);
                if (duration == 0 || !effect.isVanilla() && amplifier > -1.0E-5 && amplifier < 1.0E-5) continue;
                effect.setAmplifier(amplifier);
                effect.setDuration(duration);
                List otherEffects = finalEffects.getOrDefault(trigger, new ArrayList());
                otherEffects.add(effect);
                finalEffects.put(trigger, otherEffects);
            }
        }
        return finalEffects;
    }

    public static void setHasPermanentEffects(LivingEntity l) {
        entitiesWithPermanentEffects.add(l.getUniqueId());
    }

    public static void setHasNoPermanentEffects(LivingEntity l) {
        entitiesWithPermanentEffects.remove(l.getUniqueId());
    }

    public static boolean hasPermanentEffects(LivingEntity l) {
        return entitiesWithPermanentEffects.contains(l.getUniqueId());
    }

    private static enum AdditionType {
        HIGHEST(Math::max),
        ADD(Double::sum);

        final Comparator compare;

        private AdditionType(Comparator compare) {
            this.compare = compare;
        }

        private double get(double i1, double i2) {
            return this.compare.get(i1, i2);
        }
    }

    private static interface Comparator {
        public double get(double var1, double var3);
    }
}

